/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.common.exceptions;

import java.io.Serializable;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.util.ErrorMessageUtil;

public class AlgebricksException
extends Exception
implements IFormattedException {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN = 0;
    private final String component;
    private final int errorCode;
    private final Serializable[] params;
    private final String nodeId;
    private final SourceLocation sourceLoc;
    private transient CachedMessage msgCache;

    public AlgebricksException(String component, int errorCode, String message, Throwable cause, SourceLocation sourceLoc, String nodeId, Serializable ... params) {
        super(message, cause);
        this.component = component;
        this.errorCode = errorCode;
        this.sourceLoc = sourceLoc;
        this.nodeId = nodeId;
        this.params = params;
    }

    @Deprecated
    public AlgebricksException(String message) {
        this("", 0, message, (Throwable)null, (SourceLocation)null, (Serializable[])null);
    }

    @Deprecated
    public AlgebricksException(Throwable cause) {
        this("", 0, cause.getMessage(), cause, (Serializable[])null);
    }

    @Deprecated
    public AlgebricksException(String message, Throwable cause) {
        this("", 0, message, cause, (SourceLocation)null, (Serializable[])null);
    }

    public AlgebricksException(String component, int errorCode, SourceLocation sourceLoc, Serializable ... params) {
        this(component, errorCode, (String)null, (Throwable)null, sourceLoc, (String)null, params);
    }

    public AlgebricksException(String component, int errorCode, Serializable ... params) {
        this(component, errorCode, (String)null, (Throwable)null, (SourceLocation)null, (String)null, params);
    }

    public AlgebricksException(Throwable cause, int errorCode, SourceLocation sourceLoc, Serializable ... params) {
        this("", errorCode, cause.getMessage(), cause, sourceLoc, (String)null, params);
    }

    public AlgebricksException(Throwable cause, int errorCode, Serializable ... params) {
        this("", errorCode, cause.getMessage(), cause, (SourceLocation)null, (String)null, params);
    }

    public AlgebricksException(String component, int errorCode, String message, SourceLocation sourceLoc, Serializable ... params) {
        this(component, errorCode, message, (Throwable)null, sourceLoc, (String)null, params);
    }

    public AlgebricksException(String component, int errorCode, String message, Serializable ... params) {
        this(component, errorCode, message, (Throwable)null, (SourceLocation)null, (String)null, params);
    }

    public AlgebricksException(String component, int errorCode, Throwable cause, SourceLocation sourceLoc, Serializable ... params) {
        this(component, errorCode, cause.getMessage(), cause, sourceLoc, (String)null, params);
    }

    public AlgebricksException(String component, int errorCode, Throwable cause, Serializable ... params) {
        this(component, errorCode, cause.getMessage(), cause, (SourceLocation)null, (String)null, params);
    }

    public AlgebricksException(String component, int errorCode, String message, Throwable cause, SourceLocation sourceLoc, Serializable ... params) {
        this(component, errorCode, message, cause, sourceLoc, (String)null, params);
    }

    public AlgebricksException(String component, int errorCode, String message, Throwable cause, Serializable ... params) {
        this(component, errorCode, message, cause, (SourceLocation)null, (String)null, params);
    }

    public static AlgebricksException create(int errorCode, SourceLocation sourceLoc, Serializable ... params) {
        return new AlgebricksException("HYR", errorCode, ErrorCode.getErrorMessage((int)errorCode), sourceLoc, params);
    }

    public static AlgebricksException create(int errorCode, Serializable ... params) {
        return AlgebricksException.create(errorCode, null, params);
    }

    public String getComponent() {
        return this.component;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLoc;
    }

    @Override
    public String getMessage() {
        if (this.msgCache == null) {
            this.msgCache = new CachedMessage(ErrorMessageUtil.formatMessage((String)this.component, (int)this.errorCode, (String)super.getMessage(), (SourceLocation)this.sourceLoc, (Serializable[])this.params));
        }
        return this.msgCache.message;
    }

    private static class CachedMessage {
        private final String message;

        private CachedMessage(String message) {
            this.message = message;
        }
    }
}

