/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.DataOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entitytupletranslators.AbstractDatatypeTupleTranslator;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FunctionTupleTranslator
extends AbstractDatatypeTupleTranslator<Function> {
    private static final int FUNCTION_PAYLOAD_TUPLE_FIELD_INDEX = 3;
    protected OrderedListBuilder dependenciesListBuilder;
    protected OrderedListBuilder dependencyListBuilder;
    protected OrderedListBuilder dependencyNameListBuilder;
    protected List<String> dependencySubnames;
    protected AOrderedListType stringList;
    protected AOrderedListType listOfLists;

    protected FunctionTupleTranslator(TxnId txnId, MetadataNode metadataNode, boolean getTuple) {
        super(txnId, metadataNode, getTuple, MetadataPrimaryIndexes.FUNCTION_DATASET, 3);
        if (getTuple) {
            this.dependenciesListBuilder = new OrderedListBuilder();
            this.dependencyListBuilder = new OrderedListBuilder();
            this.dependencyNameListBuilder = new OrderedListBuilder();
            this.dependencySubnames = new ArrayList<String>(3);
            this.stringList = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
            this.listOfLists = new AOrderedListType((IAType)new AOrderedListType((IAType)BuiltinType.ASTRING, null), null);
        }
    }

    @Override
    protected Function createMetadataEntityFromARecord(ARecord functionRecord) {
        String dataverseCanonicalName = ((AString)functionRecord.getValueByPos(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String functionName = ((AString)functionRecord.getValueByPos(1)).getStringValue();
        int arity = Integer.parseInt(((AString)functionRecord.getValueByPos(2)).getStringValue());
        IACursor paramNameCursor = ((AOrderedList)functionRecord.getValueByPos(3)).getCursor();
        ArrayList<String> paramNames = new ArrayList<String>();
        while (paramNameCursor.next()) {
            paramNames.add(((AString)paramNameCursor.get()).getStringValue());
        }
        List<TypeSignature> paramTypes = this.getParamTypes(functionRecord, arity, dataverseName);
        String returnTypeName = ((AString)functionRecord.getValueByPos(4)).getStringValue();
        String returnTypeDataverseNameCanonical = this.getString(functionRecord, "ReturnTypeDataverseName");
        TypeSignature returnType = this.getTypeSignature(returnTypeName, returnTypeDataverseNameCanonical, dataverseName);
        String definition = ((AString)functionRecord.getValueByPos(5)).getStringValue();
        String language = ((AString)functionRecord.getValueByPos(6)).getStringValue();
        String functionKind = ((AString)functionRecord.getValueByPos(7)).getStringValue();
        String functionLibrary = this.getString(functionRecord, "Library");
        Boolean nullCall = this.getBoolean(functionRecord, "NullCall");
        Boolean deterministic = this.getBoolean(functionRecord, "Deterministic");
        Map<String, String> resources = this.getResources(functionRecord);
        IACursor dependenciesCursor = ((AOrderedList)functionRecord.getValueByPos(8)).getCursor();
        ArrayList<List<Triple<DataverseName, String, String>>> dependencies = new ArrayList<List<Triple<DataverseName, String, String>>>();
        while (dependenciesCursor.next()) {
            ArrayList<Triple<DataverseName, String, String>> dependencyList = new ArrayList<Triple<DataverseName, String, String>>();
            IACursor qualifiedDependencyCursor = ((AOrderedList)dependenciesCursor.get()).getCursor();
            while (qualifiedDependencyCursor.next()) {
                Triple<DataverseName, String, String> dependency = this.getDependency((AOrderedList)qualifiedDependencyCursor.get());
                dependencyList.add(dependency);
            }
            dependencies.add(dependencyList);
        }
        FunctionSignature signature = new FunctionSignature(dataverseName, functionName, arity);
        return new Function(signature, paramNames, paramTypes, returnType, definition, functionKind, language, functionLibrary, nullCall, deterministic, resources, dependencies);
    }

    private List<TypeSignature> getParamTypes(ARecord functionRecord, int arity, DataverseName functionDataverseName) {
        ArrayList<TypeSignature> paramTypes = new ArrayList<TypeSignature>(arity);
        ARecordType functionRecordType = functionRecord.getType();
        int paramTypesFieldIdx = functionRecordType.getFieldIndex("ParamTypes");
        if (paramTypesFieldIdx >= 0) {
            IACursor cursor = ((AOrderedList)functionRecord.getValueByPos(paramTypesFieldIdx)).getCursor();
            while (cursor.next()) {
                ARecord paramTypeRecord = (ARecord)cursor.get();
                String paramTypeName = this.getString(paramTypeRecord, "Type");
                String paramTypeDataverseNameCanonical = this.getString(paramTypeRecord, "DataverseName");
                TypeSignature paramType = this.getTypeSignature(paramTypeName, paramTypeDataverseNameCanonical, functionDataverseName);
                paramTypes.add(paramType);
            }
        } else {
            for (int i = 0; i < arity; ++i) {
                paramTypes.add(TypeUtil.ANY_TYPE_SIGNATURE);
            }
        }
        return paramTypes;
    }

    private TypeSignature getTypeSignature(String typeName, String typeDataverseNameCanonical, DataverseName functionDataverseName) {
        if (BuiltinType.ANY.getTypeName().equals(typeName)) {
            return TypeUtil.ANY_TYPE_SIGNATURE;
        }
        BuiltinType builtinType = BuiltinTypeMap.getBuiltinType(typeName);
        if (builtinType != null) {
            return new TypeSignature(builtinType);
        }
        DataverseName typeDataverseName = typeDataverseNameCanonical == null ? functionDataverseName : DataverseName.createFromCanonicalForm((String)typeDataverseNameCanonical);
        return new TypeSignature(typeDataverseName, typeName);
    }

    private Triple<DataverseName, String, String> getDependency(AOrderedList dependencySubnames) {
        String dataverseCanonicalName = ((AString)dependencySubnames.getItem(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String second = null;
        String third = null;
        int ln = dependencySubnames.size();
        if (ln > 1) {
            second = ((AString)dependencySubnames.getItem(1)).getStringValue();
            if (ln > 2) {
                third = ((AString)dependencySubnames.getItem(2)).getStringValue();
            }
        }
        return new Triple((Object)dataverseName, (Object)second, third);
    }

    private Map<String, String> getResources(ARecord functionRecord) {
        HashMap<String, String> adaptorConfiguration = new HashMap<String, String>();
        ARecordType functionType = functionRecord.getType();
        int functionLibraryIdx = functionType.getFieldIndex("WithParams");
        if (functionLibraryIdx >= 0) {
            IACursor cursor = ((AOrderedList)functionRecord.getValueByPos(functionLibraryIdx)).getCursor();
            while (cursor.next()) {
                ARecord field = (ARecord)cursor.get();
                ARecordType fieldType = field.getType();
                int keyIdx = fieldType.getFieldIndex("name");
                String key = keyIdx >= 0 ? ((AString)field.getValueByPos(keyIdx)).getStringValue() : "";
                int valueIdx = fieldType.getFieldIndex("value");
                String value = valueIdx >= 0 ? ((AString)field.getValueByPos(valueIdx)).getStringValue() : "";
                adaptorConfiguration.put(key, value);
            }
        }
        return adaptorConfiguration;
    }

    private String getString(ARecord aRecord, String fieldName) {
        ARecordType functionType = aRecord.getType();
        int functionLibraryIdx = functionType.getFieldIndex(fieldName);
        return functionLibraryIdx >= 0 ? ((AString)aRecord.getValueByPos(functionLibraryIdx)).getStringValue() : null;
    }

    private Boolean getBoolean(ARecord aRecord, String fieldName) {
        ARecordType functionType = aRecord.getType();
        int fieldIndex = functionType.getFieldIndex(fieldName);
        return fieldIndex >= 0 ? ((ABoolean)aRecord.getValueByPos(fieldIndex)).getBoolean() : null;
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Function function) throws HyracksDataException {
        DataverseName dataverseName = function.getDataverseName();
        String dataverseCanonicalName = dataverseName.getCanonicalForm();
        this.tupleBuilder.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(function.getName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(String.valueOf(function.getArity()));
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.FUNCTION_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(String.valueOf(function.getArity()));
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.FUNCTION_RECORDTYPE.getFieldTypes()[3]));
        for (String p : function.getParameterNames()) {
            itemValue.reset();
            this.aString.setValue(p);
            this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getReturnType().getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getFunctionBody());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getLanguage());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getKind());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(7, (IValueReference)this.fieldValue);
        this.dependenciesListBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.FUNCTION_RECORDTYPE.getFieldTypes()[8]));
        List<List<Triple<DataverseName, String, String>>> dependenciesList = function.getDependencies();
        for (List<Triple<DataverseName, String, String>> dependencies : dependenciesList) {
            this.dependencyListBuilder.reset((AbstractCollectionType)this.listOfLists);
            for (Triple<DataverseName, String, String> dependency : dependencies) {
                this.dependencyNameListBuilder.reset((AbstractCollectionType)this.stringList);
                for (String subName : this.getDependencySubNames(dependency)) {
                    itemValue.reset();
                    this.aString.setValue(subName);
                    this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
                    this.dependencyNameListBuilder.addItem((IValueReference)itemValue);
                }
                itemValue.reset();
                this.dependencyNameListBuilder.write(itemValue.getDataOutput(), true);
                this.dependencyListBuilder.addItem((IValueReference)itemValue);
            }
            itemValue.reset();
            this.dependencyListBuilder.write(itemValue.getDataOutput(), true);
            this.dependenciesListBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        this.dependenciesListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(8, (IValueReference)this.fieldValue);
        this.writeOpenFields(function);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeOpenFields(Function function) throws HyracksDataException {
        this.writeReturnTypeDataverseName(function);
        this.writeParameterTypes(function);
        this.writeResources(function);
        this.writeLibrary(function);
        this.writeNullCall(function);
        this.writeDeterministic(function);
    }

    protected void writeResources(Function function) throws HyracksDataException {
        Map<String, String> withParams = function.getResources();
        if (withParams == null || withParams.isEmpty()) {
            return;
        }
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
        for (Map.Entry<String, String> property : withParams.entrySet()) {
            itemValue.reset();
            this.writePropertyTypeRecord(property.getKey(), property.getValue(), itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.fieldName.reset();
        this.aString.setValue("WithParams");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    protected void writeParameterTypes(Function function) throws HyracksDataException {
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
        for (TypeSignature paramType : function.getParameterTypes()) {
            itemValue.reset();
            this.writeTypeRecord(paramType.getDataverseName(), paramType.getName(), function.getDataverseName(), itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.fieldName.reset();
        this.aString.setValue("ParamTypes");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    protected void writeLibrary(Function function) throws HyracksDataException {
        if (function.getLibrary() == null) {
            return;
        }
        this.fieldName.reset();
        this.aString.setValue("Library");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(function.getLibrary());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    protected void writeReturnTypeDataverseName(Function function) throws HyracksDataException {
        boolean skipReturnTypeDataverseName;
        DataverseName returnTypeDataverseName = function.getReturnType().getDataverseName();
        boolean bl = skipReturnTypeDataverseName = returnTypeDataverseName == null || returnTypeDataverseName.equals((Object)function.getDataverseName());
        if (!skipReturnTypeDataverseName) {
            this.fieldName.reset();
            this.aString.setValue("ReturnTypeDataverseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(returnTypeDataverseName.getCanonicalForm());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }

    protected void writeNullCall(Function function) throws HyracksDataException {
        if (function.getNullCall() == null) {
            return;
        }
        this.fieldName.reset();
        this.aString.setValue("NullCall");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.booleanSerde.serialize((Object)ABoolean.valueOf((boolean)function.getNullCall()), this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    protected void writeDeterministic(Function function) throws HyracksDataException {
        if (function.getDeterministic() == null) {
            return;
        }
        this.fieldName.reset();
        this.aString.setValue("Deterministic");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.booleanSerde.serialize((Object)ABoolean.valueOf((boolean)function.getDeterministic()), this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    public void writePropertyTypeRecord(String name, String value, DataOutput out) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        propertyRecordBuilder.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.fieldName.reset();
        this.aString.setValue("Name");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(name);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        propertyRecordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        this.fieldName.reset();
        this.aString.setValue("Value");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(value);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        propertyRecordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        propertyRecordBuilder.write(out, true);
    }

    public void writeTypeRecord(DataverseName typeDataverseName, String typeName, DataverseName functionDataverseName, DataOutput out) throws HyracksDataException {
        boolean skipTypeDataverseName;
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        propertyRecordBuilder.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.fieldName.reset();
        this.aString.setValue("Type");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(typeName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        propertyRecordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        boolean bl = skipTypeDataverseName = typeDataverseName == null || typeDataverseName.equals((Object)functionDataverseName);
        if (!skipTypeDataverseName) {
            this.fieldName.reset();
            this.aString.setValue("DataverseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(typeDataverseName.getCanonicalForm());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            propertyRecordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
        propertyRecordBuilder.write(out, true);
    }

    private List<String> getDependencySubNames(Triple<DataverseName, String, String> dependency) {
        this.dependencySubnames.clear();
        this.dependencySubnames.add(((DataverseName)dependency.first).getCanonicalForm());
        if (dependency.second != null) {
            this.dependencySubnames.add((String)dependency.second);
        }
        if (dependency.third != null) {
            this.dependencySubnames.add((String)dependency.third);
        }
        return this.dependencySubnames;
    }
}

