/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.meta;

import java.io.DataOutput;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.PipelineAssembler;
import org.apache.hyracks.algebricks.runtime.operators.std.NestedTupleSourceRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;

public class SubplanRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final List<AlgebricksPipeline> pipelines;
    private final RecordDescriptor inputRecordDesc;
    private final RecordDescriptor outputRecordDesc;
    private final IMissingWriterFactory[] missingWriterFactories;

    public SubplanRuntimeFactory(List<AlgebricksPipeline> pipelines, IMissingWriterFactory[] missingWriterFactories, RecordDescriptor inputRecordDesc, RecordDescriptor outputRecordDesc, int[] projectionList) {
        super(projectionList);
        this.pipelines = pipelines;
        this.missingWriterFactories = missingWriterFactories;
        this.inputRecordDesc = inputRecordDesc;
        this.outputRecordDesc = outputRecordDesc;
        if (projectionList != null) {
            throw new NotImplementedException();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Subplan { \n");
        for (AlgebricksPipeline pipeline : this.pipelines) {
            sb.append('{');
            for (IPushRuntimeFactory f : pipeline.getRuntimeFactories()) {
                sb.append("  ").append(f).append(";\n");
            }
            sb.append('}');
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public AbstractOneInputOneOutputPushRuntime createOneOutputPushRuntime(IHyracksTaskContext ctx) throws HyracksDataException {
        return new SubplanPushRuntime(ctx);
    }

    private class SubplanPushRuntime
    extends AbstractOneInputOneOutputOneFramePushRuntime {
        final IHyracksTaskContext ctx;
        final NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] startOfPipelines;
        boolean first;

        SubplanPushRuntime(IHyracksTaskContext ctx) throws HyracksDataException {
            this.ctx = ctx;
            this.first = true;
            IMissingWriter[] missingWriters = new IMissingWriter[SubplanRuntimeFactory.this.missingWriterFactories.length];
            for (int i = 0; i < SubplanRuntimeFactory.this.missingWriterFactories.length; ++i) {
                missingWriters[i] = SubplanRuntimeFactory.this.missingWriterFactories[i].createMissingWriter();
            }
            int pipelineCount = SubplanRuntimeFactory.this.pipelines.size();
            this.startOfPipelines = new NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[pipelineCount];
            PipelineAssembler[] pipelineAssemblers = new PipelineAssembler[pipelineCount];
            for (int i = 0; i < pipelineCount; ++i) {
                RecordDescriptor outputRecordDescriptor;
                Object outputWriter;
                AlgebricksPipeline pipeline = (AlgebricksPipeline)SubplanRuntimeFactory.this.pipelines.get(i);
                RecordDescriptor pipelineLastRecordDescriptor = pipeline.getRecordDescriptors()[pipeline.getRecordDescriptors().length - 1];
                if (i == 0) {
                    outputWriter = new TupleOuterProduct(pipelineLastRecordDescriptor, missingWriters);
                    outputRecordDescriptor = SubplanRuntimeFactory.this.outputRecordDesc;
                } else {
                    IPushRuntime outputPushRuntime = this.linkSecondaryPipeline(pipeline, pipelineAssemblers, i);
                    if (outputPushRuntime == null) {
                        throw new IllegalStateException("Invalid pipeline");
                    }
                    outputPushRuntime.setInputRecordDescriptor(0, pipelineLastRecordDescriptor);
                    outputWriter = outputPushRuntime;
                    outputRecordDescriptor = pipelineLastRecordDescriptor;
                }
                PipelineAssembler pa = new PipelineAssembler(pipeline, 1, 1, this.inputRecordDesc, outputRecordDescriptor);
                this.startOfPipelines[i] = (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime)pa.assemblePipeline((IFrameWriter)outputWriter, ctx);
                pipelineAssemblers[i] = pa;
            }
        }

        IPushRuntime linkSecondaryPipeline(AlgebricksPipeline pipeline, PipelineAssembler[] pipelineAssemblers, int pipelineAssemblersCount) {
            IPushRuntimeFactory[] outputRuntimeFactories = pipeline.getOutputRuntimeFactories();
            if (outputRuntimeFactories == null || outputRuntimeFactories.length != 1) {
                throw new IllegalStateException();
            }
            IPushRuntimeFactory outRuntimeFactory = outputRuntimeFactories[0];
            int outputPosition = pipeline.getOutputPositions()[0];
            for (int i = 0; i < pipelineAssemblersCount; ++i) {
                IPushRuntime[] p = pipelineAssemblers[i].getPushRuntime(outRuntimeFactory);
                if (p == null) continue;
                return p[outputPosition];
            }
            return null;
        }

        @Override
        public void open() throws HyracksDataException {
            super.open();
            if (this.first) {
                this.first = false;
                this.initAccessAppendRef(this.ctx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            this.tAccess.reset(buffer);
            int nTuple = this.tAccess.getTupleCount();
            for (int t = 0; t < nTuple; ++t) {
                this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                for (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime nts : this.startOfPipelines) {
                    nts.writeTuple(buffer, t);
                }
                try {
                    for (int n = 0; n < this.startOfPipelines.length; ++n) {
                        NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime nts = this.startOfPipelines[n];
                        try {
                            nts.open();
                            continue;
                        }
                        catch (Exception e) {
                            nts.fail();
                            throw e;
                        }
                    }
                    continue;
                }
                finally {
                    for (int i = n - 1; i >= 0; --i) {
                        this.startOfPipelines[i].close();
                    }
                }
            }
        }

        public void flush() throws HyracksDataException {
            this.writer.flush();
        }

        class TupleOuterProduct
        implements IFrameWriter {
            private boolean smthWasWritten;
            private final FrameTupleAccessor ta;
            private final ArrayTupleBuilder tb;
            private final IMissingWriter[] missingWriters;

            private TupleOuterProduct(RecordDescriptor recordDescriptor, IMissingWriter[] missingWriters) {
                this.ta = new FrameTupleAccessor(recordDescriptor);
                this.tb = new ArrayTupleBuilder(missingWriters.length + SubplanRuntimeFactory.this.inputRecordDesc.getFieldCount());
                this.missingWriters = missingWriters;
            }

            public void open() throws HyracksDataException {
                this.smthWasWritten = false;
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.ta.reset(buffer);
                int nTuple = this.ta.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    SubplanPushRuntime.this.appendConcat(SubplanPushRuntime.this.tRef.getFrameTupleAccessor(), SubplanPushRuntime.this.tRef.getTupleIndex(), (IFrameTupleAccessor)this.ta, t);
                }
                this.smthWasWritten = true;
            }

            public void close() throws HyracksDataException {
                if (!this.smthWasWritten && !SubplanPushRuntime.this.failed) {
                    this.appendNullsToTuple();
                    SubplanPushRuntime.this.appendToFrameFromTupleBuilder(this.tb);
                }
            }

            public void fail() throws HyracksDataException {
            }

            private void appendNullsToTuple() throws HyracksDataException {
                this.tb.reset();
                int n0 = SubplanPushRuntime.this.tRef.getFieldCount();
                for (int f = 0; f < n0; ++f) {
                    this.tb.addField(SubplanPushRuntime.this.tRef.getFrameTupleAccessor(), SubplanPushRuntime.this.tRef.getTupleIndex(), f);
                }
                DataOutput dos = this.tb.getDataOutput();
                for (IMissingWriter missingWriter : this.missingWriters) {
                    missingWriter.writeMissing(dos);
                    this.tb.addFieldEndOffset();
                }
            }
        }
    }
}

