/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

final class LockManagerStats {
    private final int loggingPeriod;
    private final AtomicLong lCnt = new AtomicLong();
    private final AtomicLong ilCnt = new AtomicLong();
    private final AtomicLong tlCnt = new AtomicLong();
    private final AtomicLong itlCnt = new AtomicLong();
    private final AtomicLong ulCnt = new AtomicLong();
    private final AtomicLong rlCnt = new AtomicLong();

    LockManagerStats(int loggingPeriod) {
        this.loggingPeriod = loggingPeriod;
    }

    final void lock() {
        this.lCnt.incrementAndGet();
    }

    final void instantLock() {
        this.ilCnt.incrementAndGet();
    }

    final void tryLock() {
        this.tlCnt.incrementAndGet();
    }

    final void instantTryLock() {
        this.itlCnt.incrementAndGet();
    }

    final void unlock() {
        this.ulCnt.incrementAndGet();
    }

    final void releaseLocks() {
        this.rlCnt.incrementAndGet();
    }

    final int requestSum() {
        return this.lCnt.intValue() + this.ilCnt.intValue() + this.tlCnt.intValue() + this.itlCnt.intValue() + this.ulCnt.intValue() + this.rlCnt.intValue();
    }

    final StringBuilder append(StringBuilder sb) {
        sb.append("{").append(" lock : ").append(this.lCnt).append(", instantLock : ").append(this.ilCnt).append(", tryLock : ").append(this.tlCnt).append(", instantTryLock : ").append(this.itlCnt).append(", unlock : ").append(this.ulCnt).append(", releaseLocks : ").append(this.rlCnt).append(" }");
        return sb;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }

    final void logCounters(Logger logger, Level lvl, boolean always) {
        if (logger.isEnabled(lvl) && (always || this.requestSum() % this.loggingPeriod == 0)) {
            logger.log(lvl, this.toString());
        }
    }
}

