/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.rewriter.base;

import java.util.Collection;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.util.LogRedactionUtil;

public abstract class AbstractRuleController {
    protected IOptimizationContext context;

    public void setContext(IOptimizationContext context) {
        this.context = context;
    }

    public abstract boolean rewriteWithRuleCollection(Mutable<ILogicalOperator> var1, Collection<IAlgebraicRewriteRule> var2) throws AlgebricksException;

    protected boolean rewriteOperatorRef(Mutable<ILogicalOperator> opRef, IAlgebraicRewriteRule rule) throws AlgebricksException {
        return this.rewriteOperatorRef(opRef, rule, true, false);
    }

    private String getPlanString(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled() && this.context != null) {
            IPlanPrettyPrinter prettyPrinter = this.context.getPrettyPrinter();
            return prettyPrinter.reset().printOperator((AbstractLogicalOperator)opRef.getValue()).toString();
        }
        return null;
    }

    private void printRuleApplication(IAlgebraicRewriteRule rule, String beforePlan, String afterPlan) {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">> Rule " + rule.getClass() + " fired.\n");
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">> Before plan\n" + LogRedactionUtil.userData((String)beforePlan) + "\n");
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">> After plan\n" + LogRedactionUtil.userData((String)afterPlan) + "\n");
        }
    }

    protected boolean rewriteOperatorRef(Mutable<ILogicalOperator> opRef, IAlgebraicRewriteRule rule, boolean enterNestedPlans, boolean fullDFS) throws AlgebricksException {
        String preBeforePlan = this.getPlanString(opRef);
        if (rule.rewritePre(opRef, this.context)) {
            String preAfterPlan = this.getPlanString(opRef);
            this.printRuleApplication(rule, preBeforePlan, preAfterPlan);
            return true;
        }
        boolean rewritten = false;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        for (Mutable<ILogicalOperator> mutable : op.getInputs()) {
            if (!this.rewriteOperatorRef(mutable, rule, enterNestedPlans, fullDFS)) continue;
            rewritten = true;
            if (fullDFS) continue;
            break;
        }
        if (op.hasNestedPlans() && enterNestedPlans) {
            AbstractOperatorWithNestedPlans o2 = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : o2.getNestedPlans()) {
                for (Mutable<ILogicalOperator> r : p.getRoots()) {
                    if (!this.rewriteOperatorRef(r, rule, enterNestedPlans, fullDFS)) continue;
                    rewritten = true;
                    if (fullDFS) continue;
                    break;
                }
                if (!rewritten || fullDFS) continue;
                break;
            }
        }
        String postBeforePlan = this.getPlanString(opRef);
        if (rule.rewritePost(opRef, this.context)) {
            String string = this.getPlanString(opRef);
            this.printRuleApplication(rule, postBeforePlan, string);
            return true;
        }
        return rewritten;
    }
}

