/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.jobgen.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;

public class OperatorSchemaImpl
implements IOperatorSchema {
    private final Map<LogicalVariable, Integer> varMap = new HashMap<LogicalVariable, Integer>();
    private final List<LogicalVariable> varList = new ArrayList<LogicalVariable>();

    @Override
    public void addAllVariables(IOperatorSchema source) {
        for (LogicalVariable v : source) {
            this.varMap.put(v, this.varList.size());
            this.varList.add(v);
        }
    }

    @Override
    public void addAllNewVariables(IOperatorSchema source) {
        for (LogicalVariable v : source) {
            if (this.varMap.get(v) != null) continue;
            this.varMap.put(v, this.varList.size());
            this.varList.add(v);
        }
    }

    @Override
    public int addVariable(LogicalVariable var) {
        int idx = this.varList.size();
        this.varMap.put(var, idx);
        this.varList.add(var);
        return idx;
    }

    @Override
    public void clear() {
        this.varMap.clear();
        this.varList.clear();
    }

    @Override
    public int findVariable(LogicalVariable var) {
        Integer i = this.varMap.get(var);
        if (i == null) {
            return -1;
        }
        return i;
    }

    @Override
    public int getSize() {
        return this.varList.size();
    }

    @Override
    public LogicalVariable getVariable(int index) {
        return this.varList.get(index);
    }

    @Override
    public Iterator<LogicalVariable> iterator() {
        return this.varList.iterator();
    }

    public String toString() {
        return this.varMap.toString();
    }
}

