/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;

public class PropertiesUtil {
    public Set<LogicalVariable> closureUnderFDs(Collection<LogicalVariable> vars, List<FunctionalDependency> fdList) {
        boolean change;
        ListSet k = new ListSet(vars);
        do {
            change = false;
            for (FunctionalDependency fd : fdList) {
                List<LogicalVariable> h = fd.getHead();
                if (!k.containsAll(h)) continue;
                List<LogicalVariable> t = fd.getTail();
                for (LogicalVariable v : t) {
                    if (k.contains(v)) continue;
                    k.add(v);
                    change = true;
                }
            }
        } while (change);
        return k;
    }

    public static boolean matchLocalProperties(List<ILocalStructuralProperty> reqd, List<ILocalStructuralProperty> dlvd, Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        if (reqd == null) {
            return true;
        }
        if (dlvd == null) {
            return false;
        }
        return PropertiesUtil.matchNormalizedLocalProperties(PropertiesUtil.normalizeLocals(reqd, equivalenceClasses, fds), PropertiesUtil.normalizeLocals(dlvd, equivalenceClasses, fds));
    }

    private static boolean matchNormalizedLocalProperties(List<ILocalStructuralProperty> reqs, List<ILocalStructuralProperty> dlvds) {
        boolean hasOrderPropertyInReq = false;
        boolean hasGroupingPropertyInReq = false;
        boolean orderPropertyMet = false;
        boolean groupingPropertyMet = false;
        for (ILocalStructuralProperty req : reqs) {
            ILocalStructuralProperty.PropertyType reqType = req.getPropertyType();
            hasOrderPropertyInReq |= reqType == ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY;
            hasGroupingPropertyInReq |= reqType == ILocalStructuralProperty.PropertyType.LOCAL_GROUPING_PROPERTY;
            for (ILocalStructuralProperty dlvd : dlvds) {
                ILocalStructuralProperty.PropertyType dlvdType = dlvd.getPropertyType();
                if (reqType == ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY && dlvdType != ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) continue;
                if (reqType == ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) {
                    LocalOrderProperty lop = (LocalOrderProperty)dlvd;
                    orderPropertyMet |= lop.implies(req);
                    continue;
                }
                ListSet reqdCols = new ListSet();
                ListSet dlvdCols = new ListSet();
                req.getColumns((Collection<LogicalVariable>)reqdCols);
                dlvd.getColumns((Collection<LogicalVariable>)dlvdCols);
                groupingPropertyMet |= PropertiesUtil.isPrefixOf(reqdCols.iterator(), dlvdCols.iterator());
            }
        }
        return !(hasOrderPropertyInReq && !orderPropertyMet || hasGroupingPropertyInReq && !groupingPropertyMet);
    }

    public static boolean matchPartitioningProps(IPartitioningProperty reqd, IPartitioningProperty dlvd, boolean mayExpandProperties) {
        INodeDomain dom2;
        INodeDomain dom1 = reqd.getNodeDomain();
        if (!dom1.sameAs(dom2 = dlvd.getNodeDomain())) {
            return false;
        }
        switch (reqd.getPartitioningType()) {
            case RANDOM: {
                return true;
            }
            case UNORDERED_PARTITIONED: {
                switch (dlvd.getPartitioningType()) {
                    case UNORDERED_PARTITIONED: {
                        UnorderedPartitionedProperty ur = (UnorderedPartitionedProperty)reqd;
                        UnorderedPartitionedProperty ud = (UnorderedPartitionedProperty)dlvd;
                        if (mayExpandProperties) {
                            return !ud.getColumnSet().isEmpty() && ur.getColumnSet().containsAll(ud.getColumnSet());
                        }
                        return ud.getColumnSet().equals(ur.getColumnSet());
                    }
                }
                return false;
            }
            case ORDERED_PARTITIONED: {
                switch (dlvd.getPartitioningType()) {
                    case ORDERED_PARTITIONED: {
                        OrderedPartitionedProperty or = (OrderedPartitionedProperty)reqd;
                        OrderedPartitionedProperty od = (OrderedPartitionedProperty)dlvd;
                        if (or.getRangeMap() != null || od.getRangeMap() != null) {
                            return false;
                        }
                        if (mayExpandProperties) {
                            return PropertiesUtil.isPrefixOf(od.getOrderColumns().iterator(), or.getOrderColumns().iterator());
                        }
                        return od.getOrderColumns().equals(or.getOrderColumns());
                    }
                }
                return false;
            }
        }
        return dlvd.getPartitioningType() == reqd.getPartitioningType();
    }

    private static List<LogicalVariable> orderColumnsToVariables(List<OrderColumn> orderColumns) {
        ArrayList<LogicalVariable> columns = new ArrayList<LogicalVariable>();
        for (OrderColumn oc : orderColumns) {
            columns.add(oc.getColumn());
        }
        return columns;
    }

    public static <T> boolean isPrefixOf(Iterator<T> pref, Iterator<T> target) {
        while (pref.hasNext()) {
            T v = pref.next();
            if (!target.hasNext()) {
                return false;
            }
            if (v.equals(target.next())) continue;
            return false;
        }
        return true;
    }

    public static List<OrderColumn> applyFDsToOrderColumns(List<OrderColumn> orderColumns, List<FunctionalDependency> functionalDependencies) {
        if (functionalDependencies == null || functionalDependencies.isEmpty()) {
            return orderColumns;
        }
        int deleted = 0;
        boolean[] removedColumns = new boolean[orderColumns.size()];
        block0: for (int i = orderColumns.size() - 1; i >= 0; --i) {
            for (FunctionalDependency functionalDependency : functionalDependencies) {
                if (!PropertiesUtil.impliedByPrefix(orderColumns, i, functionalDependency)) continue;
                removedColumns[i] = true;
                ++deleted;
                continue block0;
            }
        }
        ArrayList<OrderColumn> normalizedColumns = new ArrayList<OrderColumn>(orderColumns.size() - deleted);
        for (int i = 0; i < orderColumns.size(); ++i) {
            if (removedColumns[i]) continue;
            normalizedColumns.add(orderColumns.get(i));
        }
        return normalizedColumns;
    }

    public static List<OrderColumn> replaceOrderColumnsByEqClasses(List<OrderColumn> orderColumns, Map<LogicalVariable, EquivalenceClass> equivalenceClasses) {
        if (equivalenceClasses == null || equivalenceClasses.isEmpty()) {
            return orderColumns;
        }
        ArrayList<OrderColumn> norm = new ArrayList<OrderColumn>();
        for (OrderColumn orderColumn : orderColumns) {
            EquivalenceClass columnEQClass = equivalenceClasses.get(orderColumn.getColumn());
            if (columnEQClass == null) {
                norm.add(orderColumn);
                continue;
            }
            if (columnEQClass.representativeIsConst()) continue;
            norm.add(new OrderColumn(columnEQClass.getVariableRepresentative(), orderColumn.getOrder()));
        }
        return norm;
    }

    private static boolean impliedByPrefix(List<OrderColumn> vars, int i, FunctionalDependency fdep) {
        if (!fdep.getTail().contains(vars.get(i).getColumn())) {
            return false;
        }
        boolean fdSat = true;
        for (LogicalVariable pv : fdep.getHead()) {
            boolean isInPrefix = false;
            for (int j = 0; j < i; ++j) {
                if (!vars.get(j).getColumn().equals(pv)) continue;
                isInPrefix = true;
                break;
            }
            if (isInPrefix) continue;
            fdSat = false;
            break;
        }
        return fdSat;
    }

    private static List<ILocalStructuralProperty> normalizeLocals(List<ILocalStructuralProperty> props, Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        ArrayList<ILocalStructuralProperty> normalizedLocalProperties = new ArrayList<ILocalStructuralProperty>();
        for (ILocalStructuralProperty prop : props) {
            normalizedLocalProperties.add(prop.normalize(equivalenceClasses, fds));
        }
        return normalizedLocalProperties;
    }
}

