/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.data.partition.range.DynamicRangeMapSupplier;
import org.apache.hyracks.dataflow.common.data.partition.range.FieldRangePartitionComputerFactory;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMapSupplier;
import org.apache.hyracks.dataflow.common.data.partition.range.StaticRangeMapSupplier;
import org.apache.hyracks.dataflow.std.connectors.MToNPartitioningConnectorDescriptor;

public class RangePartitionExchangePOperator
extends AbstractExchangePOperator {
    private List<OrderColumn> partitioningFields;
    private INodeDomain domain;
    private RangeMap rangeMap;
    private final boolean rangeMapIsComputedAtRunTime;
    private final String rangeMapKeyInContext;

    private RangePartitionExchangePOperator(List<OrderColumn> partitioningFields, INodeDomain domain, RangeMap rangeMap, boolean rangeMapIsComputedAtRunTime, String rangeMapKeyInContext) {
        this.partitioningFields = partitioningFields;
        this.domain = domain;
        this.rangeMap = rangeMap;
        this.rangeMapIsComputedAtRunTime = rangeMapIsComputedAtRunTime;
        this.rangeMapKeyInContext = rangeMapKeyInContext;
    }

    public RangePartitionExchangePOperator(List<OrderColumn> partitioningFields, String rangeMapKeyInContext, INodeDomain domain) {
        this(partitioningFields, domain, null, true, rangeMapKeyInContext);
    }

    public RangePartitionExchangePOperator(List<OrderColumn> partitioningFields, INodeDomain domain, RangeMap rangeMap) {
        this(partitioningFields, domain, rangeMap, false, "");
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.RANGE_PARTITION_EXCHANGE;
    }

    public List<OrderColumn> getPartitioningFields() {
        return this.partitioningFields;
    }

    public INodeDomain getDomain() {
        return this.domain;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        OrderedPartitionedProperty p = new OrderedPartitionedProperty(new ArrayList<OrderColumn>(this.partitioningFields), this.domain, this.rangeMap);
        this.deliveredProperties = new StructuralPropertiesVector(p, new LinkedList<ILocalStructuralProperty>());
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        return this.emptyUnaryRequirements();
    }

    @Override
    public Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> createConnectorDescriptor(IConnectorDescriptorRegistry spec, ILogicalOperator op, IOperatorSchema opSchema, JobGenContext context) throws AlgebricksException {
        int n = this.partitioningFields.size();
        int[] sortFields = new int[n];
        IBinaryComparatorFactory[] comps = new IBinaryComparatorFactory[n];
        IVariableTypeEnvironment env = context.getTypeEnvironment(op);
        int i = 0;
        for (OrderColumn oc : this.partitioningFields) {
            LogicalVariable var = oc.getColumn();
            sortFields[i] = opSchema.findVariable(var);
            Object type = env.getVarType(var);
            IBinaryComparatorFactoryProvider bcfp = context.getBinaryComparatorFactoryProvider();
            comps[i] = bcfp.getBinaryComparatorFactory(type, oc.getOrder() == OrderOperator.IOrder.OrderKind.ASC);
            ++i;
        }
        DynamicRangeMapSupplier rangeMapSupplier = this.rangeMapIsComputedAtRunTime ? new DynamicRangeMapSupplier(this.rangeMapKeyInContext) : new StaticRangeMapSupplier(this.rangeMap);
        FieldRangePartitionComputerFactory partitionerFactory = new FieldRangePartitionComputerFactory(sortFields, comps, (RangeMapSupplier)rangeMapSupplier, op.getSourceLocation());
        MToNPartitioningConnectorDescriptor conn = new MToNPartitioningConnectorDescriptor(spec, (ITuplePartitionComputerFactory)partitionerFactory);
        return new Pair((Object)conn, null);
    }

    @Override
    public String toString() {
        return this.getOperatorTag().toString() + " " + this.partitioningFields + (this.rangeMap != null ? " RANGE_MAP:" + this.rangeMap : "");
    }
}

