/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.provider;

import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IExternalIndexer;
import org.apache.asterix.external.indexing.FileOffsetIndexer;
import org.apache.asterix.external.indexing.RecordColumnarIndexer;

public class ExternalIndexerProvider {
    public static IExternalIndexer getIndexer(Map<String, String> configuration) throws AsterixException {
        String inputFormatParameter = configuration.get("input-format").trim();
        if (inputFormatParameter.equalsIgnoreCase("text-input-format") || inputFormatParameter.equalsIgnoreCase("org.apache.hadoop.mapred.TextInputFormat") || inputFormatParameter.equalsIgnoreCase("sequence-input-format") || inputFormatParameter.equalsIgnoreCase("org.apache.hadoop.mapred.SequenceFileInputFormat")) {
            return new FileOffsetIndexer();
        }
        if (inputFormatParameter.equalsIgnoreCase("rc-input-format") || inputFormatParameter.equalsIgnoreCase("org.apache.asterix.hivecompat.io.RCFileInputFormat")) {
            return new RecordColumnarIndexer();
        }
        throw new AsterixException("Unable to create indexer for data with format: " + inputFormatParameter);
    }
}

