/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.LibraryDescriptor;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.operators.AbstractLibraryOperatorDescriptor;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibraryDeployPrepareOperatorDescriptor
extends AbstractLibraryOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private static final int DOWNLOAD_RETRY_COUNT = 10;
    private static final Logger LOGGER = LogManager.getLogger(LibraryDeployPrepareOperatorDescriptor.class);
    private final ExternalFunctionLanguage language;
    private final URI libLocation;
    private final String authToken;

    public LibraryDeployPrepareOperatorDescriptor(IOperatorDescriptorRegistry spec, DataverseName dataverseName, String libraryName, ExternalFunctionLanguage language, URI libLocation, String authToken) {
        super(spec, dataverseName, libraryName);
        this.language = language;
        this.libLocation = libLocation;
        this.authToken = authToken;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new AbstractLibraryOperatorDescriptor.AbstractLibraryNodePushable(ctx){
            private byte[] copyBuffer;

            @Override
            protected void execute() throws IOException {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Prepare deployment of library {}.{}", (Object)LibraryDeployPrepareOperatorDescriptor.this.dataverseName, (Object)LibraryDeployPrepareOperatorDescriptor.this.libraryName);
                }
                FileReference libDir = this.getLibraryDir();
                Path libDirPath = libDir.getFile().toPath();
                FileReference stage = this.getStageDir();
                if (Files.isDirectory(libDirPath, new LinkOption[0])) {
                    this.dropIfExists(stage);
                } else {
                    this.dropIfExists(libDir);
                    FileUtil.forceMkdirs((File)libDir.getFile());
                    Path dataverseDir = libDirPath.getParent();
                    this.flushDirectory(dataverseDir);
                    this.flushDirectory(dataverseDir.getParent());
                }
                this.mkdir(stage);
                this.fetch(stage);
                this.closeLibrary();
                FileReference rev1 = this.getRev1Dir();
                if (rev1.getFile().exists()) {
                    FileReference rev0 = this.getRev0Dir();
                    this.move(rev1, rev0);
                }
                this.flushDirectory(libDir);
            }

            private void fetch(FileReference stageDir) throws IOException {
                String libLocationPath = LibraryDeployPrepareOperatorDescriptor.this.libLocation.getPath();
                String fileExt = FilenameUtils.getExtension((String)libLocationPath);
                FileReference targetFile = stageDir.getChild("lib." + fileExt);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Downloading library from {} into {}", (Object)LibraryDeployPrepareOperatorDescriptor.this.libLocation, (Object)targetFile);
                }
                this.download(targetFile);
                FileReference contentsDir = stageDir.getChild("contents");
                this.mkdir(contentsDir);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Extracting library from {} into {}", (Object)targetFile, (Object)contentsDir);
                }
                switch (LibraryDeployPrepareOperatorDescriptor.this.language) {
                    case JAVA: {
                        if (!"zip".equals(fileExt)) {
                            throw new IOException("Unexpected file type: " + fileExt);
                        }
                        this.unzip(targetFile, contentsDir);
                        break;
                    }
                    case PYTHON: {
                        if (!"pyz".equals(fileExt)) {
                            throw new IOException("Unexpected file type: " + fileExt);
                        }
                        this.shiv(targetFile, stageDir, contentsDir);
                        break;
                    }
                    default: {
                        throw new IOException("Unexpected language: " + LibraryDeployPrepareOperatorDescriptor.this.language);
                    }
                }
                FileReference targetDescFile = stageDir.getChild("lib.json");
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Writing library descriptor into {}", (Object)targetDescFile);
                }
                this.writeDescriptor(targetDescFile, new LibraryDescriptor(LibraryDeployPrepareOperatorDescriptor.this.language));
                this.flushDirectory(contentsDir);
                this.flushDirectory(stageDir);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void download(FileReference targetFile) throws HyracksException {
                try {
                    targetFile.getFile().createNewFile();
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                IFileHandle fHandle = this.ioManager.open(targetFile, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
                try {
                    CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                    try {
                        HttpGet request = new HttpGet(LibraryDeployPrepareOperatorDescriptor.this.libLocation);
                        request.setHeader("Authorization", LibraryDeployPrepareOperatorDescriptor.this.authToken);
                        int tried = 0;
                        IOException trace = null;
                        while (tried < 10) {
                            ++tried;
                            CloseableHttpResponse response = null;
                            try {
                                response = httpClient.execute((HttpUriRequest)request);
                                if (response.getStatusLine().getStatusCode() != 200) {
                                    throw new IOException("Http Error: " + response.getStatusLine().getStatusCode());
                                }
                                HttpEntity e = response.getEntity();
                                if (e == null) {
                                    throw new IOException("No response");
                                }
                                WritableByteChannel outChannel = this.ioManager.newWritableChannel(fHandle);
                                OutputStream outStream = Channels.newOutputStream(outChannel);
                                e.writeTo(outStream);
                                outStream.flush();
                                this.ioManager.sync(fHandle, true);
                                return;
                            }
                            catch (IOException e) {
                                LOGGER.error("Unable to download library", (Throwable)e);
                                trace = e;
                                try {
                                    this.ioManager.truncate(fHandle, 0L);
                                }
                                catch (IOException e2) {
                                    throw HyracksDataException.create((Throwable)e2);
                                }
                            }
                            finally {
                                if (response == null) continue;
                                try {
                                    response.close();
                                }
                                catch (IOException e) {
                                    LOGGER.warn("Failed to close", (Throwable)e);
                                }
                            }
                        }
                        throw HyracksDataException.create(trace);
                    }
                    finally {
                        try {
                            httpClient.close();
                        }
                        catch (IOException e) {
                            LOGGER.warn("Failed to close", (Throwable)e);
                        }
                    }
                }
                finally {
                    try {
                        this.ioManager.close(fHandle);
                    }
                    catch (HyracksDataException e) {
                        LOGGER.warn("Failed to close", (Throwable)e);
                    }
                }
            }

            private void unzip(FileReference sourceFile, FileReference outputDir) throws IOException {
                boolean logTraceEnabled = LOGGER.isTraceEnabled();
                HashSet<Path> newDirs = new HashSet<Path>();
                Path outputDirPath = outputDir.getFile().toPath().toAbsolutePath().normalize();
                try (ZipFile zipFile = new ZipFile(sourceFile.getFile());){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory()) continue;
                        Path entryOutputPath = outputDirPath.resolve(entry.getName()).toAbsolutePath().normalize();
                        if (!entryOutputPath.startsWith(outputDirPath)) {
                            throw new IOException("Malformed ZIP archive: " + entry.getName());
                        }
                        Path entryOutputDir = entryOutputPath.getParent();
                        Files.createDirectories(entryOutputDir, new FileAttribute[0]);
                        Path p = entryOutputDir;
                        while (!p.equals(outputDirPath)) {
                            newDirs.add(p);
                            p = p.getParent();
                        }
                        InputStream in = zipFile.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            FileReference entryOutputFileRef = this.ioManager.resolveAbsolutePath(entryOutputPath.toString());
                            if (logTraceEnabled) {
                                LOGGER.trace("Extracting file {}", (Object)entryOutputFileRef);
                            }
                            this.writeAndForce(entryOutputFileRef, in);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                }
                for (Path newDir : newDirs) {
                    this.flushDirectory(newDir);
                }
            }

            private void shiv(FileReference sourceFile, FileReference stageDir, FileReference contentsDir) throws IOException {
                FileReference pyro4 = stageDir.getChild("pyro4.pyz");
                this.writeShim(pyro4);
                this.unzip(sourceFile, contentsDir);
                this.unzip(pyro4, contentsDir);
                this.writeShim(contentsDir.getChild("entrypoint.py"));
                Files.delete(pyro4.getFile().toPath());
            }

            private void writeShim(FileReference outputFile) throws IOException {
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(outputFile.getFile().getName());
                if (is == null) {
                    throw new IOException("Classpath does not contain necessary Python resources!");
                }
                try {
                    this.writeAndForce(outputFile, is);
                }
                finally {
                    is.close();
                }
            }

            private void writeDescriptor(FileReference descFile, LibraryDescriptor desc) throws IOException {
                byte[] bytes = this.libraryManager.serializeLibraryDescriptor(desc);
                this.writeAndForce(descFile, new ByteArrayInputStream(bytes));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeAndForce(FileReference outputFile, InputStream dataStream) throws IOException {
                outputFile.getFile().createNewFile();
                IFileHandle fHandle = this.ioManager.open(outputFile, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
                try {
                    WritableByteChannel outChannel = this.ioManager.newWritableChannel(fHandle);
                    OutputStream outputStream = Channels.newOutputStream(outChannel);
                    IOUtils.copyLarge((InputStream)dataStream, (OutputStream)outputStream, (byte[])this.getCopyBuffer());
                    outputStream.flush();
                    this.ioManager.sync(fHandle, true);
                }
                finally {
                    this.ioManager.close(fHandle);
                }
            }

            private byte[] getCopyBuffer() {
                if (this.copyBuffer == null) {
                    this.copyBuffer = new byte[4096];
                }
                return this.copyBuffer;
            }
        };
    }
}

