/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.razorvine.pyro.PyroProxy;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.library.ExternalScalarFunctionEvaluator;
import org.apache.asterix.external.library.JTypeObjectFactory;
import org.apache.asterix.external.library.PythonLibrary;
import org.apache.asterix.external.library.TypeInfo;
import org.apache.asterix.external.library.java.JObjectPointableVisitor;
import org.apache.asterix.external.library.java.base.JComplexObject;
import org.apache.asterix.external.library.java.base.JObject;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;

class ExternalScalarPythonFunctionEvaluator
extends ExternalScalarFunctionEvaluator {
    private final PythonLibraryEvaluator libraryEvaluator;
    private final ArrayBackedValueStorage resultBuffer = new ArrayBackedValueStorage();
    private final PointableAllocator pointableAllocator;
    private final JObjectPointableVisitor pointableVisitor;
    private final Object[] argHolder;
    private final IObjectPool<IJObject, IAType> reflectingPool = new ListObjectPool((IObjectFactory)JTypeObjectFactory.INSTANCE);
    private final Map<IAType, TypeInfo> infoPool = new HashMap<IAType, TypeInfo>();
    private static final String ENTRYPOINT = "entrypoint.py";
    private static final String PY_NO_SITE_PKGS_OPT = "-S";
    private static final String PY_NO_USER_PKGS_OPT = "-s";
    private final IPointable[] argValues;

    ExternalScalarPythonFunctionEvaluator(IExternalFunctionInfo finfo, IScalarEvaluatorFactory[] args, IAType[] argTypes, IEvaluatorContext ctx) throws HyracksDataException {
        super(finfo, args, argTypes, ctx);
        File pythonPath = new File(ctx.getServiceContext().getAppConfig().getString((IOption)NCConfig.Option.PYTHON_HOME));
        this.pointableAllocator = new PointableAllocator();
        this.pointableVisitor = new JObjectPointableVisitor();
        DataverseName dataverseName = FunctionSignature.getDataverseName((FunctionIdentifier)finfo.getFunctionIdentifier());
        try {
            this.libraryEvaluator = PythonLibraryEvaluator.getInstance(dataverseName, finfo, this.libraryManager, pythonPath, ctx.getTaskContext());
        }
        catch (IOException | InterruptedException e) {
            throw new HyracksDataException("Failed to initialize Python", (Throwable)e);
        }
        this.argValues = new IPointable[args.length];
        for (int i = 0; i < this.argValues.length; ++i) {
            this.argValues[i] = VoidPointable.FACTORY.createPointable();
        }
        this.argHolder = new Object[args.length];
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int ln = this.argEvals.length;
        for (int i = 0; i < ln; ++i) {
            this.argEvals[i].evaluate(tuple, this.argValues[i]);
            try {
                this.setArgument(i, (IValueReference)this.argValues[i]);
                continue;
            }
            catch (IOException e) {
                throw new HyracksDataException("Error evaluating Python UDF", (Throwable)e);
            }
        }
        try {
            Object res = this.libraryEvaluator.callPython(this.argHolder);
            this.resultBuffer.reset();
            this.wrap(res, this.resultBuffer.getDataOutput());
        }
        catch (IOException e) {
            throw new HyracksDataException("Error evaluating Python UDF", (Throwable)e);
        }
        result.set(this.resultBuffer.getByteArray(), this.resultBuffer.getStartOffset(), this.resultBuffer.getLength());
    }

    private void setArgument(int index, IValueReference valueReference) throws IOException {
        IJObject jobj;
        IAType type = this.argTypes[index];
        block0 : switch (type.getTypeTag()) {
            case OBJECT: {
                ARecordVisitablePointable pointable = this.pointableAllocator.allocateRecordValue(type);
                pointable.set(valueReference);
                TypeInfo info = this.getTypeInfo(type);
                jobj = this.pointableVisitor.visit(pointable, info);
                break;
            }
            case ARRAY: 
            case MULTISET: {
                AListVisitablePointable pointable = this.pointableAllocator.allocateListValue(type);
                pointable.set(valueReference);
                TypeInfo info = this.getTypeInfo(type);
                jobj = this.pointableVisitor.visit(pointable, info);
                break;
            }
            case ANY: {
                TaggedValuePointable pointy = TaggedValuePointable.FACTORY.createPointable();
                pointy.set(valueReference);
                ATypeTag rtTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(pointy.getTag());
                IAType rtType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)rtTypeTag);
                TypeInfo info = this.getTypeInfo(rtType);
                switch (rtTypeTag) {
                    case OBJECT: {
                        ARecordVisitablePointable pointable = this.pointableAllocator.allocateRecordValue(rtType);
                        pointable.set(valueReference);
                        jobj = this.pointableVisitor.visit(pointable, info);
                        break block0;
                    }
                    case ARRAY: 
                    case MULTISET: {
                        AListVisitablePointable pointable = this.pointableAllocator.allocateListValue(rtType);
                        pointable.set(valueReference);
                        jobj = this.pointableVisitor.visit(pointable, info);
                        break block0;
                    }
                }
                IVisitablePointable pointable = this.pointableAllocator.allocateFieldValue(rtType);
                pointable.set(valueReference);
                jobj = this.pointableVisitor.visit((AFlatValuePointable)pointable, info);
                break;
            }
            default: {
                IVisitablePointable pointable = this.pointableAllocator.allocateFieldValue(type);
                pointable.set(valueReference);
                TypeInfo info = this.getTypeInfo(type);
                jobj = this.pointableVisitor.visit((AFlatValuePointable)pointable, info);
            }
        }
        this.argHolder[index] = jobj.getValueGeneric();
    }

    private TypeInfo getTypeInfo(IAType type) {
        TypeInfo typeInfo = this.infoPool.get(type);
        if (typeInfo == null) {
            typeInfo = new TypeInfo(this.reflectingPool, type, type.getTypeTag());
            this.infoPool.put(type, typeInfo);
        }
        return typeInfo;
    }

    private void wrap(Object o, DataOutput out) throws HyracksDataException {
        Class<?> concrete = o.getClass();
        IAType asxConv = JObject.convertType(concrete);
        IJObject res = (IJObject)this.reflectingPool.allocate((Object)asxConv);
        if (res instanceof JComplexObject) {
            ((JComplexObject)res).setPool(this.reflectingPool);
        }
        res.setValueGeneric(o);
        res.serialize(out, true);
    }

    private static final class PythonLibraryEvaluatorId {
        private final DataverseName dataverseName;
        private final String libraryName;

        private PythonLibraryEvaluatorId(DataverseName dataverseName, String libraryName) {
            this.dataverseName = Objects.requireNonNull(dataverseName);
            this.libraryName = Objects.requireNonNull(libraryName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PythonLibraryEvaluatorId that = (PythonLibraryEvaluatorId)o;
            return this.dataverseName.equals((Object)that.dataverseName) && this.libraryName.equals(that.libraryName);
        }

        public int hashCode() {
            return Objects.hash(this.dataverseName, this.libraryName);
        }
    }

    private static class PythonLibraryEvaluator
    extends AbstractStateObject
    implements IDeallocatable {
        Process p;
        PyroProxy remoteObj;
        IExternalFunctionInfo finfo;
        ILibraryManager libMgr;
        File pythonHome;

        private PythonLibraryEvaluator(JobId jobId, PythonLibraryEvaluatorId evaluatorId, IExternalFunctionInfo finfo, ILibraryManager libMgr, File pythonHome) {
            super(jobId, (Object)evaluatorId);
            this.finfo = finfo;
            this.libMgr = libMgr;
            this.pythonHome = pythonHome;
        }

        public void initialize() throws IOException, InterruptedException {
            String fn;
            PythonLibraryEvaluatorId fnId = (PythonLibraryEvaluatorId)this.id;
            List externalIdents = this.finfo.getExternalIdentifier();
            PythonLibrary library = (PythonLibrary)this.libMgr.getLibrary(fnId.dataverseName, fnId.libraryName);
            String wd = library.getFile().getAbsolutePath();
            int port = this.getFreeHighPort();
            String packageModule = (String)externalIdents.get(0);
            String clazz = "None";
            if (externalIdents.size() > 2) {
                clazz = (String)externalIdents.get(1);
                fn = (String)externalIdents.get(2);
            } else {
                fn = (String)externalIdents.get(1);
            }
            ProcessBuilder pb = new ProcessBuilder(this.pythonHome.getAbsolutePath(), ExternalScalarPythonFunctionEvaluator.PY_NO_SITE_PKGS_OPT, ExternalScalarPythonFunctionEvaluator.PY_NO_USER_PKGS_OPT, ExternalScalarPythonFunctionEvaluator.ENTRYPOINT, Integer.toString(port), packageModule, clazz, fn);
            pb.directory(new File(wd));
            pb.environment().clear();
            pb.inheritIO();
            this.p = pb.start();
            this.remoteObj = new PyroProxy("127.0.0.1", port, "nextTuple");
            this.waitForPython();
        }

        Object callPython(Object[] arguments) throws IOException {
            return this.remoteObj.call("nextTuple", arguments);
        }

        public void deallocate() {
            this.p.destroyForcibly();
        }

        private static PythonLibraryEvaluator getInstance(DataverseName dataverseName, IExternalFunctionInfo finfo, ILibraryManager libMgr, File pythonHome, IHyracksTaskContext ctx) throws IOException, InterruptedException {
            PythonLibraryEvaluatorId evaluatorId = new PythonLibraryEvaluatorId(dataverseName, finfo.getLibrary());
            PythonLibraryEvaluator evaluator = (PythonLibraryEvaluator)ctx.getStateObject((Object)evaluatorId);
            if (evaluator == null) {
                evaluator = new PythonLibraryEvaluator(ctx.getJobletContext().getJobId(), evaluatorId, finfo, libMgr, pythonHome);
                evaluator.initialize();
                ctx.registerDeallocatable((IDeallocatable)evaluator);
                ctx.setStateObject((IStateObject)evaluator);
            }
            return evaluator;
        }

        private int getFreeHighPort() throws IOException {
            int port;
            try (ServerSocket socket = new ServerSocket(0);){
                socket.setReuseAddress(true);
                port = socket.getLocalPort();
            }
            return port;
        }

        private void waitForPython() throws IOException, InterruptedException {
            for (int i = 0; i < 100; ++i) {
                try {
                    this.remoteObj.call("ping", new Object[0]);
                    break;
                }
                catch (ConnectException e) {
                    Thread.sleep(100L);
                    continue;
                }
            }
        }
    }
}

