/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.IOException;
import java.io.InputStream;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractMultipleInputStream
extends AsterixInputStream {
    protected InputStream in;
    private byte lastByte;

    protected AbstractMultipleInputStream() {
    }

    protected abstract boolean advance() throws IOException;

    @Override
    public int read() throws IOException {
        throw new HyracksDataException("read() is not supported with this stream. use read(byte[] b, int off, int len)");
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null && !this.advance()) {
            return -1;
        }
        int result = this.in.read(b, off, len);
        if (result < 0 && this.lastByte != 10 && this.lastByte != 13) {
            this.lastByte = (byte)10;
            b[off] = 10;
            return 1;
        }
        while (result < 0 && this.advance()) {
            result = this.in.read(b, off, len);
        }
        if (result > 0) {
            this.lastByte = b[off + result - 1];
        }
        return result;
    }
}

