/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public final class DecodeDataverseNameDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = DecodeDataverseNameDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractScalarEval(DecodeDataverseNameDescriptor.this.sourceLoc, DecodeDataverseNameDescriptor.this.getIdentifier()){
                    private final IScalarEvaluator eval0;
                    private final VoidPointable arg0;
                    private final UTF8StringPointable strPtr;
                    private final List<String> dataverseNameParts;
                    private final AOrderedListType listType;
                    private final OrderedListBuilder listBuilder;
                    private final ArrayBackedValueStorage itemStorage;
                    private final DataOutput itemOut;
                    private final ArrayBackedValueStorage resultStorage;
                    private final DataOutput resultOut;
                    private final ISerializerDeserializer stringSerde;
                    private final AMutableString aString;
                    {
                        super(sourceLoc, functionIdentifier);
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.arg0 = VoidPointable.FACTORY.createPointable();
                        this.strPtr = new UTF8StringPointable();
                        this.dataverseNameParts = new ArrayList<String>();
                        this.listType = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
                        this.listBuilder = new OrderedListBuilder();
                        this.itemStorage = new ArrayBackedValueStorage();
                        this.itemOut = this.itemStorage.getDataOutput();
                        this.resultStorage = new ArrayBackedValueStorage();
                        this.resultOut = this.resultStorage.getDataOutput();
                        this.stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
                        this.aString = new AMutableString("");
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.eval0.evaluate(tuple, (IPointable)this.arg0);
                        if (PointableHelper.checkAndSetMissingOrNull(result, (IPointable)this.arg0)) {
                            return;
                        }
                        byte[] bytes = this.arg0.getByteArray();
                        int offset = this.arg0.getStartOffset();
                        int len = this.arg0.getLength();
                        if (bytes[offset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                            PointableHelper.setNull(result);
                            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)this.srcLoc, (FunctionIdentifier)DecodeDataverseNameDescriptor.this.getIdentifier(), (byte)bytes[offset], (int)0, (ATypeTag)ATypeTag.STRING);
                            return;
                        }
                        this.strPtr.set(bytes, offset + 1, len - 1);
                        String dataverseCanonicalName = this.strPtr.toString();
                        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
                        this.dataverseNameParts.clear();
                        dataverseName.getParts(this.dataverseNameParts);
                        this.resultStorage.reset();
                        this.listBuilder.reset((AbstractCollectionType)this.listType);
                        for (String part : this.dataverseNameParts) {
                            this.itemStorage.reset();
                            this.aString.setValue(part);
                            this.stringSerde.serialize((Object)this.aString, this.itemOut);
                            this.listBuilder.addItem((IValueReference)this.itemStorage);
                        }
                        this.listBuilder.write(this.resultOut, true);
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.DECODE_DATAVERSE_NAME;
    }
}

