/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.runtime.aggregates.std.AbstractSingleVarStatisticsAggregateFunction;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class SqlVarAggregateFunction
extends AbstractSingleVarStatisticsAggregateFunction {
    private final boolean isPop;
    private final int delta;

    public SqlVarAggregateFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext context, boolean isPop, SourceLocation sourceLoc) throws HyracksDataException {
        super(args, context, sourceLoc);
        this.isPop = isPop;
        this.delta = isPop ? 0 : 1;
    }

    @Override
    public void step(IFrameTupleReference tuple) throws HyracksDataException {
        this.processDataValues(tuple);
    }

    @Override
    public void finish(IPointable result) throws HyracksDataException {
        this.finishVarFinalResults(result, this.delta);
    }

    @Override
    public void finishPartial(IPointable result) throws HyracksDataException {
        this.finishPartialResults(result);
    }

    @Override
    protected void processNull() {
    }

    @Override
    protected FunctionIdentifier getFunctionIdentifier() {
        if (this.isPop) {
            return BuiltinFunctions.VAR_POP;
        }
        return BuiltinFunctions.VAR_SAMP;
    }

    @Override
    protected boolean getM3Flag() {
        return false;
    }

    @Override
    protected boolean getM4Flag() {
        return false;
    }
}

