/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.join;

import java.io.DataOutput;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluator;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.buffermanager.BufferInfo;
import org.apache.hyracks.dataflow.std.buffermanager.EnumFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.FrameFreeSlotPolicyFactory;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFrameMemoryManager;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFramePool;

public class NestedLoopJoin {
    private final FrameTupleAccessor accessorInner;
    private final FrameTupleAccessor accessorOuter;
    private final FrameTupleAppender appender;
    private ITuplePairComparator tpComparator;
    private final IFrame outBuffer;
    private final IFrame innerBuffer;
    private final VariableFrameMemoryManager outerBufferMngr;
    private final RunFileWriter runFileWriter;
    private final boolean isLeftOuter;
    private final ArrayTupleBuilder missingTupleBuilder;
    private final IPredicateEvaluator predEvaluator;
    private boolean isReversed;
    private final BufferInfo tempInfo = new BufferInfo(null, -1, -1);

    public NestedLoopJoin(IHyracksJobletContext jobletContext, FrameTupleAccessor accessorOuter, FrameTupleAccessor accessorInner, int memSize, IPredicateEvaluator predEval, boolean isLeftOuter, IMissingWriter[] missingWriters) throws HyracksDataException {
        this.accessorInner = accessorInner;
        this.accessorOuter = accessorOuter;
        this.appender = new FrameTupleAppender();
        this.outBuffer = new VSizeFrame((IHyracksFrameMgrContext)jobletContext);
        this.innerBuffer = new VSizeFrame((IHyracksFrameMgrContext)jobletContext);
        this.appender.reset(this.outBuffer, true);
        if (memSize < 3) {
            throw new HyracksDataException("Not enough memory is available for Nested Loop Join");
        }
        this.outerBufferMngr = new VariableFrameMemoryManager(new VariableFramePool((IHyracksFrameMgrContext)jobletContext, jobletContext.getInitialFrameSize() * (memSize - 2)), FrameFreeSlotPolicyFactory.createFreeSlotPolicy(EnumFreeSlotPolicy.LAST_FIT, memSize - 2));
        this.predEvaluator = predEval;
        this.isReversed = false;
        this.isLeftOuter = isLeftOuter;
        if (isLeftOuter) {
            int innerFieldCount = this.accessorInner.getFieldCount();
            this.missingTupleBuilder = new ArrayTupleBuilder(innerFieldCount);
            DataOutput out = this.missingTupleBuilder.getDataOutput();
            for (int i = 0; i < innerFieldCount; ++i) {
                missingWriters[i].writeMissing(out);
                this.missingTupleBuilder.addFieldEndOffset();
            }
        } else {
            this.missingTupleBuilder = null;
        }
        FileReference file = jobletContext.createManagedWorkspaceFile(this.getClass().getSimpleName() + this.toString());
        this.runFileWriter = new RunFileWriter(file, jobletContext.getIoManager());
        this.runFileWriter.open();
    }

    public void cache(ByteBuffer buffer) throws HyracksDataException {
        this.runFileWriter.nextFrame(buffer);
    }

    void setComparator(ITuplePairComparator comparator) {
        this.tpComparator = comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(ByteBuffer outerBuffer, IFrameWriter writer) throws HyracksDataException {
        if (this.outerBufferMngr.insertFrame(outerBuffer) < 0) {
            try (GeneratedRunFileReader runFileReader = this.runFileWriter.createReader();){
                runFileReader.open();
                while (runFileReader.nextFrame(this.innerBuffer)) {
                    for (int i = 0; i < this.outerBufferMngr.getNumFrames(); ++i) {
                        this.blockJoin(this.outerBufferMngr.getFrame(i, this.tempInfo), this.innerBuffer.getBuffer(), writer);
                    }
                }
            }
            this.outerBufferMngr.reset();
            if (this.outerBufferMngr.insertFrame(outerBuffer) < 0) {
                throw new HyracksDataException("The given outer frame of size:" + outerBuffer.capacity() + " is too big to cache in the buffer. Please choose a larger buffer memory size");
            }
        }
    }

    private void blockJoin(BufferInfo outerBufferInfo, ByteBuffer innerBuffer, IFrameWriter writer) throws HyracksDataException {
        this.accessorOuter.reset(outerBufferInfo.getBuffer(), outerBufferInfo.getStartOffset(), outerBufferInfo.getLength());
        this.accessorInner.reset(innerBuffer);
        int tupleCount0 = this.accessorOuter.getTupleCount();
        int tupleCount1 = this.accessorInner.getTupleCount();
        for (int i = 0; i < tupleCount0; ++i) {
            boolean matchFound = false;
            for (int j = 0; j < tupleCount1; ++j) {
                int c = this.tpComparator.compare((IFrameTupleAccessor)this.accessorOuter, i, (IFrameTupleAccessor)this.accessorInner, j);
                boolean prdEval = this.evaluatePredicate(i, j);
                if (c != 0 || !prdEval) continue;
                matchFound = true;
                this.appendToResults(i, j, writer);
            }
            if (matchFound || !this.isLeftOuter) continue;
            int[] ntFieldEndOffsets = this.missingTupleBuilder.getFieldEndOffsets();
            byte[] ntByteArray = this.missingTupleBuilder.getByteArray();
            int ntSize = this.missingTupleBuilder.getSize();
            FrameUtils.appendConcatToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessorOuter, (int)i, (int[])ntFieldEndOffsets, (byte[])ntByteArray, (int)0, (int)ntSize);
        }
    }

    private boolean evaluatePredicate(int tIx1, int tIx2) {
        if (this.isReversed) {
            return this.predEvaluator == null || this.predEvaluator.evaluate((IFrameTupleAccessor)this.accessorInner, tIx2, (IFrameTupleAccessor)this.accessorOuter, tIx1);
        }
        return this.predEvaluator == null || this.predEvaluator.evaluate((IFrameTupleAccessor)this.accessorOuter, tIx1, (IFrameTupleAccessor)this.accessorInner, tIx2);
    }

    private void appendToResults(int outerTupleId, int innerTupleId, IFrameWriter writer) throws HyracksDataException {
        if (this.isReversed) {
            this.appendResultToFrame(this.accessorInner, innerTupleId, this.accessorOuter, outerTupleId, writer);
        } else {
            this.appendResultToFrame(this.accessorOuter, outerTupleId, this.accessorInner, innerTupleId, writer);
        }
    }

    private void appendResultToFrame(FrameTupleAccessor accessor1, int tupleId1, FrameTupleAccessor accessor2, int tupleId2, IFrameWriter writer) throws HyracksDataException {
        FrameUtils.appendConcatToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)accessor1, (int)tupleId1, (IFrameTupleAccessor)accessor2, (int)tupleId2);
    }

    public void closeCache() throws HyracksDataException {
        if (this.runFileWriter != null) {
            this.runFileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeJoin(IFrameWriter writer) throws HyracksDataException {
        try (GeneratedRunFileReader runFileReader = this.runFileWriter.createDeleteOnCloseReader();){
            runFileReader.open();
            while (runFileReader.nextFrame(this.innerBuffer)) {
                for (int i = 0; i < this.outerBufferMngr.getNumFrames(); ++i) {
                    this.blockJoin(this.outerBufferMngr.getFrame(i, this.tempInfo), this.innerBuffer.getBuffer(), writer);
                }
            }
        }
        this.appender.write(writer, true);
    }

    public void releaseMemory() throws HyracksDataException {
        this.outerBufferMngr.reset();
    }

    public void setIsReversed(boolean b) {
        this.isReversed = b;
    }
}

