/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.join;

import java.io.DataOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluator;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparator;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.TupleInFrameListAccessor;
import org.apache.hyracks.dataflow.std.structures.ISerializableTable;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InMemoryHashJoin {
    private final List<ByteBuffer> buffers;
    private final FrameTupleAccessor accessorBuild;
    private final ITuplePartitionComputer tpcBuild;
    private final IFrameTupleAccessor accessorProbe;
    private final ITuplePartitionComputer tpcProbe;
    private final FrameTupleAppender appender;
    private ITuplePairComparator tpComparator;
    private final boolean isLeftOuter;
    private final ArrayTupleBuilder missingTupleBuild;
    private final ISerializableTable table;
    private final TuplePointer storedTuplePointer;
    private final boolean reverseOutputOrder;
    private final IPredicateEvaluator predEvaluator;
    private final TupleInFrameListAccessor tupleAccessor;
    private final ISimpleFrameBufferManager bufferManager;
    private final boolean isTableCapacityNotZero;
    private static final Logger LOGGER = LogManager.getLogger();

    public InMemoryHashJoin(IHyracksFrameMgrContext ctx, FrameTupleAccessor accessorProbe, ITuplePartitionComputer tpcProbe, FrameTupleAccessor accessorBuild, RecordDescriptor rDBuild, ITuplePartitionComputer tpcBuild, boolean isLeftOuter, IMissingWriter[] missingWritersBuild, ISerializableTable table, IPredicateEvaluator predEval, ISimpleFrameBufferManager bufferManager) throws HyracksDataException {
        this(ctx, accessorProbe, tpcProbe, accessorBuild, rDBuild, tpcBuild, isLeftOuter, missingWritersBuild, table, predEval, false, bufferManager);
    }

    public InMemoryHashJoin(IHyracksFrameMgrContext ctx, FrameTupleAccessor accessorProbe, ITuplePartitionComputer tpcProbe, FrameTupleAccessor accessorBuild, RecordDescriptor rDBuild, ITuplePartitionComputer tpcBuild, boolean isLeftOuter, IMissingWriter[] missingWritersBuild, ISerializableTable table, IPredicateEvaluator predEval, boolean reverse, ISimpleFrameBufferManager bufferManager) throws HyracksDataException {
        this.table = table;
        this.storedTuplePointer = new TuplePointer();
        this.buffers = new ArrayList<ByteBuffer>();
        this.accessorBuild = accessorBuild;
        this.tpcBuild = tpcBuild;
        this.accessorProbe = accessorProbe;
        this.tpcProbe = tpcProbe;
        this.appender = new FrameTupleAppender((IFrame)new VSizeFrame(ctx));
        this.predEvaluator = predEval;
        this.isLeftOuter = isLeftOuter;
        if (isLeftOuter) {
            int fieldCountOuter = accessorBuild.getFieldCount();
            this.missingTupleBuild = new ArrayTupleBuilder(fieldCountOuter);
            DataOutput out = this.missingTupleBuild.getDataOutput();
            for (int i = 0; i < fieldCountOuter; ++i) {
                missingWritersBuild[i].writeMissing(out);
                this.missingTupleBuild.addFieldEndOffset();
            }
        } else {
            this.missingTupleBuild = null;
        }
        this.reverseOutputOrder = reverse;
        this.tupleAccessor = new TupleInFrameListAccessor(rDBuild, this.buffers);
        this.bufferManager = bufferManager;
        boolean bl = this.isTableCapacityNotZero = table.getTableSize() != 0;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("InMemoryHashJoin has been created for a table size of " + table.getTableSize() + " for Thread ID " + Thread.currentThread().getId() + ".");
        }
    }

    public void build(ByteBuffer buffer) throws HyracksDataException {
        this.buffers.add(buffer);
        int bIndex = this.buffers.size() - 1;
        this.accessorBuild.reset(buffer);
        int tCount = this.accessorBuild.getTupleCount();
        for (int i = 0; i < tCount; ++i) {
            int entry = this.tpcBuild.partition((IFrameTupleAccessor)this.accessorBuild, i, this.table.getTableSize());
            this.storedTuplePointer.reset(bIndex, i);
            if (this.table.insert(entry, this.storedTuplePointer)) continue;
            this.compactTableAndInsertAgain(entry, this.storedTuplePointer);
        }
    }

    public boolean compactTableAndInsertAgain(int entry, TuplePointer tPointer) throws HyracksDataException {
        boolean oneMoreTry = false;
        if (this.compactHashTable() >= 0) {
            oneMoreTry = this.table.insert(entry, tPointer);
        }
        return oneMoreTry;
    }

    public int compactHashTable() throws HyracksDataException {
        if (this.table.isGarbageCollectionNeeded()) {
            return this.table.collectGarbage(this.tupleAccessor, this.tpcBuild);
        }
        return -1;
    }

    void setComparator(ITuplePairComparator comparator) {
        this.tpComparator = comparator;
    }

    void join(int tid, IFrameWriter writer) throws HyracksDataException {
        boolean matchFound = false;
        if (this.isTableCapacityNotZero) {
            int entry = this.tpcProbe.partition(this.accessorProbe, tid, this.table.getTableSize());
            int tupleCount = this.table.getTupleCount(entry);
            for (int i = 0; i < tupleCount; ++i) {
                boolean predEval;
                this.table.getTuplePointer(entry, i, this.storedTuplePointer);
                int bIndex = this.storedTuplePointer.getFrameIndex();
                int tIndex = this.storedTuplePointer.getTupleIndex();
                this.accessorBuild.reset(this.buffers.get(bIndex));
                int c = this.tpComparator.compare(this.accessorProbe, tid, (IFrameTupleAccessor)this.accessorBuild, tIndex);
                if (c != 0 || !(predEval = this.evaluatePredicate(tid, tIndex))) continue;
                matchFound = true;
                this.appendToResult(tid, tIndex, writer);
            }
        }
        if (!matchFound && this.isLeftOuter) {
            FrameUtils.appendConcatToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessorProbe, (int)tid, (int[])this.missingTupleBuild.getFieldEndOffsets(), (byte[])this.missingTupleBuild.getByteArray(), (int)0, (int)this.missingTupleBuild.getSize());
        }
    }

    public void join(ByteBuffer buffer, IFrameWriter writer) throws HyracksDataException {
        this.accessorProbe.reset(buffer);
        int tupleCount0 = this.accessorProbe.getTupleCount();
        for (int i = 0; i < tupleCount0; ++i) {
            this.join(i, writer);
        }
    }

    public void resetAccessorProbe(IFrameTupleAccessor newAccessorProbe) {
        this.accessorProbe.reset(newAccessorProbe.getBuffer());
    }

    public void completeJoin(IFrameWriter writer) throws HyracksDataException {
        this.appender.write(writer, true);
    }

    public void releaseMemory() throws HyracksDataException {
        int nFrames = this.buffers.size();
        if (this.bufferManager != null) {
            for (int i = 0; i < nFrames; ++i) {
                this.bufferManager.releaseFrame(this.buffers.get(i));
            }
        }
        this.buffers.clear();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("InMemoryHashJoin has finished using " + nFrames + " frames for Thread ID " + Thread.currentThread().getId() + ".");
        }
    }

    public void closeTable() throws HyracksDataException {
        this.table.close();
    }

    private boolean evaluatePredicate(int tIx1, int tIx2) {
        if (this.reverseOutputOrder) {
            return this.predEvaluator == null || this.predEvaluator.evaluate((IFrameTupleAccessor)this.accessorBuild, tIx2, this.accessorProbe, tIx1);
        }
        return this.predEvaluator == null || this.predEvaluator.evaluate(this.accessorProbe, tIx1, (IFrameTupleAccessor)this.accessorBuild, tIx2);
    }

    private void appendToResult(int probeSidetIx, int buildSidetIx, IFrameWriter writer) throws HyracksDataException {
        if (this.reverseOutputOrder) {
            FrameUtils.appendConcatToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessorBuild, (int)buildSidetIx, (IFrameTupleAccessor)this.accessorProbe, (int)probeSidetIx);
        } else {
            FrameUtils.appendConcatToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessorProbe, (int)probeSidetIx, (IFrameTupleAccessor)this.accessorBuild, (int)buildSidetIx);
        }
    }
}

