/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.external;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.ISpillableTable;
import org.apache.hyracks.dataflow.std.group.ISpillableTableFactory;
import org.apache.hyracks.dataflow.std.group.external.ExternalGroupOperatorDescriptor;
import org.apache.hyracks.dataflow.std.group.external.ExternalGroupState;
import org.apache.hyracks.dataflow.std.group.external.ExternalHashGroupBy;
import org.apache.hyracks.dataflow.std.group.external.IRunFileWriterGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalGroupBuildOperatorNodePushable
extends AbstractUnaryInputSinkOperatorNodePushable
implements IRunFileWriterGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IHyracksTaskContext ctx;
    private final Object stateId;
    private final int[] keyFields;
    private final IBinaryComparator[] comparators;
    private final INormalizedKeyComputer firstNormalizerComputer;
    private final IAggregatorDescriptorFactory aggregatorFactory;
    private final int framesLimit;
    private final ISpillableTableFactory spillableTableFactory;
    private final RecordDescriptor inRecordDescriptor;
    private final RecordDescriptor outRecordDescriptor;
    private final int tableSize;
    private final long fileSize;
    private ExternalHashGroupBy externalGroupBy;
    private ExternalGroupState state;
    private boolean isFailed = false;

    public ExternalGroupBuildOperatorNodePushable(IHyracksTaskContext ctx, Object stateId, int tableSize, long fileSize, int[] keyFields, int framesLimit, IBinaryComparatorFactory[] comparatorFactories, INormalizedKeyComputerFactory firstNormalizerFactory, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor, ISpillableTableFactory spillableTableFactory) {
        this.ctx = ctx;
        this.stateId = stateId;
        this.framesLimit = framesLimit;
        this.aggregatorFactory = aggregatorFactory;
        this.keyFields = keyFields;
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.firstNormalizerComputer = firstNormalizerFactory == null ? null : firstNormalizerFactory.createNormalizedKeyComputer();
        this.spillableTableFactory = spillableTableFactory;
        this.inRecordDescriptor = inRecordDescriptor;
        this.outRecordDescriptor = outRecordDescriptor;
        this.tableSize = tableSize;
        this.fileSize = fileSize;
    }

    public void open() throws HyracksDataException {
        this.state = new ExternalGroupState(this.ctx.getJobletContext().getJobId(), this.stateId);
        ISpillableTable table = this.spillableTableFactory.buildSpillableTable(this.ctx, this.tableSize, this.fileSize, this.keyFields, this.comparators, this.firstNormalizerComputer, this.aggregatorFactory, this.inRecordDescriptor, this.outRecordDescriptor, this.framesLimit, 0);
        RunFileWriter[] runFileWriters = new RunFileWriter[table.getNumPartitions()];
        this.externalGroupBy = new ExternalHashGroupBy(this, table, runFileWriters, this.inRecordDescriptor);
        this.state.setSpillableTable(table);
        this.state.setRuns(runFileWriters);
        this.state.setSpilledNumTuples(this.externalGroupBy.getSpilledNumTuples());
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.externalGroupBy.insert(buffer);
    }

    public void fail() throws HyracksDataException {
        this.isFailed = true;
    }

    public void close() throws HyracksDataException {
        if (this.isFailed && this.state.getRuns() != null) {
            for (RunFileWriter run : this.state.getRuns()) {
                if (run == null) continue;
                run.erase();
            }
        } else {
            this.externalGroupBy.flushSpilledPartitions();
            this.ctx.setStateObject((IStateObject)this.state);
            if (LOGGER.isDebugEnabled()) {
                int numOfPartition = this.state.getSpillableTable().getNumPartitions();
                int numOfSpilledPart = 0;
                for (int i = 0; i < numOfPartition; ++i) {
                    if (this.state.getSpilledNumTuples()[i] <= 0) continue;
                    ++numOfSpilledPart;
                }
                LOGGER.debug("level 0:build with " + numOfPartition + " partitions, spilled " + numOfSpilledPart + " partitions");
            }
        }
        this.state = null;
        this.externalGroupBy = null;
    }

    @Override
    public RunFileWriter getRunFileWriter() throws HyracksDataException {
        FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(ExternalGroupOperatorDescriptor.class.getSimpleName());
        return new RunFileWriter(file, this.ctx.getIoManager());
    }
}

