/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.connectors;

import java.util.BitSet;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.IPartitionCollector;
import org.apache.hyracks.api.comm.IPartitionWriterFactory;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.constraints.IConstraintAcceptor;
import org.apache.hyracks.api.constraints.expressions.ConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.LValueConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionCountExpression;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractConnectorDescriptor;
import org.apache.hyracks.dataflow.std.collectors.NonDeterministicChannelReader;
import org.apache.hyracks.dataflow.std.collectors.NonDeterministicFrameReader;
import org.apache.hyracks.dataflow.std.collectors.PartitionCollector;

public class OneToOneConnectorDescriptor
extends AbstractConnectorDescriptor {
    private static final long serialVersionUID = 1L;

    public OneToOneConnectorDescriptor(IConnectorDescriptorRegistry spec) {
        super(spec);
    }

    public IFrameWriter createPartitioner(IHyracksTaskContext ctx, RecordDescriptor recordDesc, IPartitionWriterFactory edwFactory, int index, int nProducerPartitions, int nConsumerPartitions) throws HyracksDataException {
        return edwFactory.createFrameWriter(index);
    }

    public IPartitionCollector createPartitionCollector(IHyracksTaskContext ctx, RecordDescriptor recordDesc, int index, int nProducerPartitions, int nConsumerPartitions) throws HyracksDataException {
        BitSet expectedPartitions = new BitSet(nProducerPartitions);
        expectedPartitions.set(index);
        NonDeterministicChannelReader channelReader = new NonDeterministicChannelReader(nProducerPartitions, expectedPartitions);
        NonDeterministicFrameReader frameReader = new NonDeterministicFrameReader(channelReader);
        return new PartitionCollector(ctx, this.getConnectorId(), index, expectedPartitions, frameReader, channelReader);
    }

    @Override
    public void contributeSchedulingConstraints(IConstraintAcceptor constraintAcceptor, ActivityCluster ac, ICCServiceContext serviceCtx) {
        OperatorDescriptorId consumer = ac.getConsumerActivity(this.getConnectorId()).getOperatorDescriptorId();
        OperatorDescriptorId producer = ac.getProducerActivity(this.getConnectorId()).getOperatorDescriptorId();
        constraintAcceptor.addConstraint(new Constraint((LValueConstraintExpression)new PartitionCountExpression(consumer), (ConstraintExpression)new PartitionCountExpression(producer)));
    }

    public void indicateTargetPartitions(int nProducerPartitions, int nConsumerPartitions, int producerIndex, BitSet targetBitmap) {
        targetBitmap.clear();
        targetBitmap.set(producerIndex);
    }

    public void indicateSourcePartitions(int nProducerPartitions, int nConsumerPartitions, int consumerIndex, BitSet sourceBitmap) {
        sourceBitmap.clear();
        sourceBitmap.set(consumerIndex);
    }

    public boolean allProducersToAllConsumers() {
        return false;
    }
}

