/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.parser.FunctionParser;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class FunctionUtil {
    public static final String IMPORT_PRIVATE_FUNCTIONS = "import-private-functions";
    private static final DataverseName FN_DATASET_DATAVERSE_NAME = FunctionSignature.getDataverseName((FunctionIdentifier)BuiltinFunctions.DATASET);
    private static final String FN_DATASET_NAME = BuiltinFunctions.DATASET.getName();

    public static IFunctionInfo getFunctionInfo(FunctionIdentifier fi) {
        return BuiltinFunctions.getAsterixFunctionInfo((FunctionIdentifier)fi);
    }

    public static IFunctionInfo getFunctionInfo(FunctionSignature fs) {
        return FunctionUtil.getFunctionInfo(fs.createFunctionIdentifier());
    }

    public static IFunctionInfo getBuiltinFunctionInfo(String functionName, int arity) {
        IFunctionInfo fi = FunctionUtil.getFunctionInfo(new FunctionIdentifier("algebricks", functionName, arity));
        if (fi == null) {
            fi = FunctionUtil.getFunctionInfo(new FunctionIdentifier("asterix", functionName, arity));
        }
        return fi;
    }

    public static TypeSignature getTypeDependencyFromFunctionParameter(TypeExpression typeExpr, DataverseName defaultDataverse) {
        switch (typeExpr.getTypeKind()) {
            case ORDEREDLIST: {
                return FunctionUtil.getTypeDependencyFromFunctionParameter(((OrderedListTypeDefinition)typeExpr).getItemTypeExpression(), defaultDataverse);
            }
            case UNORDEREDLIST: {
                return FunctionUtil.getTypeDependencyFromFunctionParameter(((UnorderedListTypeDefinition)typeExpr).getItemTypeExpression(), defaultDataverse);
            }
            case TYPEREFERENCE: {
                TypeReferenceExpression typeRef = (TypeReferenceExpression)typeExpr;
                String typeName = ((Identifier)typeRef.getIdent().getSecond()).toString();
                BuiltinType builtinType = BuiltinTypeMap.getBuiltinType((String)typeName);
                if (builtinType != null) {
                    return null;
                }
                DataverseName typeDataverseName = typeRef.getIdent().getFirst() != null ? (DataverseName)typeRef.getIdent().getFirst() : defaultDataverse;
                return new TypeSignature(typeDataverseName, typeName);
            }
            case RECORD: {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalStateException();
    }

    public static List<FunctionDecl> retrieveUsedStoredFunctions(MetadataProvider metadataProvider, Expression expression, List<FunctionSignature> declaredFunctions, List<FunctionDecl> inputFunctionDecls, IFunctionCollector functionCollector, FunctionParser functionParser, IFunctionNormalizer functionNormalizer) throws CompilationException {
        List<FunctionDecl> functionDecls;
        List<FunctionDecl> list = functionDecls = inputFunctionDecls == null ? new ArrayList<FunctionDecl>() : new ArrayList<FunctionDecl>(inputFunctionDecls);
        if (expression == null) {
            return functionDecls;
        }
        String value = (String)metadataProvider.getConfig().get(IMPORT_PRIVATE_FUNCTIONS);
        boolean includePrivateFunctions = value != null && Boolean.parseBoolean(value.toLowerCase());
        Set<CallExpr> functionCalls = functionCollector.getFunctionCalls(expression);
        for (CallExpr functionCall : functionCalls) {
            FunctionDecl functionDecl;
            org.apache.asterix.metadata.entities.Function function;
            FunctionSignature signature = functionCall.getFunctionSignature();
            if (declaredFunctions != null && declaredFunctions.contains(signature)) continue;
            if (signature.getDataverseName() == null) {
                signature.setDataverseName(metadataProvider.getDefaultDataverseName());
            }
            DataverseName namespace = signature.getDataverseName();
            try {
                if (!namespace.equals((Object)FunctionConstants.ASTERIX_DV) && !namespace.equals((Object)FunctionConstants.ALGEBRICKS_DV) && metadataProvider.findDataverse(namespace) == null) {
                    throw new CompilationException(1079, functionCall.getSourceLocation(), new Serializable[]{"In function call \"" + namespace + "." + signature.getName() + "(...)\", the dataverse \"" + namespace + "\" cannot be found!"});
                }
            }
            catch (AlgebricksException e) {
                throw new CompilationException((Throwable)e);
            }
            try {
                function = FunctionUtil.lookupUserDefinedFunctionDecl(metadataProvider.getMetadataTxnContext(), signature);
            }
            catch (AlgebricksException e) {
                throw new CompilationException((Throwable)e);
            }
            if (function == null) {
                FunctionSignature normalizedSignature;
                FunctionSignature functionSignature = normalizedSignature = functionNormalizer == null ? signature : functionNormalizer.normalizeBuiltinFunctionSignature(signature, functionCall.getSourceLocation());
                if (BuiltinFunctions.isBuiltinCompilerFunction((FunctionSignature)normalizedSignature, (boolean)includePrivateFunctions)) continue;
                StringBuilder messageBuilder = new StringBuilder();
                if (!functionDecls.isEmpty()) {
                    messageBuilder.append("function " + ((FunctionDecl)functionDecls.get(functionDecls.size() - 1)).getSignature() + " depends upon function " + signature + " which is undefined");
                } else {
                    messageBuilder.append("function " + signature + " is not defined");
                }
                throw new CompilationException(1079, functionCall.getSourceLocation(), new Serializable[]{messageBuilder.toString()});
            }
            if (!functionParser.getLanguage().equals(function.getLanguage()) || (functionDecl = functionParser.getFunctionDecl(function)) == null) continue;
            if (functionDecls.contains(functionDecl)) {
                throw new CompilationException(1079, functionCall.getSourceLocation(), new Serializable[]{"Recursive invocation " + functionDecls.get(functionDecls.size() - 1).getSignature() + " <==> " + functionDecl.getSignature()});
            }
            functionDecls.add(functionDecl);
            functionDecls = FunctionUtil.retrieveUsedStoredFunctions(metadataProvider, functionDecl.getFuncBody(), declaredFunctions, functionDecls, functionCollector, functionParser, functionNormalizer);
        }
        return functionDecls;
    }

    public static List<List<Triple<DataverseName, String, String>>> getFunctionDependencies(IQueryRewriter rewriter, Expression expression, MetadataProvider metadataProvider, Collection<TypeSignature> dependentTypes) throws CompilationException {
        Set<CallExpr> functionCalls = rewriter.getFunctionCalls(expression);
        ArrayList<Triple> datasourceDependencies = new ArrayList<Triple>();
        ArrayList<Triple> functionDependencies = new ArrayList<Triple>();
        ArrayList<Triple> typeDependencies = new ArrayList<Triple>(dependentTypes.size());
        for (CallExpr functionCall : functionCalls) {
            FunctionSignature signature = functionCall.getFunctionSignature();
            if (FunctionUtil.isBuiltinDatasetFunction(signature)) {
                Pair<DataverseName, String> datasetReference = FunctionUtil.parseDatasetFunctionArguments(functionCall.getExprList(), metadataProvider.getDefaultDataverseName(), functionCall.getSourceLocation(), ExpressionUtils::getStringLiteral);
                datasourceDependencies.add(new Triple(datasetReference.first, datasetReference.second, null));
                continue;
            }
            if (BuiltinFunctions.isBuiltinCompilerFunction((FunctionSignature)signature, (boolean)false)) continue;
            functionDependencies.add(new Triple((Object)signature.getDataverseName(), (Object)signature.getName(), (Object)Integer.toString(signature.getArity())));
        }
        for (TypeSignature t : dependentTypes) {
            typeDependencies.add(new Triple((Object)t.getDataverseName(), (Object)t.getName(), null));
        }
        ArrayList<List<Triple<DataverseName, String, String>>> dependencies = new ArrayList<List<Triple<DataverseName, String, String>>>(3);
        dependencies.add(datasourceDependencies);
        dependencies.add(functionDependencies);
        dependencies.add(typeDependencies);
        return dependencies;
    }

    public static List<List<Triple<DataverseName, String, String>>> getExternalFunctionDependencies(Collection<TypeSignature> dependentTypes) {
        List datasourceDependencies = Collections.emptyList();
        List functionDependencies = Collections.emptyList();
        ArrayList<Triple> typeDependencies = new ArrayList<Triple>(dependentTypes.size());
        for (TypeSignature t : dependentTypes) {
            typeDependencies.add(new Triple((Object)t.getDataverseName(), (Object)t.getName(), null));
        }
        ArrayList<List<Triple<DataverseName, String, String>>> dependencies = new ArrayList<List<Triple<DataverseName, String, String>>>(3);
        dependencies.add(datasourceDependencies);
        dependencies.add(functionDependencies);
        dependencies.add(typeDependencies);
        return dependencies;
    }

    public static org.apache.asterix.metadata.entities.Function lookupUserDefinedFunctionDecl(MetadataTransactionContext mdTxnCtx, FunctionSignature signature) throws AlgebricksException {
        if (signature.getDataverseName() == null) {
            return null;
        }
        return MetadataManager.INSTANCE.getFunction(mdTxnCtx, signature);
    }

    public static boolean isBuiltinDatasetFunction(FunctionSignature fs) {
        return Objects.equals(FN_DATASET_DATAVERSE_NAME, fs.getDataverseName()) && Objects.equals(FN_DATASET_NAME, fs.getName());
    }

    public static Pair<DataverseName, String> parseDatasetFunctionArguments(List<Mutable<ILogicalExpression>> datasetFnArgs, DataverseName defaultDataverseName, SourceLocation sourceLoc) throws CompilationException {
        return FunctionUtil.parseDatasetFunctionArguments(datasetFnArgs, defaultDataverseName, sourceLoc, FunctionUtil::getStringConstant);
    }

    public static <T> Pair<DataverseName, String> parseDatasetFunctionArguments(List<T> datasetFnArgs, DataverseName defaultDataverseName, SourceLocation sourceLoc, Function<T, String> argExtractFunction) throws CompilationException {
        String datasetName;
        DataverseName dataverseName;
        switch (datasetFnArgs.size()) {
            case 1: {
                String datasetArgBackCompat = argExtractFunction.apply(datasetFnArgs.get(0));
                if (datasetArgBackCompat == null) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Invalid argument to dataset()"});
                }
                int pos = datasetArgBackCompat.indexOf(46);
                if (pos > 0 && pos < datasetArgBackCompat.length() - 1) {
                    dataverseName = DataverseName.createSinglePartName((String)datasetArgBackCompat.substring(0, pos));
                    datasetName = datasetArgBackCompat.substring(pos + 1);
                    break;
                }
                dataverseName = defaultDataverseName;
                datasetName = datasetArgBackCompat;
                break;
            }
            case 2: {
                String dataverseNameArg = argExtractFunction.apply(datasetFnArgs.get(0));
                if (dataverseNameArg == null) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Invalid argument to dataset()"});
                }
                dataverseName = DataverseName.createFromCanonicalForm((String)dataverseNameArg);
                datasetName = argExtractFunction.apply(datasetFnArgs.get(1));
                if (datasetName != null) break;
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Invalid argument to dataset()"});
            }
            default: {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Invalid number of arguments to dataset()"});
            }
        }
        return new Pair((Object)dataverseName, (Object)datasetName);
    }

    private static String getStringConstant(Mutable<ILogicalExpression> arg) {
        return ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)arg.getValue()));
    }

    @FunctionalInterface
    public static interface IFunctionNormalizer {
        public FunctionSignature normalizeBuiltinFunctionSignature(FunctionSignature var1, SourceLocation var2) throws CompilationException;
    }

    @FunctionalInterface
    public static interface IFunctionCollector {
        public Set<CallExpr> getFunctionCalls(Expression var1) throws CompilationException;
    }
}

