/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.om.functions.BuiltinFunctions;

public class CommonFunctionMapUtil {
    private static final Map<String, String> FUNCTION_NAME_MAP = new HashMap<String, String>();

    private CommonFunctionMapUtil() {
    }

    public static FunctionSignature normalizeBuiltinFunctionSignature(FunctionSignature fs) {
        String name = fs.getName();
        String lowerCaseName = name.toLowerCase();
        String mappedName = CommonFunctionMapUtil.getFunctionMapping(lowerCaseName);
        if (mappedName != null) {
            return new FunctionSignature(fs.getDataverseName(), mappedName, fs.getArity());
        }
        String understoreName = lowerCaseName.replace('_', '-');
        FunctionSignature newFs = new FunctionSignature(fs.getDataverseName(), understoreName, fs.getArity());
        return BuiltinFunctions.isBuiltinCompilerFunction((FunctionSignature)newFs, (boolean)true) ? newFs : fs;
    }

    public static String getFunctionMapping(String alias) {
        return FUNCTION_NAME_MAP.get(alias);
    }

    public static void addFunctionMapping(String alias, String functionName) {
        FUNCTION_NAME_MAP.put(alias, functionName);
    }

    static {
        CommonFunctionMapUtil.addFunctionMapping("ceil", "ceiling");
        CommonFunctionMapUtil.addFunctionMapping("length", "string-length");
        CommonFunctionMapUtil.addFunctionMapping("lower", "lowercase");
        CommonFunctionMapUtil.addFunctionMapping("substr", "substring");
        CommonFunctionMapUtil.addFunctionMapping("upper", "uppercase");
        CommonFunctionMapUtil.addFunctionMapping("title", "initcap");
        CommonFunctionMapUtil.addFunctionMapping("int", "integer");
        CommonFunctionMapUtil.addFunctionMapping("tinyint", "int8");
        CommonFunctionMapUtil.addFunctionMapping("smallint", "int16");
        CommonFunctionMapUtil.addFunctionMapping("integer", "int32");
        CommonFunctionMapUtil.addFunctionMapping("bigint", "int64");
        CommonFunctionMapUtil.addFunctionMapping("pos", "position");
        CommonFunctionMapUtil.addFunctionMapping("pos0", "position");
        CommonFunctionMapUtil.addFunctionMapping("position0", "position");
        CommonFunctionMapUtil.addFunctionMapping("pos1", "position1");
        CommonFunctionMapUtil.addFunctionMapping("substr", "substring");
        CommonFunctionMapUtil.addFunctionMapping("substr0", "substring");
        CommonFunctionMapUtil.addFunctionMapping("substring0", "substring");
        CommonFunctionMapUtil.addFunctionMapping("substr1", "substring1");
        CommonFunctionMapUtil.addFunctionMapping("regex_contains", "matches");
        CommonFunctionMapUtil.addFunctionMapping("contains_regex", "matches");
        CommonFunctionMapUtil.addFunctionMapping("regexp_contains", "matches");
        CommonFunctionMapUtil.addFunctionMapping("contains_regexp", "matches");
        CommonFunctionMapUtil.addFunctionMapping("regex_like", "regexp-like");
        CommonFunctionMapUtil.addFunctionMapping("regex_pos", "regexp-position");
        CommonFunctionMapUtil.addFunctionMapping("regex_position", "regexp-position");
        CommonFunctionMapUtil.addFunctionMapping("regex_pos0", "regexp-position");
        CommonFunctionMapUtil.addFunctionMapping("regex_position0", "regexp-position");
        CommonFunctionMapUtil.addFunctionMapping("regexp_pos", "regexp-position");
        CommonFunctionMapUtil.addFunctionMapping("regexp_pos0", "regexp-position");
        CommonFunctionMapUtil.addFunctionMapping("regexp_position0", "regexp-position");
        CommonFunctionMapUtil.addFunctionMapping("regex_pos1", "regexp-position1");
        CommonFunctionMapUtil.addFunctionMapping("regex_position1", "regexp-position1");
        CommonFunctionMapUtil.addFunctionMapping("regexp_pos1", "regexp-position1");
        CommonFunctionMapUtil.addFunctionMapping("regex_replace", "regexp-replace");
        CommonFunctionMapUtil.addFunctionMapping("regex_matches", "regexp-matches");
        CommonFunctionMapUtil.addFunctionMapping("regex_split", "regexp-split");
        CommonFunctionMapUtil.addFunctionMapping("gettype", "get-type");
        CommonFunctionMapUtil.addFunctionMapping("isnull", "is-null");
        CommonFunctionMapUtil.addFunctionMapping("ismissing", "is-missing");
        CommonFunctionMapUtil.addFunctionMapping("isunknown", "is-unknown");
        CommonFunctionMapUtil.addFunctionMapping("isatomic", "is-atomic");
        CommonFunctionMapUtil.addFunctionMapping("isatom", "is-atomic");
        CommonFunctionMapUtil.addFunctionMapping("is_atom", "is-atomic");
        CommonFunctionMapUtil.addFunctionMapping("isboolean", "is-boolean");
        CommonFunctionMapUtil.addFunctionMapping("isbool", "is-boolean");
        CommonFunctionMapUtil.addFunctionMapping("is_bool", "is-boolean");
        CommonFunctionMapUtil.addFunctionMapping("isbinary", "is-binary");
        CommonFunctionMapUtil.addFunctionMapping("isbin", "is-binary");
        CommonFunctionMapUtil.addFunctionMapping("is_bin", "is-binary");
        CommonFunctionMapUtil.addFunctionMapping("ispoint", "is-point");
        CommonFunctionMapUtil.addFunctionMapping("isline", "is-line");
        CommonFunctionMapUtil.addFunctionMapping("isrectangle", "is-rectangle");
        CommonFunctionMapUtil.addFunctionMapping("iscircle", "is-circle");
        CommonFunctionMapUtil.addFunctionMapping("ispolygon", "is-polygon");
        CommonFunctionMapUtil.addFunctionMapping("isspatial", "is-spatial");
        CommonFunctionMapUtil.addFunctionMapping("isdate", "is-date");
        CommonFunctionMapUtil.addFunctionMapping("isdatetime", "is-datetime");
        CommonFunctionMapUtil.addFunctionMapping("istimestamp", "is-datetime");
        CommonFunctionMapUtil.addFunctionMapping("is_timestamp", "is-datetime");
        CommonFunctionMapUtil.addFunctionMapping("istime", "is-time");
        CommonFunctionMapUtil.addFunctionMapping("isduration", "is-duration");
        CommonFunctionMapUtil.addFunctionMapping("isinterval", "is-interval");
        CommonFunctionMapUtil.addFunctionMapping("istemporal", "is-temporal");
        CommonFunctionMapUtil.addFunctionMapping("isuuid", "is-uuid");
        CommonFunctionMapUtil.addFunctionMapping("isnumber", "is-number");
        CommonFunctionMapUtil.addFunctionMapping("isnum", "is-number");
        CommonFunctionMapUtil.addFunctionMapping("is_num", "is-number");
        CommonFunctionMapUtil.addFunctionMapping("isstring", "is-string");
        CommonFunctionMapUtil.addFunctionMapping("isstr", "is-string");
        CommonFunctionMapUtil.addFunctionMapping("is_str", "is-string");
        CommonFunctionMapUtil.addFunctionMapping("isarray", "is-array");
        CommonFunctionMapUtil.addFunctionMapping("ismultiset", "is-multiset");
        CommonFunctionMapUtil.addFunctionMapping("isobject", "is-object");
        CommonFunctionMapUtil.addFunctionMapping("isobj", "is-object");
        CommonFunctionMapUtil.addFunctionMapping("is_obj", "is-object");
        CommonFunctionMapUtil.addFunctionMapping("ifmissing", "if-missing");
        CommonFunctionMapUtil.addFunctionMapping("ifnull", "if-null");
        CommonFunctionMapUtil.addFunctionMapping("ifmissingornull", "if-missing-or-null");
        CommonFunctionMapUtil.addFunctionMapping("ifinf", "if-inf");
        CommonFunctionMapUtil.addFunctionMapping("ifnan", "if-nan");
        CommonFunctionMapUtil.addFunctionMapping("ifnanorinf", "if-nan-or-inf");
        CommonFunctionMapUtil.addFunctionMapping("coalesce", "if-missing-or-null");
        CommonFunctionMapUtil.addFunctionMapping("missingif", "missing-if");
        CommonFunctionMapUtil.addFunctionMapping("nanif", "nan-if");
        CommonFunctionMapUtil.addFunctionMapping("neginfif", "neginf-if");
        CommonFunctionMapUtil.addFunctionMapping("nullif", "null-if");
        CommonFunctionMapUtil.addFunctionMapping("posinfif", "posinf-if");
        CommonFunctionMapUtil.addFunctionMapping("toarray", "to-array");
        CommonFunctionMapUtil.addFunctionMapping("toatomic", "to-atomic");
        CommonFunctionMapUtil.addFunctionMapping("toatom", "to-atomic");
        CommonFunctionMapUtil.addFunctionMapping("to_atom", "to-atomic");
        CommonFunctionMapUtil.addFunctionMapping("toboolean", "to-boolean");
        CommonFunctionMapUtil.addFunctionMapping("tobool", "to-boolean");
        CommonFunctionMapUtil.addFunctionMapping("to_bool", "to-boolean");
        CommonFunctionMapUtil.addFunctionMapping("tobigint", "to-bigint");
        CommonFunctionMapUtil.addFunctionMapping("todouble", "to-double");
        CommonFunctionMapUtil.addFunctionMapping("tostring", "to-string");
        CommonFunctionMapUtil.addFunctionMapping("tostr", "to-string");
        CommonFunctionMapUtil.addFunctionMapping("to_str", "to-string");
        CommonFunctionMapUtil.addFunctionMapping("tonumber", "to-number");
        CommonFunctionMapUtil.addFunctionMapping("tonum", "to-number");
        CommonFunctionMapUtil.addFunctionMapping("to_num", "to-number");
        CommonFunctionMapUtil.addFunctionMapping("toobject", "to-object");
        CommonFunctionMapUtil.addFunctionMapping("toobj", "to-object");
        CommonFunctionMapUtil.addFunctionMapping("to_obj", "to-object");
        CommonFunctionMapUtil.addFunctionMapping("record-merge", "object-merge");
        CommonFunctionMapUtil.addFunctionMapping("record-concat", "object-concat");
        CommonFunctionMapUtil.addFunctionMapping("record-get-fields", "object-get-fields");
        CommonFunctionMapUtil.addFunctionMapping("record-get-field-value", "object-get-field-value");
        CommonFunctionMapUtil.addFunctionMapping("record-add-fields", "object-add-fields");
        CommonFunctionMapUtil.addFunctionMapping("record-remove-fields", "object-remove-fields");
        CommonFunctionMapUtil.addFunctionMapping("array_agg", "arrayagg");
        CommonFunctionMapUtil.addFunctionMapping("array_agg-distinct", "arrayagg-distinct");
        CommonFunctionMapUtil.addFunctionMapping("array_length", "len");
        CommonFunctionMapUtil.addFunctionMapping("stddev", "stddev_samp");
        CommonFunctionMapUtil.addFunctionMapping("variance", "var_samp");
        CommonFunctionMapUtil.addFunctionMapping("variance_samp", "var_samp");
        CommonFunctionMapUtil.addFunctionMapping("variance_pop", "var_pop");
    }
}

