/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.typecast;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.dataflow.data.common.TypeResolverUtil;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeHelper;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

public class StaticTypeCastUtil {
    private StaticTypeCastUtil() {
    }

    public static boolean rewriteListExpr(AbstractFunctionCallExpression funcExpr, IAType reqType, IAType inputType, IVariableTypeEnvironment env) throws AlgebricksException {
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.UNORDERED_LIST_CONSTRUCTOR) {
            if (reqType.equals(BuiltinType.ANY)) {
                reqType = DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE;
            }
            return StaticTypeCastUtil.rewriteListFuncExpr(funcExpr, (AbstractCollectionType)reqType, (AbstractCollectionType)inputType, env);
        }
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR) {
            if (reqType.equals(BuiltinType.ANY)) {
                reqType = DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE;
            }
            return StaticTypeCastUtil.rewriteListFuncExpr(funcExpr, (AbstractCollectionType)reqType, (AbstractCollectionType)inputType, env);
        }
        List args = funcExpr.getArguments();
        boolean changed = false;
        for (Mutable arg : args) {
            ILogicalExpression argExpr = (ILogicalExpression)arg.getValue();
            if (argExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            AbstractFunctionCallExpression argFuncExpr = (AbstractFunctionCallExpression)argExpr;
            IAType exprType = (IAType)env.getType((ILogicalExpression)argFuncExpr);
            changed = StaticTypeCastUtil.rewriteListExpr(argFuncExpr, exprType, exprType, env) || changed;
        }
        return changed;
    }

    public static boolean rewriteFuncExpr(AbstractFunctionCallExpression funcExpr, IAType reqType, IAType inputType, IVariableTypeEnvironment env) throws AlgebricksException {
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.UNORDERED_LIST_CONSTRUCTOR) {
            if (reqType.equals(BuiltinType.ANY)) {
                reqType = DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE;
            }
            return StaticTypeCastUtil.rewriteListFuncExpr(funcExpr, (AbstractCollectionType)reqType, (AbstractCollectionType)inputType, env);
        }
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR) {
            if (reqType.equals(BuiltinType.ANY)) {
                reqType = DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE;
            }
            return StaticTypeCastUtil.rewriteListFuncExpr(funcExpr, (AbstractCollectionType)reqType, (AbstractCollectionType)inputType, env);
        }
        if (inputType.getTypeTag().equals((Object)ATypeTag.OBJECT)) {
            if (reqType.equals(BuiltinType.ANY)) {
                reqType = DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
            }
            return StaticTypeCastUtil.rewriteRecordFuncExpr(funcExpr, (ARecordType)reqType, (ARecordType)inputType, env);
        }
        List args = funcExpr.getArguments();
        boolean changed = false;
        for (Mutable arg : args) {
            ILogicalExpression argExpr = (ILogicalExpression)arg.getValue();
            if (argExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            AbstractFunctionCallExpression argFuncExpr = (AbstractFunctionCallExpression)argExpr;
            IAType exprType = (IAType)env.getType((ILogicalExpression)argFuncExpr);
            changed = StaticTypeCastUtil.rewriteFuncExpr(argFuncExpr, exprType, exprType, env) || changed;
        }
        if (!StaticTypeCastUtil.compatible(reqType, inputType)) {
            throw new CompilationException(1079, funcExpr.getSourceLocation(), new Serializable[]{"type mismatch, required: " + reqType.toString() + " actual: " + inputType.toString()});
        }
        return changed;
    }

    private static boolean rewriteRecordFuncExpr(AbstractFunctionCallExpression funcExpr, ARecordType requiredRecordType, ARecordType inputRecordType, IVariableTypeEnvironment env) throws AlgebricksException {
        if (TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)funcExpr) != null) {
            return false;
        }
        boolean casted = StaticTypeCastUtil.staticRecordTypeCast(funcExpr, requiredRecordType, inputRecordType, env);
        if (casted) {
            TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)funcExpr, (IAType)requiredRecordType, (IAType)inputRecordType);
        }
        return casted;
    }

    private static boolean rewriteListFuncExpr(AbstractFunctionCallExpression funcExpr, AbstractCollectionType requiredListType, AbstractCollectionType inputListType, IVariableTypeEnvironment env) throws AlgebricksException {
        if (TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)funcExpr) != null) {
            return false;
        }
        TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)funcExpr, (IAType)requiredListType, (IAType)inputListType);
        List args = funcExpr.getArguments();
        IAType requiredItemType = requiredListType.getItemType();
        IAType inputItemType = inputListType.getItemType();
        boolean changed = false;
        block4: for (int j = 0; j < args.size(); ++j) {
            Mutable argRef = (Mutable)args.get(j);
            ILogicalExpression arg = (ILogicalExpression)argRef.getValue();
            IAType currentItemType = inputItemType == null || inputItemType == BuiltinType.ANY ? (IAType)env.getType(arg) : inputItemType;
            switch (arg.getExpressionTag()) {
                case FUNCTION_CALL: {
                    ScalarFunctionCallExpression argFunc = (ScalarFunctionCallExpression)arg;
                    changed |= StaticTypeCastUtil.rewriteFuncExpr((AbstractFunctionCallExpression)argFunc, requiredItemType, currentItemType, env);
                    changed |= StaticTypeCastUtil.castItem((Mutable<ILogicalExpression>)argRef, argFunc, requiredItemType, env);
                    continue block4;
                }
                case VARIABLE: {
                    changed |= StaticTypeCastUtil.injectCastToRelaxType((Mutable<ILogicalExpression>)argRef, currentItemType, env);
                }
            }
        }
        return changed;
    }

    private static boolean castItem(Mutable<ILogicalExpression> itemExprRef, ScalarFunctionCallExpression itemExpr, IAType requiredItemType, IVariableTypeEnvironment env) throws AlgebricksException {
        IAType itemType = (IAType)env.getType((ILogicalExpression)itemExpr);
        if (TypeResolverUtil.needsCast((IAType)requiredItemType, (IAType)itemType) && !StaticTypeCastUtil.satisfied(requiredItemType, itemType)) {
            StaticTypeCastUtil.injectCastFunction(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CAST_TYPE), requiredItemType, itemType, itemExprRef, (ILogicalExpression)itemExpr);
            return true;
        }
        return false;
    }

    private static boolean satisfied(IAType required, IAType actual) {
        return required.getTypeTag() == ATypeTag.ANY && TypeHelper.isFullyOpen((IAType)actual);
    }

    private static boolean staticRecordTypeCast(AbstractFunctionCallExpression func, ARecordType reqType, ARecordType inputType, IVariableTypeEnvironment env) throws AlgebricksException {
        int i;
        int i2;
        if (func.getFunctionIdentifier() != BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR && func.getFunctionIdentifier() != BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR) {
            return false;
        }
        List arguments = func.getArguments();
        int fieldArgumentCount = arguments.size() / 2;
        IAType[] reqFieldTypes = reqType.getFieldTypes();
        String[] reqFieldNames = reqType.getFieldNames();
        IAType[] inputFieldTypes = inputType.getFieldTypes();
        String[] inputFieldNames = inputType.getFieldNames();
        int[] fieldPermutation = new int[reqFieldTypes.length];
        BitSet nullFields = new BitSet(reqFieldTypes.length);
        BitSet openFields = new BitSet(fieldArgumentCount);
        Arrays.fill(fieldPermutation, -1);
        openFields.set(0, fieldArgumentCount);
        for (i2 = 0; i2 < inputFieldNames.length; ++i2) {
            String fieldName = inputFieldNames[i2];
            IAType fieldType = inputFieldTypes[i2];
            int fieldNameArgumentIdx = StaticTypeCastUtil.findFieldNameArgumentIdx(arguments, fieldName);
            if (fieldNameArgumentIdx < 0) {
                return false;
            }
            int fieldValueArgumentIdx = fieldNameArgumentIdx + 1;
            int fieldArgumentIdx = fieldNameArgumentIdx / 2;
            ILogicalExpression arg = (ILogicalExpression)((Mutable)arguments.get(fieldValueArgumentIdx)).getValue();
            boolean matched = false;
            for (int j = 0; j < reqFieldNames.length; ++j) {
                IAType itemType;
                ScalarFunctionCallExpression scalarFunc;
                String reqFieldName = reqFieldNames[j];
                IAType reqFieldType = reqFieldTypes[j];
                if (!fieldName.equals(reqFieldName)) continue;
                if (fieldType.equals(reqFieldType)) {
                    fieldPermutation[j] = fieldNameArgumentIdx;
                    openFields.clear(fieldArgumentIdx);
                    matched = true;
                    if (arg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) break;
                    scalarFunc = (ScalarFunctionCallExpression)arg;
                    StaticTypeCastUtil.rewriteFuncExpr((AbstractFunctionCallExpression)scalarFunc, reqFieldType, fieldType, env);
                    break;
                }
                if (NonTaggedFormatUtil.isOptional((IAType)reqFieldType)) {
                    reqFieldType = itemType = ((AUnionType)reqFieldType).getActualType();
                    if (fieldType.equals(BuiltinType.AMISSING) || fieldType.equals(itemType)) {
                        fieldPermutation[j] = fieldNameArgumentIdx;
                        openFields.clear(fieldArgumentIdx);
                        matched = true;
                        if (arg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) break;
                        ScalarFunctionCallExpression scalarFunc2 = (ScalarFunctionCallExpression)arg;
                        StaticTypeCastUtil.rewriteFuncExpr((AbstractFunctionCallExpression)scalarFunc2, reqFieldType, fieldType, env);
                        break;
                    }
                }
                if (NonTaggedFormatUtil.isOptional((IAType)fieldType) && reqFieldType.equals(itemType = ((AUnionType)fieldType).getActualType())) {
                    fieldPermutation[j] = fieldNameArgumentIdx;
                    openFields.clear(fieldArgumentIdx);
                    matched = true;
                    ScalarFunctionCallExpression notNullFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CHECK_UNKNOWN));
                    notNullFunc.getArguments().add(new MutableObject((Object)arg));
                    ((Mutable)arguments.get(fieldValueArgumentIdx)).setValue((Object)notNullFunc);
                    break;
                }
                if (arg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                scalarFunc = (ScalarFunctionCallExpression)arg;
                StaticTypeCastUtil.rewriteFuncExpr((AbstractFunctionCallExpression)scalarFunc, reqFieldType, fieldType, env);
                fieldPermutation[j] = fieldNameArgumentIdx;
                openFields.clear(fieldArgumentIdx);
                matched = true;
                break;
            }
            if (matched || reqType.isOpen()) continue;
            throw new AlgebricksException("static type mismatch: the input record includes an extra closed field " + fieldName + ":" + fieldType + "! Please check the field name and type.");
        }
        for (i2 = 0; i2 < reqFieldNames.length; ++i2) {
            String reqFieldName = reqFieldNames[i2];
            IAType reqFieldType = reqFieldTypes[i2];
            boolean matched = false;
            for (int j = 0; j < inputFieldNames.length; ++j) {
                String fieldName = inputFieldNames[j];
                IAType fieldType = inputFieldTypes[j];
                if (!fieldName.equals(reqFieldName)) continue;
                int fieldNameArgumentIdx = StaticTypeCastUtil.findFieldNameArgumentIdx(arguments, fieldName);
                if (fieldNameArgumentIdx < 0) {
                    return false;
                }
                int fieldArgumentIdx = fieldNameArgumentIdx / 2;
                if (!openFields.get(fieldArgumentIdx)) {
                    matched = true;
                    break;
                }
                if (!NonTaggedFormatUtil.isOptional((IAType)reqFieldType)) continue;
                IAType itemType = ((AUnionType)reqFieldType).getActualType();
                if (!fieldType.equals(BuiltinType.AMISSING) && !fieldType.equals(itemType)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            if (NonTaggedFormatUtil.isOptional((IAType)reqFieldType)) {
                nullFields.set(i2);
                continue;
            }
            if (inputType.isOpen()) {
                return false;
            }
            throw new AlgebricksException("static type mismatch: the input record misses a required closed field " + reqFieldName + ":" + reqFieldType + "! Please check the field name and type.");
        }
        ArrayList newArguments = new ArrayList(arguments.size());
        for (i = 0; i < reqFieldTypes.length; ++i) {
            int pos = fieldPermutation[i];
            if (pos >= 0) {
                newArguments.add(arguments.get(pos));
                newArguments.add(arguments.get(pos + 1));
            }
            if (!nullFields.get(i)) continue;
            newArguments.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(reqFieldNames[i])))));
            newArguments.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ANull.NULL))));
        }
        i = openFields.nextSetBit(0);
        while (i >= 0) {
            newArguments.add(arguments.get(i * 2));
            Mutable expRef = (Mutable)arguments.get(i * 2 + 1);
            IAType expType = (IAType)env.getType((ILogicalExpression)expRef.getValue());
            StaticTypeCastUtil.injectCastToRelaxType((Mutable<ILogicalExpression>)expRef, expType, env);
            newArguments.add(expRef);
            i = openFields.nextSetBit(i + 1);
        }
        arguments.clear();
        arguments.addAll(newArguments);
        return true;
    }

    private static int findFieldNameArgumentIdx(List<Mutable<ILogicalExpression>> arguments, String fieldName) {
        String n;
        int ln = arguments.size();
        for (int i = 0; i < ln && (n = ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)arguments.get(i).getValue()))) != null; i += 2) {
            if (!fieldName.equals(n)) continue;
            return i;
        }
        return -1;
    }

    private static boolean injectCastToRelaxType(Mutable<ILogicalExpression> expRef, IAType expType, IVariableTypeEnvironment env) throws AlgebricksException {
        ILogicalExpression argExpr = (ILogicalExpression)expRef.getValue();
        ArrayList parameterVars = new ArrayList();
        argExpr.getUsedVariables(parameterVars);
        boolean castInjected = false;
        if (argExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL || argExpr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            IAType exprActualType = expType;
            if (expType.getTypeTag() == ATypeTag.UNION) {
                exprActualType = ((AUnionType)expType).getActualType();
            }
            IAType requiredType = exprActualType;
            switch (exprActualType.getTypeTag()) {
                case OBJECT: {
                    requiredType = DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
                    break;
                }
                case ARRAY: {
                    requiredType = DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE;
                    break;
                }
                case MULTISET: {
                    requiredType = DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE;
                    break;
                }
            }
            if (!(exprActualType.equals(requiredType) || parameterVars.isEmpty() && StaticTypeCastUtil.isComplexConstructor(argExpr))) {
                StaticTypeCastUtil.injectCastFunction(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CAST_TYPE), requiredType, expType, expRef, argExpr);
                castInjected = true;
            }
            if (argExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)((AbstractFunctionCallExpression)argExpr)) == null) {
                AbstractFunctionCallExpression argFunc = (AbstractFunctionCallExpression)argExpr;
                if (castInjected) {
                    StaticTypeCastUtil.rewriteFuncExpr(argFunc, exprActualType, exprActualType, env);
                } else {
                    StaticTypeCastUtil.rewriteFuncExpr(argFunc, requiredType, exprActualType, env);
                }
            }
        }
        return castInjected;
    }

    private static boolean isComplexConstructor(ILogicalExpression expression) {
        if (expression.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            FunctionIdentifier funIdentifier = ((AbstractFunctionCallExpression)expression).getFunctionIdentifier();
            return funIdentifier.equals((Object)BuiltinFunctions.UNORDERED_LIST_CONSTRUCTOR) || funIdentifier.equals((Object)BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR) || funIdentifier.equals((Object)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR) || funIdentifier.equals((Object)BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR);
        }
        return false;
    }

    private static void injectCastFunction(IFunctionInfo funcInfo, IAType reqType, IAType inputType, Mutable<ILogicalExpression> exprRef, ILogicalExpression argExpr) throws AlgebricksException {
        ScalarFunctionCallExpression cast = new ScalarFunctionCallExpression(funcInfo);
        cast.getArguments().add(new MutableObject((Object)argExpr));
        cast.setSourceLocation(argExpr.getSourceLocation());
        exprRef.setValue((Object)cast);
        TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)cast, (IAType)reqType, (IAType)inputType);
    }

    public static boolean compatible(IAType reqType, IAType inputType) {
        AUnionType unionType;
        if (reqType.getTypeTag() == ATypeTag.ANY || inputType.getTypeTag() == ATypeTag.ANY) {
            return true;
        }
        if (reqType.getTypeTag() != ATypeTag.UNION && inputType.getTypeTag() != ATypeTag.UNION) {
            return reqType.equals(inputType);
        }
        HashSet<IAType> reqTypePossible = new HashSet<IAType>();
        HashSet<IAType> inputTypePossible = new HashSet<IAType>();
        if (reqType.getTypeTag() == ATypeTag.UNION) {
            unionType = (AUnionType)reqType;
            reqTypePossible.addAll(unionType.getUnionList());
        } else {
            reqTypePossible.add(reqType);
        }
        if (inputType.getTypeTag() == ATypeTag.UNION) {
            unionType = (AUnionType)inputType;
            inputTypePossible.addAll(unionType.getUnionList());
        } else {
            inputTypePossible.add(inputType);
        }
        return reqTypePossible.equals(inputTypePossible);
    }
}

