/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.asterix.optimizer.rules.am.RTreeJobGenParams;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Quadruple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractDataSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;

public class RTreeAccessMethod
implements IAccessMethod {
    private static final List<Pair<FunctionIdentifier, Boolean>> FUNC_IDENTIFIERS = Collections.unmodifiableList(Arrays.asList(new Pair((Object)BuiltinFunctions.SPATIAL_INTERSECT, (Object)true), new Pair((Object)BuiltinFunctions.ST_INTERSECTS, (Object)true), new Pair((Object)BuiltinFunctions.ST_CONTAINS, (Object)true), new Pair((Object)BuiltinFunctions.ST_CROSSES, (Object)true), new Pair((Object)BuiltinFunctions.ST_OVERLAPS, (Object)true), new Pair((Object)BuiltinFunctions.ST_TOUCHES, (Object)true), new Pair((Object)BuiltinFunctions.ST_WITHIN, (Object)true), new Pair((Object)BuiltinFunctions.ST_DISJOINT, (Object)true)));
    public static final RTreeAccessMethod INSTANCE = new RTreeAccessMethod();

    @Override
    public List<Pair<FunctionIdentifier, Boolean>> getOptimizableFunctions() {
        return FUNC_IDENTIFIERS;
    }

    @Override
    public boolean analyzeFuncExprArgsAndUpdateAnalysisCtx(AbstractFunctionCallExpression funcExpr, List<AbstractLogicalOperator> assignsAndUnnests, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        boolean matches = AccessMethodUtils.analyzeFuncExprArgsForOneConstAndVarAndUpdateAnalysisCtx(funcExpr, analysisCtx, context, typeEnvironment);
        if (!matches) {
            matches = AccessMethodUtils.analyzeFuncExprArgsForTwoVarsAndUpdateAnalysisCtx(funcExpr, analysisCtx);
        }
        return matches;
    }

    @Override
    public boolean matchAllIndexExprs(Index index) {
        return true;
    }

    @Override
    public boolean matchPrefixIndexExprs(Index index) {
        return false;
    }

    @Override
    public boolean applySelectPlanTransformation(List<Mutable<ILogicalOperator>> afterSelectRefs, Mutable<ILogicalOperator> selectRef, OptimizableOperatorSubTree subTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context) throws AlgebricksException {
        int optFieldIdx;
        SelectOperator selectOp = (SelectOperator)selectRef.getValue();
        Mutable conditionRef = selectOp.getCondition();
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)conditionRef.getValue();
        ARecordType recordType = subTree.getRecordType();
        IOptimizableFuncExpr optFuncExpr = AccessMethodUtils.chooseFirstOptFuncExpr(chosenIndex, analysisCtx);
        Pair keyPairType = Index.getNonNullableOpenFieldType((IAType)optFuncExpr.getFieldType(optFieldIdx = AccessMethodUtils.chooseFirstOptFuncVar(chosenIndex, analysisCtx)), optFuncExpr.getFieldName(optFieldIdx), (ARecordType)recordType);
        if (keyPairType == null) {
            return false;
        }
        boolean isIndexOnlyPlan = false;
        boolean secondaryKeyFieldUsedAfterSelectOp = false;
        boolean requireVerificationAfterSIdxSearch = false;
        Pair<Boolean, Boolean> functionFalsePositiveCheck = AccessMethodUtils.canFunctionGenerateFalsePositiveResultsUsingIndex(funcExpr, FUNC_IDENTIFIERS);
        if (!((Boolean)functionFalsePositiveCheck.first).booleanValue()) {
            return false;
        }
        boolean doesSIdxSearchCoverAllPredicates = false;
        if (((IAType)keyPairType.first).getTypeTag() == BuiltinType.APOINT.getTypeTag() || ((IAType)keyPairType.first).getTypeTag() == BuiltinType.ARECTANGLE.getTypeTag()) {
            isIndexOnlyPlan = true;
            requireVerificationAfterSIdxSearch = false;
        } else {
            isIndexOnlyPlan = false;
            requireVerificationAfterSIdxSearch = true;
        }
        Quadruple indexOnlyPlanInfo = new Quadruple((Object)isIndexOnlyPlan, (Object)secondaryKeyFieldUsedAfterSelectOp, (Object)requireVerificationAfterSIdxSearch, (Object)doesSIdxSearchCoverAllPredicates);
        Dataset dataset = subTree.getDataset();
        if (isIndexOnlyPlan) {
            if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                AccessMethodUtils.indexOnlyPlanCheck(afterSelectRefs, selectRef, subTree, null, chosenIndex, analysisCtx, context, (Quadruple<Boolean, Boolean, Boolean, Boolean>)indexOnlyPlanInfo);
                isIndexOnlyPlan = (Boolean)indexOnlyPlanInfo.getFirst();
            } else {
                isIndexOnlyPlan = false;
                indexOnlyPlanInfo.setFirst((Object)isIndexOnlyPlan);
            }
        }
        analysisCtx.setIndexOnlyPlanInfo((Quadruple<Boolean, Boolean, Boolean, Boolean>)indexOnlyPlanInfo);
        ILogicalOperator primaryIndexUnnestOp = this.createIndexSearchPlan(afterSelectRefs, selectRef, (Mutable<ILogicalExpression>)selectOp.getCondition(), subTree.getAssignsAndUnnestsRefs(), subTree, null, chosenIndex, analysisCtx, AccessMethodUtils.retainInputs(subTree.getDataSourceVariables(), (ILogicalOperator)subTree.getDataSourceRef().getValue(), afterSelectRefs), false, false, context, null);
        if (primaryIndexUnnestOp == null) {
            return false;
        }
        if (!isIndexOnlyPlan || dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            subTree.getDataSourceRef().setValue((Object)primaryIndexUnnestOp);
        } else if (primaryIndexUnnestOp.getOperatorTag() == LogicalOperatorTag.UNIONALL) {
            selectRef.setValue((Object)primaryIndexUnnestOp);
        } else {
            subTree.getDataSourceRef().setValue((Object)primaryIndexUnnestOp);
        }
        return true;
    }

    @Override
    public ILogicalOperator createIndexSearchPlan(List<Mutable<ILogicalOperator>> afterTopRefs, Mutable<ILogicalOperator> topRef, Mutable<ILogicalExpression> conditionRef, List<Mutable<ILogicalOperator>> assignBeforeTopRefs, OptimizableOperatorSubTree indexSubTree, OptimizableOperatorSubTree probeSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, boolean retainInput, boolean retainNull, boolean requiresBroadcast, IOptimizationContext context, LogicalVariable newNullPlaceHolderForLOJ) throws AlgebricksException {
        List<String> optFieldName;
        IOptimizableFuncExpr optFuncExpr = AccessMethodUtils.chooseFirstOptFuncExpr(chosenIndex, analysisCtx);
        Dataset dataset = indexSubTree.getDataset();
        ARecordType recordType = indexSubTree.getRecordType();
        ARecordType metaRecordType = indexSubTree.getMetaRecordType();
        int optFieldIdx = AccessMethodUtils.chooseFirstOptFuncVar(chosenIndex, analysisCtx);
        IAType optFieldType = optFuncExpr.getFieldType(optFieldIdx);
        Pair keyPairType = Index.getNonNullableOpenFieldType((IAType)optFieldType, optFieldName = optFuncExpr.getFieldName(optFieldIdx), (ARecordType)recordType);
        if (keyPairType == null) {
            return null;
        }
        IAType spatialType = (IAType)keyPairType.first;
        int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
        int numSecondaryKeys = numDimensions * 2;
        Quadruple<Boolean, Boolean, Boolean, Boolean> indexOnlyPlanInfo = analysisCtx.getIndexOnlyPlanInfo();
        boolean isIndexOnlyPlan = (Boolean)indexOnlyPlanInfo.getFirst();
        boolean generateInstantTrylockResultFromIndexSearch = dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL && isIndexOnlyPlan;
        AbstractDataSourceOperator dataSourceOp = (AbstractDataSourceOperator)indexSubTree.getDataSourceRef().getValue();
        RTreeJobGenParams jobGenParams = new RTreeJobGenParams(chosenIndex.getIndexName(), DatasetConfig.IndexType.RTREE, dataset.getDataverseName(), dataset.getDatasetName(), retainInput, requiresBroadcast);
        ArrayList<LogicalVariable> keyVarList = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> keyExprList = new ArrayList<MutableObject>();
        ILogicalExpression returnedSearchKeyExpr = (ILogicalExpression)AccessMethodUtils.createSearchKeyExpr((Index)chosenIndex, (IOptimizableFuncExpr)optFuncExpr, (IAType)optFieldType, (OptimizableOperatorSubTree)probeSubTree).first;
        for (int i = 0; i < numSecondaryKeys; ++i) {
            ScalarFunctionCallExpression createMBR = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_MBR));
            createMBR.setSourceLocation(optFuncExpr.getFuncExpr().getSourceLocation());
            createMBR.getArguments().add(new MutableObject((Object)returnedSearchKeyExpr));
            createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(numDimensions)))));
            createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(i)))));
            LogicalVariable keyVar = context.newVar();
            keyVarList.add(keyVar);
            keyExprList.add(new MutableObject((Object)createMBR));
        }
        jobGenParams.setKeyVarList(keyVarList);
        AssignOperator assignSearchKeys = new AssignOperator(keyVarList, keyExprList);
        if (probeSubTree == null) {
            assignSearchKeys.setSourceLocation(dataSourceOp.getSourceLocation());
            assignSearchKeys.getInputs().add(new MutableObject((Object)OperatorManipulationUtil.deepCopy((ILogicalOperator)((ILogicalOperator)((Mutable)dataSourceOp.getInputs().get(0)).getValue()))));
            assignSearchKeys.setExecutionMode(dataSourceOp.getExecutionMode());
        } else {
            assignSearchKeys.setSourceLocation(probeSubTree.getRoot().getSourceLocation());
            assignSearchKeys.getInputs().add(probeSubTree.getRootRef());
            assignSearchKeys.setExecutionMode(dataSourceOp.getExecutionMode());
            OperatorPropertiesUtil.typeOpRec(probeSubTree.getRootRef(), (IOptimizationContext)context);
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignSearchKeys);
        ILogicalOperator secondaryIndexUnnestOp = AccessMethodUtils.createSecondaryIndexUnnestMap(dataset, recordType, metaRecordType, chosenIndex, (ILogicalOperator)assignSearchKeys, jobGenParams, context, retainInput, retainNull, generateInstantTrylockResultFromIndexSearch);
        return dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL ? AccessMethodUtils.createExternalDataLookupUnnestMap(dataSourceOp, dataset, recordType, metaRecordType, secondaryIndexUnnestOp, context, chosenIndex, retainInput, retainNull) : AccessMethodUtils.createRestOfIndexSearchPlan(afterTopRefs, topRef, conditionRef, assignBeforeTopRefs, dataSourceOp, dataset, recordType, metaRecordType, secondaryIndexUnnestOp, context, true, retainInput, retainNull, false, chosenIndex, analysisCtx, indexSubTree, newNullPlaceHolderForLOJ);
    }

    @Override
    public boolean applyJoinPlanTransformation(List<Mutable<ILogicalOperator>> afterJoinRefs, Mutable<ILogicalOperator> joinRef, OptimizableOperatorSubTree leftSubTree, OptimizableOperatorSubTree rightSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, boolean isLeftOuterJoin, boolean isLeftOuterJoinWithSpecialGroupBy) throws AlgebricksException {
        boolean canContinue;
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)joinRef.getValue();
        Mutable conditionRef = joinOp.getCondition();
        AbstractFunctionCallExpression funcExpr = null;
        if (((ILogicalExpression)conditionRef.getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            funcExpr = (AbstractFunctionCallExpression)conditionRef.getValue();
        }
        Dataset dataset = analysisCtx.getIndexDatasetMap().get(chosenIndex);
        OptimizableOperatorSubTree indexSubTree = null;
        OptimizableOperatorSubTree probeSubTree = null;
        if (!rightSubTree.hasDataSourceScan() || !dataset.getDatasetName().equals(rightSubTree.getDataset().getDatasetName())) {
            return false;
        }
        indexSubTree = rightSubTree;
        probeSubTree = leftSubTree;
        LogicalVariable newNullPlaceHolderVar = null;
        if (isLeftOuterJoin) {
            newNullPlaceHolderVar = indexSubTree.getDataSourceVariables().get(0);
        }
        if (!(canContinue = AccessMethodUtils.setIndexOnlyPlanInfo(afterJoinRefs, joinRef, probeSubTree, indexSubTree, chosenIndex, analysisCtx, context, funcExpr, FUNC_IDENTIFIERS))) {
            return false;
        }
        ILogicalOperator indexSearchOp = this.createIndexSearchPlan(afterJoinRefs, joinRef, (Mutable<ILogicalExpression>)conditionRef, indexSubTree.getAssignsAndUnnestsRefs(), indexSubTree, probeSubTree, chosenIndex, analysisCtx, true, isLeftOuterJoin, true, context, newNullPlaceHolderVar);
        if (indexSearchOp == null) {
            return false;
        }
        return AccessMethodUtils.finalizeJoinPlanTransformation(afterJoinRefs, joinRef, indexSubTree, probeSubTree, analysisCtx, context, isLeftOuterJoin, isLeftOuterJoinWithSpecialGroupBy, indexSearchOp, newNullPlaceHolderVar, (Mutable<ILogicalExpression>)conditionRef, dataset);
    }

    @Override
    public boolean exprIsOptimizable(Index index, IOptimizableFuncExpr optFuncExpr) {
        return !optFuncExpr.getFuncExpr().getAnnotations().containsKey(SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE);
    }

    @Override
    public String getName() {
        return "RTREE_ACCESS_METHOD";
    }

    @Override
    public int compareTo(IAccessMethod o) {
        return this.getName().compareTo(o.getName());
    }
}

