/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.algebra.operators.physical.BTreeSearchPOperator;
import org.apache.asterix.algebra.operators.physical.InvertedIndexPOperator;
import org.apache.asterix.algebra.operators.physical.RTreeSearchPOperator;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.base.AnalysisUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodJobGenParams;
import org.apache.asterix.optimizer.rules.am.BTreeJobGenParams;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractWindowPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.ExternalGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.WindowPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.WindowStreamPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.rewriter.rules.SetAlgebricksPhysicalOperatorsRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public final class SetAsterixPhysicalOperatorsRule
extends SetAlgebricksPhysicalOperatorsRule {
    protected ILogicalOperatorVisitor<IPhysicalOperator, Boolean> createPhysicalOperatorFactoryVisitor(IOptimizationContext context) {
        return new AsterixPhysicalOperatorFactoryVisitor(context);
    }

    private static class AsterixPhysicalOperatorFactoryVisitor
    extends SetAlgebricksPhysicalOperatorsRule.AlgebricksPhysicalOperatorFactoryVisitor {
        private AsterixPhysicalOperatorFactoryVisitor(IOptimizationContext context) {
            super(context);
        }

        public ExternalGroupByPOperator createExternalGroupByPOperator(GroupByOperator gby) throws AlgebricksException {
            Mutable r0 = (Mutable)((ILogicalPlan)gby.getNestedPlans().get(0)).getRoots().get(0);
            if (!((ILogicalOperator)r0.getValue()).getOperatorTag().equals((Object)LogicalOperatorTag.AGGREGATE)) {
                return null;
            }
            AggregateOperator aggOp = (AggregateOperator)r0.getValue();
            boolean serializable = aggOp.getExpressions().stream().allMatch(exprRef -> ((ILogicalExpression)exprRef.getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && BuiltinFunctions.isAggregateFunctionSerializable((FunctionIdentifier)((AbstractFunctionCallExpression)exprRef.getValue()).getFunctionIdentifier()));
            if (!serializable) {
                return null;
            }
            IMergeAggregationExpressionFactory mergeAggregationExpressionFactory = this.context.getMergeAggregationExpressionFactory();
            List originalVariables = aggOp.getVariables();
            List aggExprs = aggOp.getExpressions();
            int aggNum = aggExprs.size();
            for (int i = 0; i < aggNum; ++i) {
                AbstractFunctionCallExpression expr = (AbstractFunctionCallExpression)((Mutable)aggExprs.get(i)).getValue();
                AggregateFunctionCallExpression serialAggExpr = BuiltinFunctions.makeSerializableAggregateFunctionExpression((FunctionIdentifier)expr.getFunctionIdentifier(), (List)expr.getArguments());
                serialAggExpr.setSourceLocation(expr.getSourceLocation());
                if (mergeAggregationExpressionFactory.createMergeAggregation((LogicalVariable)originalVariables.get(i), (ILogicalExpression)serialAggExpr, this.context) != null) continue;
                return null;
            }
            AggregateOperator r1Logical = aggOp;
            while (r1Logical.hasInputs()) {
                if ((r1Logical = (ILogicalOperator)((Mutable)r1Logical.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.AGGREGATE) continue;
                return null;
            }
            for (int i = 0; i < aggNum; ++i) {
                AbstractFunctionCallExpression expr = (AbstractFunctionCallExpression)((Mutable)aggExprs.get(i)).getValue();
                AggregateFunctionCallExpression serialAggExpr = BuiltinFunctions.makeSerializableAggregateFunctionExpression((FunctionIdentifier)expr.getFunctionIdentifier(), (List)expr.getArguments());
                serialAggExpr.setSourceLocation(expr.getSourceLocation());
                ((Mutable)aggOp.getExpressions().get(i)).setValue((Object)serialAggExpr);
            }
            this.generateMergeAggregationExpressions(gby);
            return new ExternalGroupByPOperator(gby.getGroupByVarList());
        }

        private void generateMergeAggregationExpressions(GroupByOperator gby) throws AlgebricksException {
            if (gby.getNestedPlans().size() != 1) {
                throw new CompilationException(1079, gby.getSourceLocation(), new Serializable[]{"External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source."});
            }
            ILogicalPlan p0 = (ILogicalPlan)gby.getNestedPlans().get(0);
            if (p0.getRoots().size() != 1) {
                throw new CompilationException(1079, gby.getSourceLocation(), new Serializable[]{"External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source."});
            }
            IMergeAggregationExpressionFactory mergeAggregationExpressionFactory = this.context.getMergeAggregationExpressionFactory();
            Mutable r0 = (Mutable)p0.getRoots().get(0);
            AbstractLogicalOperator r0Logical = (AbstractLogicalOperator)r0.getValue();
            if (r0Logical.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
                throw new CompilationException(1079, gby.getSourceLocation(), new Serializable[]{"The merge aggregation expression generation should not process a " + r0Logical.getOperatorTag() + " operator."});
            }
            AggregateOperator aggOp = (AggregateOperator)r0.getValue();
            List aggFuncRefs = aggOp.getExpressions();
            List aggProducedVars = aggOp.getVariables();
            int n = aggOp.getExpressions().size();
            ArrayList<MutableObject> mergeExpressionRefs = new ArrayList<MutableObject>();
            for (int i = 0; i < n; ++i) {
                ILogicalExpression aggFuncExpr = (ILogicalExpression)((Mutable)aggFuncRefs.get(i)).getValue();
                ILogicalExpression mergeExpr = mergeAggregationExpressionFactory.createMergeAggregation((LogicalVariable)aggProducedVars.get(i), aggFuncExpr, this.context);
                if (mergeExpr == null) {
                    throw new CompilationException(1079, aggFuncExpr.getSourceLocation(), new Serializable[]{"The aggregation function " + ((AbstractFunctionCallExpression)aggFuncExpr).getFunctionIdentifier().getName() + " does not have a registered intermediate aggregation function."});
                }
                mergeExpressionRefs.add(new MutableObject((Object)mergeExpr));
            }
            aggOp.setMergeExpressions(mergeExpressionRefs);
        }

        public IPhysicalOperator visitUnnestMapOperator(UnnestMapOperator op, Boolean topLevelOp) throws AlgebricksException {
            return this.visitAbstractUnnestMapOperator((AbstractUnnestMapOperator)op);
        }

        public IPhysicalOperator visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Boolean topLevelOp) throws AlgebricksException {
            return this.visitAbstractUnnestMapOperator((AbstractUnnestMapOperator)op);
        }

        private IPhysicalOperator visitAbstractUnnestMapOperator(AbstractUnnestMapOperator op) throws AlgebricksException {
            ILogicalExpression unnestExpr = (ILogicalExpression)op.getExpressionRef().getValue();
            if (unnestExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                throw new CompilationException(1038, op.getSourceLocation(), new Serializable[0]);
            }
            AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)unnestExpr;
            if (!f.getFunctionIdentifier().equals((Object)BuiltinFunctions.INDEX_SEARCH)) {
                throw new CompilationException(1038, op.getSourceLocation(), new Serializable[0]);
            }
            AccessMethodJobGenParams jobGenParams = new AccessMethodJobGenParams();
            jobGenParams.readFromFuncArgs(f.getArguments());
            MetadataProvider mp = (MetadataProvider)this.context.getMetadataProvider();
            DataSourceId dataSourceId = new DataSourceId(jobGenParams.getDataverseName(), jobGenParams.getDatasetName());
            Dataset dataset = mp.findDataset(jobGenParams.getDataverseName(), jobGenParams.getDatasetName());
            IDataSourceIndex dsi = mp.findDataSourceIndex(jobGenParams.getIndexName(), dataSourceId);
            INodeDomain storageDomain = mp.findNodeDomain(dataset.getNodeGroupName());
            if (dsi == null) {
                throw new CompilationException(1079, op.getSourceLocation(), new Serializable[]{"Could not find index " + jobGenParams.getIndexName() + " for dataset " + dataSourceId});
            }
            DatasetConfig.IndexType indexType = jobGenParams.getIndexType();
            boolean requiresBroadcast = jobGenParams.getRequiresBroadcast();
            switch (indexType) {
                case BTREE: {
                    BTreeJobGenParams btreeJobGenParams = new BTreeJobGenParams();
                    btreeJobGenParams.readFromFuncArgs(f.getArguments());
                    return new BTreeSearchPOperator((IDataSourceIndex<String, DataSourceId>)dsi, storageDomain, requiresBroadcast, btreeJobGenParams.isPrimaryIndex(), btreeJobGenParams.isEqCondition(), btreeJobGenParams.getLowKeyVarList(), btreeJobGenParams.getHighKeyVarList());
                }
                case RTREE: {
                    return new RTreeSearchPOperator((IDataSourceIndex<String, DataSourceId>)dsi, storageDomain, requiresBroadcast);
                }
                case SINGLE_PARTITION_WORD_INVIX: 
                case SINGLE_PARTITION_NGRAM_INVIX: {
                    return new InvertedIndexPOperator((IDataSourceIndex<String, DataSourceId>)dsi, storageDomain, requiresBroadcast, false);
                }
                case LENGTH_PARTITIONED_WORD_INVIX: 
                case LENGTH_PARTITIONED_NGRAM_INVIX: {
                    return new InvertedIndexPOperator((IDataSourceIndex<String, DataSourceId>)dsi, storageDomain, requiresBroadcast, true);
                }
            }
            throw AlgebricksException.create((int)10005, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag().toString() + " with " + indexType + " index"});
        }

        public AbstractWindowPOperator createWindowPOperator(WindowOperator winOp) throws AlgebricksException {
            if (winOp.hasNestedPlans()) {
                boolean frameStartIsMonotonic = AnalysisUtil.isWindowFrameBoundaryMonotonic(winOp.getFrameStartExpressions(), winOp.getFrameValueExpressions());
                boolean frameEndIsMonotonic = AnalysisUtil.isWindowFrameBoundaryMonotonic(winOp.getFrameEndExpressions(), winOp.getFrameValueExpressions());
                boolean nestedTrivialAggregates = winOp.getNestedPlans().stream().allMatch(AnalysisUtil::isTrivialAggregateSubplan);
                return new WindowPOperator(winOp.getPartitionVarList(), winOp.getOrderColumnList(), frameStartIsMonotonic, frameEndIsMonotonic, nestedTrivialAggregates);
            }
            if (AnalysisUtil.hasFunctionWithProperty(winOp, BuiltinFunctions.WindowFunctionProperty.MATERIALIZE_PARTITION)) {
                return new WindowPOperator(winOp.getPartitionVarList(), winOp.getOrderColumnList(), false, false, false);
            }
            return new WindowStreamPOperator(winOp.getPartitionVarList(), winOp.getOrderColumnList());
        }
    }
}

