/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.base.AsterixOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.rewriter.rules.SetMemoryRequirementsRule;

public final class SetAsterixMemoryRequirementsRule
extends SetMemoryRequirementsRule {
    protected ILogicalOperatorVisitor<Void, Void> createMemoryRequirementsConfigurator(IOptimizationContext context) {
        return this.forceMinMemoryBudget((AsterixOptimizationContext)context) ? null : super.createMemoryRequirementsConfigurator(context);
    }

    private boolean forceMinMemoryBudget(AsterixOptimizationContext context) {
        Int2ObjectMap<Set<DataSourceId>> dataSourceMap = context.getDataSourceMap();
        if (dataSourceMap.isEmpty()) {
            return false;
        }
        for (Int2ObjectMap.Entry me : dataSourceMap.int2ObjectEntrySet()) {
            Predicate<DataSourceId> dataSourceTest;
            int dataSourceType = me.getIntKey();
            switch (dataSourceType) {
                case 0: {
                    dataSourceTest = SetAsterixMemoryRequirementsRule::isMinMemoryBudgetDataset;
                    break;
                }
                case 4: {
                    dataSourceTest = SetAsterixMemoryRequirementsRule::isMinMemoryBudgetFunction;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (((Set)me.getValue()).stream().allMatch(dataSourceTest)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMinMemoryBudgetDataset(DataSourceId dsId) {
        return MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)dsId.getDataverseName());
    }

    private static boolean isMinMemoryBudgetFunction(DataSourceId dsId) {
        return BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)FunctionSignature.createFunctionIdentifier((DataverseName)dsId.getDataverseName(), (String)dsId.getDatasourceName()), (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.DataSourceFunctionProperty.MIN_MEMORY_BUDGET);
    }
}

