/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RunningAggregatePOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPropertiesComputer;
import org.apache.hyracks.algebricks.core.algebra.properties.UnpartitionedPropertyComputer;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PullPositionalVariableFromUnnestRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnest = (UnnestOperator)op;
        LogicalVariable p = unnest.getPositionalVariable();
        if (p == null) {
            return false;
        }
        ArrayList<LogicalVariable> rOpVars = new ArrayList<LogicalVariable>();
        rOpVars.add(p);
        ArrayList<MutableObject> rOpExprList = new ArrayList<MutableObject>();
        StatefulFunctionCallExpression fce = new StatefulFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.TID), (IPropertiesComputer)UnpartitionedPropertyComputer.INSTANCE);
        fce.setSourceLocation(op.getSourceLocation());
        rOpExprList.add(new MutableObject((Object)fce));
        RunningAggregateOperator rOp = new RunningAggregateOperator(rOpVars, rOpExprList);
        rOp.setSourceLocation(unnest.getSourceLocation());
        rOp.setExecutionMode(unnest.getExecutionMode());
        RunningAggregatePOperator rPop = new RunningAggregatePOperator();
        rOp.setPhysicalOperator((IPhysicalOperator)rPop);
        rOp.getInputs().add(new MutableObject((Object)unnest));
        opRef.setValue((Object)rOp);
        unnest.setPositionalVariable(null);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)rOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unnest);
        return true;
    }
}

