/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ListifyUnnestingFunctionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.UNNEST || op.getOperatorTag() == LogicalOperatorTag.LEFT_OUTER_UNNEST || op.getInputs().size() > 1) {
            return false;
        }
        return op.acceptExpressionTransform(exprRef -> this.rewriteExpressionReference(op, (Mutable<ILogicalExpression>)exprRef, context));
    }

    private boolean rewriteExpressionReference(ILogicalOperator op, Mutable<ILogicalExpression> exprRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        boolean changed = false;
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        for (Mutable funcArgRef : funcExpr.getArguments()) {
            changed = changed || this.rewriteExpressionReference(op, (Mutable<ILogicalExpression>)funcArgRef, context);
        }
        return changed || this.listifyUnnestingFunction(op, exprRef, funcExpr, context);
    }

    private boolean listifyUnnestingFunction(ILogicalOperator op, Mutable<ILogicalExpression> exprRef, AbstractFunctionCallExpression func, IOptimizationContext context) throws AlgebricksException {
        IFunctionInfo functionInfo = func.getFunctionInfo();
        if (!BuiltinFunctions.isBuiltinUnnestingFunction((FunctionIdentifier)functionInfo.getFunctionIdentifier())) {
            return false;
        }
        SourceLocation sourceLoc = func.getSourceLocation();
        SubplanOperator subplanOperator = new SubplanOperator();
        subplanOperator.setSourceLocation(sourceLoc);
        NestedTupleSourceOperator ntsOperator = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)subplanOperator));
        ntsOperator.setSourceLocation(sourceLoc);
        LogicalVariable unnestVar = context.newVar();
        UnnestingFunctionCallExpression unnestExpr = new UnnestingFunctionCallExpression(functionInfo, func.getArguments());
        unnestExpr.setSourceLocation(sourceLoc);
        UnnestOperator unnestOperator = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)unnestExpr));
        unnestOperator.setSourceLocation(sourceLoc);
        unnestOperator.getInputs().add(new MutableObject((Object)ntsOperator));
        LogicalVariable aggVar = context.newVar();
        VariableReferenceExpression unnestVarRef = new VariableReferenceExpression(unnestVar);
        unnestVarRef.setSourceLocation(sourceLoc);
        MutableObject aggArgExprRef = new MutableObject((Object)unnestVarRef);
        AggregateFunctionCallExpression aggExpr = new AggregateFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.LISTIFY), false, new ArrayList<MutableObject>(Collections.singletonList(aggArgExprRef)));
        aggExpr.setSourceLocation(sourceLoc);
        AggregateOperator aggregateOperator = new AggregateOperator(new ArrayList<LogicalVariable>(Collections.singletonList(aggVar)), new ArrayList<MutableObject>(Collections.singletonList(new MutableObject((Object)aggExpr))));
        aggregateOperator.setSourceLocation(sourceLoc);
        aggregateOperator.getInputs().add(new MutableObject((Object)unnestOperator));
        subplanOperator.setRootOp((Mutable)new MutableObject((Object)aggregateOperator));
        subplanOperator.getInputs().add(op.getInputs().get(0));
        op.getInputs().set(0, new MutableObject((Object)subplanOperator));
        VariableReferenceExpression aggVarRef = new VariableReferenceExpression(aggVar);
        aggVarRef.setSourceLocation(sourceLoc);
        exprRef.setValue((Object)aggVarRef);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)ntsOperator);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unnestOperator);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)aggregateOperator);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)subplanOperator);
        context.computeAndSetTypeEnvironmentForOperator(op);
        return true;
    }
}

