/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.asterix.aqlplus.parser.AQLPlusParser;
import org.apache.asterix.aqlplus.parser.ParseException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.base.FuzzyUtils;
import org.apache.asterix.translator.AqlPlusExpressionToPlanTranslator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IndexedNLJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalOperatorDeepCopyWithNewVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class FuzzyJoinRule
implements IAlgebraicRewriteRule {
    private static HashSet<FunctionIdentifier> simFuncs = new HashSet();
    private final List<Collection<LogicalVariable>> previousPKs = new ArrayList<Collection<LogicalVariable>>();
    private static final int SUBSET_RIGHT_INDEX = 1;
    private static final int LENGTH_RIGHT_INDEX = 3;
    private static final String AQLPLUS = "((##LEFT_0),   (join((##RIGHT_0),     (join( ( ##RIGHT_1       let $tokensUnrankedRight := %s($$RIGHT_1)     let $lenRight := len($tokensUnrankedRight)       let $tokensRight :=     for $token in $tokensUnrankedRight for $tokenRanked at $i in           ##RIGHT_3 let $id := $$RIGHTPK_3_0 for $token in %s($$RIGHT_3)           /*+ hash */ group by $tokenGroupped := $token with $id           order by count($id), $tokenGroupped return $tokenGroupped         where $token = /*+ hash-bcast */ $tokenRanked order by $i return $i       for $prefixTokenRight in subset-collection($tokensRight, 0, prefix-len-%s(len($tokensRight), %ff))       ), ( ##LEFT_1 let $tokensUnrankedLeft := %s($$LEFT_1)       let $lenLeft := len($tokensUnrankedLeft) let $tokensLeft :=         for $token in $tokensUnrankedLeft for $tokenRanked at $i in           ##RIGHT_2 let $id := $$RIGHTPK_2_0 for $token in %s($$RIGHT_2)           /*+ hash */ group by $tokenGroupped := $token with $id           order by count($id), $tokenGroupped return $tokenGroupped         where $token = /*+ hash-bcast */ $tokenRanked order by $i return $i       let $actualPreLen := prefix-len-%s(len($tokensUnrankedLeft), %ff) - $lenLeft + len($tokensLeft)       for $prefixTokenLeft in subset-collection($tokensLeft, 0, $actualPreLen))       , $prefixTokenLeft = $prefixTokenRight) let $sim := similarity-%s-prefix($lenRight, $tokensRight, $lenLeft, $tokensLeft, $prefixTokenLeft, %ff) where $sim >= %ff /*+ hash*/ group by %s, %s with $sim     ), %s)),  %s)";
    private static final String GROUPBY_LEFT = "$idLeft_%d := $$LEFTPK_1_%d";
    private static final String GROUPBY_RIGHT = "$idRight_%d := $$RIGHTPK_1_%d";
    private static final String JOIN_COND_LEFT = "$$LEFTPK_0_%d = $idLeft_%d";
    private static final String JOIN_COND_RIGHT = "$$RIGHTPK_0_%d = $idRight_%d";
    private static final String AQLPLUS_INNER_JOIN = "join";
    private static final String AQLPLUS_LEFTOUTER_JOIN = "loj";

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable rightInputVar;
        LogicalVariable leftInputVar;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN && op.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)op;
        Mutable exprRef = joinOp.getCondition();
        Mutable<ILogicalExpression> getItemExprRef = this.getSimilarityExpression((Mutable<ILogicalExpression>)exprRef);
        if (getItemExprRef == null) {
            return false;
        }
        AbstractFunctionCallExpression getItemFuncExpr = (AbstractFunctionCallExpression)getItemExprRef.getValue();
        Mutable argRef = (Mutable)getItemFuncExpr.getArguments().get(0);
        AbstractFunctionCallExpression simFuncExpr = (AbstractFunctionCallExpression)argRef.getValue();
        if (!simFuncs.contains(simFuncExpr.getFunctionIdentifier())) {
            return false;
        }
        if (simFuncExpr.getAnnotations().containsKey(IndexedNLJoinExpressionAnnotation.INSTANCE)) {
            return false;
        }
        List inputOps = joinOp.getInputs();
        ILogicalOperator leftInputOp = (ILogicalOperator)((Mutable)inputOps.get(0)).getValue();
        ILogicalOperator rightInputOp = (ILogicalOperator)((Mutable)inputOps.get(1)).getValue();
        List inputExprs = simFuncExpr.getArguments();
        if (inputExprs.size() != 3) {
            return false;
        }
        ILogicalExpression leftOperatingExpr = (ILogicalExpression)((Mutable)inputExprs.get(0)).getValue();
        ILogicalExpression rightOperatingExpr = (ILogicalExpression)((Mutable)inputExprs.get(1)).getValue();
        ILogicalExpression thresholdConstantExpr = (ILogicalExpression)((Mutable)inputExprs.get(2)).getValue();
        if (leftOperatingExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE || rightOperatingExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE || thresholdConstantExpr.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return false;
        }
        LogicalVariable inputVar0 = ((VariableReferenceExpression)leftOperatingExpr).getVariableReference();
        LogicalVariable inputVar1 = ((VariableReferenceExpression)rightOperatingExpr).getVariableReference();
        HashSet<LogicalVariable> liveVars = new HashSet<LogicalVariable>();
        VariableUtilities.getLiveVariables((ILogicalOperator)leftInputOp, liveVars);
        if (liveVars.contains(inputVar0)) {
            leftInputVar = inputVar0;
            rightInputVar = inputVar1;
        } else {
            leftInputVar = inputVar1;
            rightInputVar = inputVar0;
        }
        List<LogicalVariable> leftInputPKs = this.findPrimaryKeysInSubplan(liveVars, context);
        liveVars.clear();
        VariableUtilities.getLiveVariables((ILogicalOperator)rightInputOp, liveVars);
        List<LogicalVariable> rightInputPKs = this.findPrimaryKeysInSubplan(liveVars, context);
        IAType leftType = (IAType)context.getOutputTypeEnvironment(leftInputOp).getVarType(leftInputVar);
        if (!this.isPrefixFuzzyJoin(context, leftInputOp, rightInputOp, rightInputVar, leftInputPKs, rightInputPKs, leftType)) {
            return false;
        }
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        String aqlPlus = this.generateAqlTemplate(metadataProvider, joinOp, simFuncExpr, leftInputPKs, leftType, rightInputPKs, thresholdConstantExpr);
        ILogicalOperator outputOp = this.generatePrefixFuzzyJoinSubplan(context, metadataProvider, aqlPlus, leftInputOp, leftInputPKs, leftInputVar, rightInputOp, rightInputPKs, rightInputVar);
        if (getItemExprRef != exprRef) {
            getItemExprRef.setValue((Object)ConstantExpression.TRUE);
            switch (joinOp.getJoinKind()) {
                case INNER: {
                    SelectOperator extraSelect = new SelectOperator(exprRef, false, null);
                    extraSelect.setSourceLocation(((ILogicalExpression)exprRef.getValue()).getSourceLocation());
                    extraSelect.getInputs().add(new MutableObject((Object)outputOp));
                    outputOp = extraSelect;
                    break;
                }
                case LEFT_OUTER: {
                    LeftOuterJoinOperator topJoin = (LeftOuterJoinOperator)outputOp;
                    this.setConditionForLeftOuterJoin(topJoin, (Mutable<ILogicalExpression>)exprRef);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        opRef.setValue((Object)outputOp);
        OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        return true;
    }

    private boolean isPrefixFuzzyJoin(IOptimizationContext context, ILogicalOperator leftInputOp, ILogicalOperator rightInputOp, LogicalVariable rightInputVar, List<LogicalVariable> leftInputPKs, List<LogicalVariable> rightInputPKs, IAType leftType) throws AlgebricksException {
        IAType actualRightType;
        HashSet<LogicalVariable> currentPKs = new HashSet<LogicalVariable>();
        currentPKs.addAll(leftInputPKs);
        currentPKs.addAll(rightInputPKs);
        for (int i = 0; i < this.previousPKs.size(); ++i) {
            if (!this.previousPKs.get(i).containsAll(currentPKs) || !currentPKs.containsAll(this.previousPKs.get(i))) continue;
            return false;
        }
        this.previousPKs.add(currentPKs);
        IsomorphismUtilities.mergeHomogeneousPK((ILogicalOperator)leftInputOp, leftInputPKs);
        if (leftInputPKs.isEmpty() || rightInputPKs.isEmpty()) {
            return false;
        }
        IAType rightType = (IAType)context.getOutputTypeEnvironment(rightInputOp).getVarType(rightInputVar);
        IAType actualLeftType = TypeComputeUtils.getActualType((IAType)leftType);
        return actualLeftType.deepEqual((IAObject)(actualRightType = TypeComputeUtils.getActualType((IAType)rightType)));
    }

    private String generateAqlTemplate(MetadataProvider metadataProvider, AbstractBinaryJoinOperator joinOp, AbstractFunctionCallExpression simFuncExpr, List<LogicalVariable> leftInputPKs, IAType leftType, List<LogicalVariable> rightInputPKs, ILogicalExpression thresholdConstantExpr) throws AlgebricksException {
        String prepareJoin;
        FunctionIdentifier funcId = FuzzyUtils.getTokenizer(leftType.getTypeTag());
        String tokenizer = "";
        if (funcId != null) {
            tokenizer = funcId.getName();
        }
        String simFunction = FuzzyUtils.getSimFunction(simFuncExpr.getFunctionIdentifier());
        ConstantExpression constExpr = (ConstantExpression)thresholdConstantExpr;
        AsterixConstantValue constVal = (AsterixConstantValue)constExpr.getValue();
        float simThreshold = constVal.getObject().getType().equals(BuiltinType.AFLOAT) ? ((AFloat)constVal.getObject()).getFloatValue() : FuzzyUtils.getSimThreshold(metadataProvider);
        switch (joinOp.getJoinKind()) {
            case INNER: {
                prepareJoin = "join((##LEFT_0),   (join((##RIGHT_0),     (join( ( ##RIGHT_1       let $tokensUnrankedRight := %s($$RIGHT_1)     let $lenRight := len($tokensUnrankedRight)       let $tokensRight :=     for $token in $tokensUnrankedRight for $tokenRanked at $i in           ##RIGHT_3 let $id := $$RIGHTPK_3_0 for $token in %s($$RIGHT_3)           /*+ hash */ group by $tokenGroupped := $token with $id           order by count($id), $tokenGroupped return $tokenGroupped         where $token = /*+ hash-bcast */ $tokenRanked order by $i return $i       for $prefixTokenRight in subset-collection($tokensRight, 0, prefix-len-%s(len($tokensRight), %ff))       ), ( ##LEFT_1 let $tokensUnrankedLeft := %s($$LEFT_1)       let $lenLeft := len($tokensUnrankedLeft) let $tokensLeft :=         for $token in $tokensUnrankedLeft for $tokenRanked at $i in           ##RIGHT_2 let $id := $$RIGHTPK_2_0 for $token in %s($$RIGHT_2)           /*+ hash */ group by $tokenGroupped := $token with $id           order by count($id), $tokenGroupped return $tokenGroupped         where $token = /*+ hash-bcast */ $tokenRanked order by $i return $i       let $actualPreLen := prefix-len-%s(len($tokensUnrankedLeft), %ff) - $lenLeft + len($tokensLeft)       for $prefixTokenLeft in subset-collection($tokensLeft, 0, $actualPreLen))       , $prefixTokenLeft = $prefixTokenRight) let $sim := similarity-%s-prefix($lenRight, $tokensRight, $lenLeft, $tokensLeft, $prefixTokenLeft, %ff) where $sim >= %ff /*+ hash*/ group by %s, %s with $sim     ), %s)),  %s)";
                break;
            }
            case LEFT_OUTER: {
                prepareJoin = "loj((##LEFT_0),   (join((##RIGHT_0),     (join( ( ##RIGHT_1       let $tokensUnrankedRight := %s($$RIGHT_1)     let $lenRight := len($tokensUnrankedRight)       let $tokensRight :=     for $token in $tokensUnrankedRight for $tokenRanked at $i in           ##RIGHT_3 let $id := $$RIGHTPK_3_0 for $token in %s($$RIGHT_3)           /*+ hash */ group by $tokenGroupped := $token with $id           order by count($id), $tokenGroupped return $tokenGroupped         where $token = /*+ hash-bcast */ $tokenRanked order by $i return $i       for $prefixTokenRight in subset-collection($tokensRight, 0, prefix-len-%s(len($tokensRight), %ff))       ), ( ##LEFT_1 let $tokensUnrankedLeft := %s($$LEFT_1)       let $lenLeft := len($tokensUnrankedLeft) let $tokensLeft :=         for $token in $tokensUnrankedLeft for $tokenRanked at $i in           ##RIGHT_2 let $id := $$RIGHTPK_2_0 for $token in %s($$RIGHT_2)           /*+ hash */ group by $tokenGroupped := $token with $id           order by count($id), $tokenGroupped return $tokenGroupped         where $token = /*+ hash-bcast */ $tokenRanked order by $i return $i       let $actualPreLen := prefix-len-%s(len($tokensUnrankedLeft), %ff) - $lenLeft + len($tokensLeft)       for $prefixTokenLeft in subset-collection($tokensLeft, 0, $actualPreLen))       , $prefixTokenLeft = $prefixTokenRight) let $sim := similarity-%s-prefix($lenRight, $tokensRight, $lenLeft, $tokensLeft, $prefixTokenLeft, %ff) where $sim >= %ff /*+ hash*/ group by %s, %s with $sim     ), %s)),  %s)";
                break;
            }
            default: {
                throw new CompilationException(1007, new Serializable[0]);
            }
        }
        String groupByLeft = "";
        String joinCondLeft = "";
        for (int i = 0; i < leftInputPKs.size(); ++i) {
            if (i > 0) {
                groupByLeft = groupByLeft + ", ";
                joinCondLeft = joinCondLeft + " and ";
            }
            groupByLeft = groupByLeft + String.format(Locale.US, GROUPBY_LEFT, i, i);
            joinCondLeft = joinCondLeft + String.format(Locale.US, JOIN_COND_LEFT, i, i);
        }
        String groupByRight = "";
        String joinCondRight = "";
        for (int i = 0; i < rightInputPKs.size(); ++i) {
            if (i > 0) {
                groupByRight = groupByRight + ", ";
                joinCondRight = joinCondRight + " and ";
            }
            groupByRight = groupByRight + String.format(Locale.US, GROUPBY_RIGHT, i, i);
            joinCondRight = joinCondRight + String.format(Locale.US, JOIN_COND_RIGHT, i, i);
        }
        return String.format(Locale.US, prepareJoin, tokenizer, tokenizer, simFunction, Float.valueOf(simThreshold), tokenizer, tokenizer, simFunction, Float.valueOf(simThreshold), simFunction, Float.valueOf(simThreshold), Float.valueOf(simThreshold), groupByLeft, groupByRight, joinCondRight, joinCondLeft);
    }

    private ILogicalOperator generatePrefixFuzzyJoinSubplan(IOptimizationContext context, MetadataProvider metadataProvider, String aqlPlus, ILogicalOperator leftInputOp, List<LogicalVariable> leftInputPKs, LogicalVariable leftInputVar, ILogicalOperator rightInputOp, List<LogicalVariable> rightInputPKs, LogicalVariable rightInputVar) throws AlgebricksException {
        ILogicalPlan plan;
        List<Clause> clauses;
        int i;
        int i2;
        Counter counter = new Counter(context.getVarCounter());
        AqlPlusExpressionToPlanTranslator translator = new AqlPlusExpressionToPlanTranslator(metadataProvider, counter);
        LogicalOperatorDeepCopyWithNewVariablesVisitor copyVisitor = new LogicalOperatorDeepCopyWithNewVariablesVisitor((IVariableContext)context, (ITypingContext)context);
        translator.addOperatorToMetaScope((Identifier)new VarIdentifier("##LEFT_0"), leftInputOp);
        translator.addVariableToMetaScope((Identifier)new VarIdentifier("$$LEFT_0"), leftInputVar);
        for (i2 = 0; i2 < leftInputPKs.size(); ++i2) {
            translator.addVariableToMetaScope((Identifier)new VarIdentifier("$$LEFTPK_0_" + i2), leftInputPKs.get(i2));
        }
        translator.addOperatorToMetaScope((Identifier)new VarIdentifier("##RIGHT_0"), rightInputOp);
        translator.addVariableToMetaScope((Identifier)new VarIdentifier("$$RIGHT_0"), rightInputVar);
        for (i2 = 0; i2 < rightInputPKs.size(); ++i2) {
            translator.addVariableToMetaScope((Identifier)new VarIdentifier("$$RIGHTPK_0_" + i2), rightInputPKs.get(i2));
        }
        ILogicalOperator leftInputOpCopy = copyVisitor.deepCopy(leftInputOp);
        translator.addOperatorToMetaScope((Identifier)new VarIdentifier("##LEFT_1"), leftInputOpCopy);
        LogicalVariable leftInputVarCopy = copyVisitor.varCopy(leftInputVar);
        translator.addVariableToMetaScope((Identifier)new VarIdentifier("$$LEFT_1"), leftInputVarCopy);
        for (i = 0; i < leftInputPKs.size(); ++i) {
            leftInputVarCopy = copyVisitor.varCopy(leftInputPKs.get(i));
            translator.addVariableToMetaScope((Identifier)new VarIdentifier("$$LEFTPK_1_" + i), leftInputVarCopy);
        }
        copyVisitor.updatePrimaryKeys(context);
        copyVisitor.reset();
        for (i = 1; i <= 3; ++i) {
            translator.addOperatorToMetaScope((Identifier)new VarIdentifier("##RIGHT_" + i), copyVisitor.deepCopy(rightInputOp));
            LogicalVariable rightInputVarCopy = copyVisitor.varCopy(rightInputVar);
            translator.addVariableToMetaScope((Identifier)new VarIdentifier("$$RIGHT_" + i), rightInputVarCopy);
            for (int j = 0; j < rightInputPKs.size(); ++j) {
                rightInputVarCopy = copyVisitor.varCopy(rightInputPKs.get(j));
                translator.addVariableToMetaScope((Identifier)new VarIdentifier("$$RIGHTPK_" + i + "_" + j), rightInputVarCopy);
            }
            copyVisitor.updatePrimaryKeys(context);
            copyVisitor.reset();
        }
        counter.set(context.getVarCounter());
        AQLPlusParser parser = new AQLPlusParser(new StringReader(aqlPlus));
        parser.initScope();
        parser.setVarCounter(counter);
        try {
            clauses = parser.Clauses();
        }
        catch (ParseException e) {
            throw CompilationException.create((int)1093, (Serializable[])new Serializable[]{e});
        }
        try {
            plan = translator.translate(clauses);
        }
        catch (CompilationException e) {
            throw CompilationException.create((int)1093, (Serializable[])new Serializable[]{e});
        }
        context.setVarCounter(counter.get());
        return (ILogicalOperator)((Mutable)plan.getRoots().get(0)).getValue();
    }

    private void setConditionForLeftOuterJoin(LeftOuterJoinOperator topJoin, Mutable<ILogicalExpression> expRef) {
        ScalarFunctionCallExpression andFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
        ArrayList conjs = new ArrayList();
        if (((ILogicalExpression)topJoin.getCondition().getValue()).splitIntoConjuncts(conjs)) {
            andFunc.getArguments().addAll(conjs);
        } else {
            andFunc.getArguments().add(new MutableObject(topJoin.getCondition().getValue()));
        }
        ArrayList conjs2 = new ArrayList();
        if (((ILogicalExpression)expRef.getValue()).splitIntoConjuncts(conjs2)) {
            andFunc.getArguments().addAll(conjs2);
        } else {
            andFunc.getArguments().add(expRef);
        }
        topJoin.getCondition().setValue((Object)andFunc);
    }

    private Mutable<ILogicalExpression> getSimilarityExpression(Mutable<ILogicalExpression> exprRef) {
        ILogicalExpression exp = (ILogicalExpression)exprRef.getValue();
        if (exp.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)exp;
            if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.GET_ITEM)) {
                return exprRef;
            }
            if (funcExpr.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.AND)) {
                for (Mutable arg : funcExpr.getArguments()) {
                    Mutable<ILogicalExpression> expRefRet = this.getSimilarityExpression((Mutable<ILogicalExpression>)arg);
                    if (expRefRet == null) continue;
                    return expRefRet;
                }
            }
        }
        return null;
    }

    private List<LogicalVariable> findPrimaryKeysInSubplan(Collection<LogicalVariable> liveVars, IOptimizationContext context) {
        HashSet primaryKeys = new HashSet();
        for (LogicalVariable var : liveVars) {
            List pks = context.findPrimaryKey(var);
            if (pks == null) continue;
            primaryKeys.addAll(pks);
        }
        if (primaryKeys.isEmpty()) {
            return new ArrayList<LogicalVariable>();
        }
        return new ArrayList<LogicalVariable>(primaryKeys);
    }

    static {
        simFuncs.add(BuiltinFunctions.SIMILARITY_JACCARD_CHECK);
    }
}

