/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractAssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class FeedScanCollectionToUnnest
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        if (op.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
            return false;
        }
        UnnestOperator unnest = (UnnestOperator)op;
        ILogicalExpression unnestExpr = (ILogicalExpression)unnest.getExpressionRef().getValue();
        if (this.needsScanCollection(unnestExpr, (ILogicalOperator)op)) {
            UnnestingFunctionCallExpression newExpr = new UnnestingFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), new Mutable[]{new MutableObject((Object)unnestExpr)});
            newExpr.setSourceLocation(unnestExpr.getSourceLocation());
            unnest.getExpressionRef().setValue((Object)newExpr);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
            return true;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        return false;
    }

    private ILogicalExpression findVarOriginExpression(LogicalVariable v, ILogicalOperator op) throws AlgebricksException {
        boolean searchInputs = false;
        if (!(op instanceof AbstractAssignOperator)) {
            searchInputs = true;
        } else {
            AbstractAssignOperator aao = (AbstractAssignOperator)op;
            ArrayList producedVars = new ArrayList();
            VariableUtilities.getProducedVariables((ILogicalOperator)op, producedVars);
            int exprIndex = producedVars.indexOf(v);
            if (exprIndex == -1) {
                searchInputs = true;
            } else {
                ILogicalExpression originalCandidate = (ILogicalExpression)((Mutable)aao.getExpressions().get(exprIndex)).getValue();
                if (originalCandidate.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                    searchInputs = true;
                } else {
                    return originalCandidate;
                }
            }
        }
        if (searchInputs) {
            for (Mutable childOp : op.getInputs()) {
                ILogicalExpression ret = this.findVarOriginExpression(v, (ILogicalOperator)childOp.getValue());
                if (ret == null) continue;
                return ret;
            }
        }
        throw new IllegalStateException("Unable to find the original expression that produced variable " + v);
    }

    private boolean needsScanCollection(ILogicalExpression unnestExpr, ILogicalOperator op) throws AlgebricksException {
        switch (unnestExpr.getExpressionTag()) {
            case VARIABLE: {
                LogicalVariable v = ((VariableReferenceExpression)unnestExpr).getVariableReference();
                ILogicalExpression originalExpr = this.findVarOriginExpression(v, op);
                if (originalExpr.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                    return false;
                }
                return !this.isUnnestingFunction(originalExpr);
            }
            case FUNCTION_CALL: {
                return !this.isUnnestingFunction(unnestExpr);
            }
        }
        return false;
    }

    private boolean isUnnestingFunction(ILogicalExpression expr) {
        if (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
            return fce.getKind() == AbstractFunctionCallExpression.FunctionKind.UNNEST;
        }
        return false;
    }
}

