/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.base;

import java.util.ArrayList;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class FuzzyUtils {
    private static final String DEFAULT_SIM_FUNCTION = "jaccard";
    private static final float JACCARD_DEFAULT_SIM_THRESHOLD = 0.8f;
    private static final int EDIT_DISTANCE_DEFAULT_SIM_THRESHOLD = 1;
    public static final String SIM_FUNCTION_PROP_NAME = "simfunction";
    public static final String SIM_THRESHOLD_PROP_NAME = "simthreshold";
    public static final String JACCARD_FUNCTION_NAME = "jaccard";
    public static final String EDIT_DISTANCE_FUNCTION_NAME = "edit-distance";

    public static FunctionIdentifier getTokenizer(ATypeTag inputTag) {
        switch (inputTag) {
            case STRING: {
                return BuiltinFunctions.COUNTHASHED_WORD_TOKENS;
            }
            case MULTISET: 
            case ARRAY: 
            case UNION: 
            case ANY: {
                return null;
            }
        }
        throw new NotImplementedException("No tokenizer for type " + inputTag);
    }

    public static IAObject getSimThreshold(MetadataProvider metadata, String simFuncName) {
        String simThresholValue = (String)metadata.getProperty(SIM_THRESHOLD_PROP_NAME);
        AFloat ret = null;
        if (simFuncName.equals("jaccard")) {
            if (simThresholValue != null) {
                float jaccThresh = Float.parseFloat(simThresholValue);
                ret = new AFloat(jaccThresh);
            } else {
                ret = new AFloat(0.8f);
            }
        } else if (simFuncName.equals(EDIT_DISTANCE_FUNCTION_NAME)) {
            if (simThresholValue != null) {
                int edThresh = Integer.parseInt(simThresholValue);
                ret = new AInt32(edThresh);
            } else {
                ret = new AFloat(1.0f);
            }
        }
        return ret;
    }

    public static FunctionIdentifier getFunctionIdentifier(String simFuncName) {
        if (simFuncName.equals("jaccard")) {
            return BuiltinFunctions.SIMILARITY_JACCARD;
        }
        if (simFuncName.equals(EDIT_DISTANCE_FUNCTION_NAME)) {
            return BuiltinFunctions.EDIT_DISTANCE;
        }
        return null;
    }

    public static ScalarFunctionCallExpression getComparisonExpr(String simFuncName, ArrayList<Mutable<ILogicalExpression>> cmpArgs) {
        if (simFuncName.equals("jaccard")) {
            return new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.GE), cmpArgs);
        }
        if (simFuncName.equals(EDIT_DISTANCE_FUNCTION_NAME)) {
            return new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.LE), cmpArgs);
        }
        return null;
    }

    public static float getSimThreshold(MetadataProvider metadata) {
        float simThreshold = 0.8f;
        String simThresholValue = (String)metadata.getProperty(SIM_THRESHOLD_PROP_NAME);
        if (simThresholValue != null) {
            simThreshold = Float.parseFloat(simThresholValue);
        }
        return simThreshold;
    }

    public static String getSimFunction(MetadataProvider metadata) {
        String simFunction = (String)metadata.getProperty(SIM_FUNCTION_PROP_NAME);
        if (simFunction == null) {
            simFunction = "jaccard";
        }
        simFunction = simFunction.toLowerCase();
        return simFunction;
    }

    public static String getSimFunction(FunctionIdentifier simFuncId) {
        if (simFuncId.equals((Object)BuiltinFunctions.SIMILARITY_JACCARD) || simFuncId.equals((Object)BuiltinFunctions.SIMILARITY_JACCARD_CHECK)) {
            return "jaccard";
        }
        if (simFuncId.equals((Object)BuiltinFunctions.EDIT_DISTANCE) || simFuncId.equals((Object)BuiltinFunctions.EDIT_DISTANCE_CHECK)) {
            return EDIT_DISTANCE_FUNCTION_NAME;
        }
        return null;
    }
}

