/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.utils;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.asterix.common.api.ICoordinationService;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.api.INodeJobTracker;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.config.ActiveProperties;
import org.apache.asterix.common.config.BuildProperties;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.config.ExtensionProperties;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.config.NodeProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.config.TransactionProperties;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.IMetadataBootstrap;
import org.apache.asterix.common.replication.INcLifecycleCoordinator;
import org.apache.asterix.common.transactions.IResourceIdManager;
import org.apache.asterix.common.transactions.ITxnIdFactory;
import org.apache.asterix.runtime.job.listener.NodeJobTracker;
import org.apache.asterix.runtime.transaction.ResourceIdManager;
import org.apache.asterix.runtime.utils.BulkTxnIdFactory;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.asterix.runtime.utils.NoOpCoordinationService;
import org.apache.asterix.runtime.utils.RuntimeComponentsProvider;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.HyracksConnection;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IJobLifecycleListener;
import org.apache.hyracks.storage.common.IStorageManager;

public class CcApplicationContext
implements ICcApplicationContext {
    private ICCServiceContext ccServiceCtx;
    private IStorageComponentProvider storageComponentProvider;
    private IGlobalRecoveryManager globalRecoveryManager;
    private ILibraryManager libraryManager;
    private IResourceIdManager resourceIdManager;
    private CompilerProperties compilerProperties;
    private ExternalProperties externalProperties;
    private MetadataProperties metadataProperties;
    private StorageProperties storageProperties;
    private TransactionProperties txnProperties;
    private ActiveProperties activeProperties;
    private BuildProperties buildProperties;
    private ReplicationProperties replicationProperties;
    private ExtensionProperties extensionProperties;
    private MessagingProperties messagingProperties;
    private NodeProperties nodeProperties;
    private Supplier<IMetadataBootstrap> metadataBootstrapSupplier;
    private IHyracksClientConnection hcc;
    private Object extensionManager;
    private INcLifecycleCoordinator ftStrategy;
    private IJobLifecycleListener activeLifeCycleListener;
    private IMetadataLockManager mdLockManager;
    private IClusterStateManager clusterStateManager;
    private final INodeJobTracker nodeJobTracker;
    private final ITxnIdFactory txnIdFactory;

    public CcApplicationContext(ICCServiceContext ccServiceCtx, IHyracksClientConnection hcc, ILibraryManager libraryManager, Supplier<IMetadataBootstrap> metadataBootstrapSupplier, IGlobalRecoveryManager globalRecoveryManager, INcLifecycleCoordinator ftStrategy, IJobLifecycleListener activeLifeCycleListener, IStorageComponentProvider storageComponentProvider, IMetadataLockManager mdLockManager) throws AlgebricksException, IOException {
        this.ccServiceCtx = ccServiceCtx;
        this.hcc = hcc;
        this.libraryManager = libraryManager;
        this.activeLifeCycleListener = activeLifeCycleListener;
        PropertiesAccessor propertiesAccessor = PropertiesAccessor.getInstance((IApplicationConfig)ccServiceCtx.getAppConfig());
        this.compilerProperties = new CompilerProperties(propertiesAccessor);
        this.externalProperties = new ExternalProperties(propertiesAccessor);
        this.metadataProperties = new MetadataProperties(propertiesAccessor);
        this.storageProperties = new StorageProperties(propertiesAccessor);
        this.txnProperties = new TransactionProperties(propertiesAccessor);
        this.activeProperties = new ActiveProperties(propertiesAccessor);
        this.extensionProperties = new ExtensionProperties(propertiesAccessor);
        this.replicationProperties = new ReplicationProperties(propertiesAccessor);
        this.ftStrategy = ftStrategy;
        this.buildProperties = new BuildProperties(propertiesAccessor);
        this.messagingProperties = new MessagingProperties(propertiesAccessor);
        this.nodeProperties = new NodeProperties(propertiesAccessor);
        this.metadataBootstrapSupplier = metadataBootstrapSupplier;
        this.globalRecoveryManager = globalRecoveryManager;
        this.storageComponentProvider = storageComponentProvider;
        this.mdLockManager = mdLockManager;
        this.clusterStateManager = new ClusterStateManager();
        this.clusterStateManager.setCcAppCtx((ICcApplicationContext)this);
        this.resourceIdManager = new ResourceIdManager(this.clusterStateManager);
        this.nodeJobTracker = new NodeJobTracker();
        this.txnIdFactory = new BulkTxnIdFactory();
    }

    public ICCServiceContext getServiceContext() {
        return this.ccServiceCtx;
    }

    public StorageProperties getStorageProperties() {
        return this.storageProperties;
    }

    public TransactionProperties getTransactionProperties() {
        return this.txnProperties;
    }

    public CompilerProperties getCompilerProperties() {
        return this.compilerProperties;
    }

    public MetadataProperties getMetadataProperties() {
        return this.metadataProperties;
    }

    public ExternalProperties getExternalProperties() {
        return this.externalProperties;
    }

    public ActiveProperties getActiveProperties() {
        return this.activeProperties;
    }

    public BuildProperties getBuildProperties() {
        return this.buildProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHyracksClientConnection getHcc() throws HyracksDataException {
        if (!this.hcc.isConnected()) {
            CcApplicationContext ccApplicationContext = this;
            synchronized (ccApplicationContext) {
                if (!this.hcc.isConnected()) {
                    try {
                        this.hcc = new HyracksConnection(this.hcc.getHost(), this.hcc.getPort());
                    }
                    catch (Exception e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
            }
        }
        return this.hcc;
    }

    public IStorageManager getStorageManager() {
        return RuntimeComponentsProvider.RUNTIME_PROVIDER;
    }

    public ReplicationProperties getReplicationProperties() {
        return this.replicationProperties;
    }

    public IGlobalRecoveryManager getGlobalRecoveryManager() {
        return this.globalRecoveryManager;
    }

    public ILibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public Object getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(Object extensionManager) {
        this.extensionManager = extensionManager;
    }

    public ExtensionProperties getExtensionProperties() {
        return this.extensionProperties;
    }

    public MessagingProperties getMessagingProperties() {
        return this.messagingProperties;
    }

    public NodeProperties getNodeProperties() {
        return this.nodeProperties;
    }

    public IResourceIdManager getResourceIdManager() {
        return this.resourceIdManager;
    }

    public IMetadataBootstrap getMetadataBootstrap() {
        return this.metadataBootstrapSupplier.get();
    }

    public INcLifecycleCoordinator getNcLifecycleCoordinator() {
        return this.ftStrategy;
    }

    public IJobLifecycleListener getActiveNotificationHandler() {
        return this.activeLifeCycleListener;
    }

    public IStorageComponentProvider getStorageComponentProvider() {
        return this.storageComponentProvider;
    }

    public IMetadataLockManager getMetadataLockManager() {
        return this.mdLockManager;
    }

    public IClusterStateManager getClusterStateManager() {
        return this.clusterStateManager;
    }

    public INodeJobTracker getNodeJobTracker() {
        return this.nodeJobTracker;
    }

    public ICoordinationService getCoordinationService() {
        return NoOpCoordinationService.INSTANCE;
    }

    public ITxnIdFactory getTxnIdFactory() {
        return this.txnIdFactory;
    }
}

