/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.std;

import java.nio.ByteBuffer;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ILockManager;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.ImmutableDatasetId;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;

public class FlushDatasetOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final TxnId txnId;
    private final DatasetId datasetId;

    public FlushDatasetOperatorDescriptor(IOperatorDescriptorRegistry spec, TxnId txnId, int datasetId) {
        super(spec, 1, 0);
        this.txnId = txnId;
        this.datasetId = new ImmutableDatasetId(datasetId);
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        return new AbstractUnaryInputSinkOperatorNodePushable(){

            public void open() throws HyracksDataException {
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            }

            public void fail() throws HyracksDataException {
                this.close();
            }

            public void close() throws HyracksDataException {
                try {
                    INcApplicationContext appCtx = (INcApplicationContext)ctx.getJobletContext().getServiceContext().getApplicationContext();
                    IDatasetLifecycleManager datasetLifeCycleManager = appCtx.getDatasetLifecycleManager();
                    ILockManager lockManager = appCtx.getTransactionSubsystem().getLockManager();
                    ITransactionManager txnManager = appCtx.getTransactionSubsystem().getTransactionManager();
                    ITransactionContext txnCtx = txnManager.getTransactionContext(FlushDatasetOperatorDescriptor.this.txnId);
                    lockManager.lock(FlushDatasetOperatorDescriptor.this.datasetId, -1, (byte)3, txnCtx);
                    datasetLifeCycleManager.flushDataset(FlushDatasetOperatorDescriptor.this.datasetId.getId(), false);
                }
                catch (ACIDException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

