/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.base.temporal.DurationArithmeticOperations;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.temporal.OverlapBinsDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnderflowException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class OverlapBinsDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable argPtr0 = new VoidPointable();
    private final IPointable argPtr1 = new VoidPointable();
    private final IPointable argPtr2 = new VoidPointable();
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IScalarEvaluator eval2;
    private OrderedListBuilder listBuilder;
    private ArrayBackedValueStorage listStorage;
    protected final AOrderedListType intListType;
    private final AMutableInterval aInterval;
    private final ISerializerDeserializer<AInterval> intervalSerde;
    private final GregorianCalendarSystem gregCalSys;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ OverlapBinsDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    OverlapBinsDescriptor$_EvaluatorGen(OverlapBinsDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval0 = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.eval1 = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.eval2 = this.this$1.val$args[2].createScalarEvaluator(this.val$ctx);
        this.listBuilder = new OrderedListBuilder();
        this.listStorage = new ArrayBackedValueStorage();
        this.intListType = new AOrderedListType((IAType)BuiltinType.AINTERVAL, null);
        this.aInterval = new AMutableInterval(0L, 0L, -1);
        this.intervalSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINTERVAL);
        this.gregCalSys = GregorianCalendarSystem.getInstance();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        long firstBinIndex;
        long anchorTime;
        byte intervalTypeTag;
        long intervalEnd;
        long intervalStart;
        int offset0;
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.argPtr0);
        if (this.typeChecker.isMissing(this.argPtr0, result)) {
            return;
        }
        this.eval1.evaluate(tuple, this.argPtr1);
        if (this.typeChecker.isMissing(this.argPtr1, result)) {
            return;
        }
        this.eval2.evaluate(tuple, this.argPtr2);
        if (this.typeChecker.isMissing(this.argPtr2, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] bytes0 = this.argPtr0.getByteArray();
        ATypeTag type0 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0 = this.argPtr0.getStartOffset()]);
        if (type0 == ATypeTag.INTERVAL) {
            intervalStart = AIntervalSerializerDeserializer.getIntervalStart((byte[])bytes0, (int)(offset0 + 1));
            intervalEnd = AIntervalSerializerDeserializer.getIntervalEnd((byte[])bytes0, (int)(offset0 + 1));
            intervalTypeTag = AIntervalSerializerDeserializer.getIntervalTimeType((byte[])bytes0, (int)(offset0 + 1));
            if (intervalTypeTag == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                intervalStart *= 86400000L;
            }
        } else {
            throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)0, bytes0[offset0], ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
        }
        byte[] bytes1 = this.argPtr1.getByteArray();
        int offset1 = this.argPtr1.getStartOffset();
        ATypeTag type1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
        if (intervalTypeTag != bytes1[offset1]) {
            throw new IncompatibleTypeException(this.this$1.this$0.getIdentifier(), intervalTypeTag, bytes1[offset1]);
        }
        switch (type1) {
            case DATE: {
                anchorTime = (long)ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1)) * 86400000L;
                break;
            }
            case TIME: {
                anchorTime = ATimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                break;
            }
            case DATETIME: {
                anchorTime = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                break;
            }
            default: {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)1, bytes1[offset1], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
            }
        }
        byte[] bytes2 = this.argPtr2.getByteArray();
        int offset2 = this.argPtr2.getStartOffset();
        ATypeTag type2 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes2[offset2]);
        int yearMonth = 0;
        long dayTime = 0L;
        switch (type2) {
            case YEARMONTHDURATION: {
                yearMonth = AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes2, (int)(offset2 + 1));
                int yearStart = this.gregCalSys.getYear(anchorTime);
                int monthStart = this.gregCalSys.getMonthOfYear(anchorTime, yearStart);
                int yearToBin = this.gregCalSys.getYear(intervalStart);
                int monthToBin = this.gregCalSys.getMonthOfYear(intervalStart, yearToBin);
                int totalMonths = (yearToBin - yearStart) * 12 + (monthToBin - monthStart);
                firstBinIndex = totalMonths / yearMonth + (totalMonths < 0 && totalMonths % yearMonth != 0 ? -1 : 0);
                if (firstBinIndex > Integer.MAX_VALUE) {
                    throw new OverflowException(this.this$1.this$0.getIdentifier());
                }
                if (firstBinIndex >= Integer.MIN_VALUE) break;
                throw new UnderflowException(this.this$1.this$0.getIdentifier());
            }
            case DAYTIMEDURATION: {
                dayTime = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes2, (int)(offset2 + 1));
                long totalChronon = intervalStart - anchorTime;
                firstBinIndex = totalChronon / dayTime + (long)(totalChronon < 0L && totalChronon % dayTime != 0L ? -1 : 0);
                break;
            }
            default: {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)2, bytes2[offset2], ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG);
            }
        }
        this.listBuilder.reset((AbstractCollectionType)this.intListType);
        try {
            int binOffset;
            if (intervalTypeTag == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                long binEndChronon;
                binOffset = 0;
                do {
                    long binStartChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * (int)(firstBinIndex + (long)binOffset)), (long)(dayTime * (firstBinIndex + (long)binOffset)), (boolean)false);
                    binEndChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * ((int)(firstBinIndex + (long)binOffset) + 1)), (long)(dayTime * (firstBinIndex + (long)binOffset + 1L)), (boolean)false);
                    binStartChronon = binStartChronon / 86400000L + (long)(binStartChronon < 0L && binStartChronon % 86400000L != 0L ? -1 : 0);
                    binEndChronon = binEndChronon / 86400000L + (long)(binEndChronon < 0L && binEndChronon % 86400000L != 0L ? -1 : 0);
                    this.aInterval.setValue(binStartChronon, binEndChronon, intervalTypeTag);
                    this.listStorage.reset();
                    this.intervalSerde.serialize((Object)this.aInterval, this.listStorage.getDataOutput());
                    this.listBuilder.addItem((IValueReference)this.listStorage);
                    ++binOffset;
                } while (binEndChronon < intervalEnd);
            } else if (intervalTypeTag == ATypeTag.SERIALIZED_TIME_TYPE_TAG) {
                if (yearMonth != 0) {
                    throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                }
                binOffset = 0;
                long binStartChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * (int)(firstBinIndex + (long)binOffset)), (long)(dayTime * (firstBinIndex + (long)binOffset)), (boolean)true);
                long binEndChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * ((int)(firstBinIndex + (long)binOffset) + 1)), (long)(dayTime * (firstBinIndex + (long)binOffset + 1L)), (boolean)true);
                if (binStartChronon < 0L || binStartChronon >= 86400000L) {
                    throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                }
                while (!(binStartChronon < intervalStart && binEndChronon <= intervalStart || binStartChronon >= intervalEnd && binEndChronon > intervalEnd)) {
                    this.aInterval.setValue(binStartChronon, binEndChronon, intervalTypeTag);
                    this.listStorage.reset();
                    this.intervalSerde.serialize((Object)this.aInterval, this.listStorage.getDataOutput());
                    this.listBuilder.addItem((IValueReference)this.listStorage);
                    binStartChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * (int)(firstBinIndex + (long)(++binOffset))), (long)(dayTime * (firstBinIndex + (long)binOffset)), (boolean)true);
                    binEndChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * ((int)(firstBinIndex + (long)binOffset) + 1)), (long)(dayTime * (firstBinIndex + (long)binOffset + 1L)), (boolean)true);
                    if (binStartChronon != 86400000L) {
                        if (binEndChronon >= binStartChronon) continue;
                        throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                    }
                    break;
                }
            } else if (intervalTypeTag == ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
                long binEndChronon;
                binOffset = 0;
                do {
                    long binStartChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * (int)(firstBinIndex + (long)binOffset)), (long)(dayTime * (firstBinIndex + (long)binOffset)), (boolean)false);
                    binEndChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * ((int)(firstBinIndex + (long)binOffset) + 1)), (long)(dayTime * (firstBinIndex + (long)binOffset + 1L)), (boolean)false);
                    this.aInterval.setValue(binStartChronon, binEndChronon, intervalTypeTag);
                    this.listStorage.reset();
                    this.intervalSerde.serialize((Object)this.aInterval, this.listStorage.getDataOutput());
                    this.listBuilder.addItem((IValueReference)this.listStorage);
                    ++binOffset;
                } while (binEndChronon < intervalEnd);
            } else {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)0, bytes0[offset0], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
            }
            this.listBuilder.write(this.out, true);
        }
        catch (IOException e1) {
            throw HyracksDataException.create((Throwable)e1);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

