/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.runtime.RuntimeRecordTypeInfo;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.comparisons.DeepEqualAssessor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class RecordMergeDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new RecordMergeDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return new FunctionTypeInferers.RecordMergeTypeInferer();
        }
    };
    private static final long serialVersionUID = 1L;
    private ARecordType outRecType;
    private ARecordType inRecType0;
    private ARecordType inRecType1;

    public void setImmutableStates(Object ... states) {
        this.outRecType = TypeComputeUtils.extractRecordType((IAType)((IAType)states[0]));
        this.inRecType0 = TypeComputeUtils.extractRecordType((IAType)((IAType)states[1]));
        this.inRecType1 = TypeComputeUtils.extractRecordType((IAType)((IAType)states[2]));
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                PointableAllocator pa = new PointableAllocator();
                IVisitablePointable vp0 = pa.allocateRecordValue((IAType)RecordMergeDescriptor.this.inRecType0);
                IVisitablePointable vp1 = pa.allocateRecordValue((IAType)RecordMergeDescriptor.this.inRecType1);
                VoidPointable argPtr0 = new VoidPointable();
                VoidPointable argPtr1 = new VoidPointable();
                final IScalarEvaluator eval0 = args[0].createScalarEvaluator(ctx);
                IScalarEvaluator eval1 = args[1].createScalarEvaluator(ctx);
                ArrayList rbStack = new ArrayList();
                ArrayBackedValueStorage tabvs = new ArrayBackedValueStorage();
                IBinaryComparator stringBinaryComparator = PointableHelper.createStringBinaryComparator();
                return new IScalarEvaluator((IPointable)argPtr0, eval1, (IPointable)argPtr1, vp0, vp1, rbStack, stringBinaryComparator, tabvs){
                    private final RuntimeRecordTypeInfo runtimeRecordTypeInfo = new RuntimeRecordTypeInfo();
                    private final DeepEqualAssessor deepEqualAssesor = new DeepEqualAssessor();
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    final /* synthetic */ IPointable val$argPtr0;
                    final /* synthetic */ IScalarEvaluator val$eval1;
                    final /* synthetic */ IPointable val$argPtr1;
                    final /* synthetic */ IVisitablePointable val$vp0;
                    final /* synthetic */ IVisitablePointable val$vp1;
                    final /* synthetic */ List val$rbStack;
                    final /* synthetic */ IBinaryComparator val$stringBinaryComparator;
                    final /* synthetic */ ArrayBackedValueStorage val$tabvs;
                    {
                        this.val$argPtr0 = iPointable;
                        this.val$eval1 = iScalarEvaluator2;
                        this.val$argPtr1 = iPointable2;
                        this.val$vp0 = iVisitablePointable;
                        this.val$vp1 = iVisitablePointable2;
                        this.val$rbStack = list;
                        this.val$stringBinaryComparator = iBinaryComparator;
                        this.val$tabvs = arrayBackedValueStorage;
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        eval0.evaluate(tuple, this.val$argPtr0);
                        this.val$eval1.evaluate(tuple, this.val$argPtr1);
                        this.val$vp0.set((IValueReference)this.val$argPtr0);
                        this.val$vp1.set((IValueReference)this.val$argPtr1);
                        ARecordVisitablePointable rp0 = (ARecordVisitablePointable)this.val$vp0;
                        ARecordVisitablePointable rp1 = (ARecordVisitablePointable)this.val$vp1;
                        try {
                            this.mergeFields(RecordMergeDescriptor.this.outRecType, rp0, rp1, true, 0);
                            ((RecordBuilder)this.val$rbStack.get(0)).write(this.out, true);
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }

                    private void mergeFields(ARecordType combinedType, ARecordVisitablePointable leftRecord, ARecordVisitablePointable rightRecord, boolean openFromParent, int nestedLevel) throws IOException {
                        if (this.val$rbStack.size() < nestedLevel + 1) {
                            this.val$rbStack.add(new RecordBuilder());
                        }
                        ((RecordBuilder)this.val$rbStack.get(nestedLevel)).reset(combinedType);
                        ((RecordBuilder)this.val$rbStack.get(nestedLevel)).init();
                        for (int i = 0; i < leftRecord.getFieldNames().size(); ++i) {
                            IVisitablePointable leftName = (IVisitablePointable)leftRecord.getFieldNames().get(i);
                            IVisitablePointable leftValue = (IVisitablePointable)leftRecord.getFieldValues().get(i);
                            IVisitablePointable leftType = (IVisitablePointable)leftRecord.getFieldTypeTags().get(i);
                            boolean foundMatch = false;
                            for (int j = 0; j < rightRecord.getFieldNames().size(); ++j) {
                                IVisitablePointable rightName = (IVisitablePointable)rightRecord.getFieldNames().get(j);
                                IVisitablePointable rightValue = (IVisitablePointable)rightRecord.getFieldValues().get(j);
                                IVisitablePointable rightType = (IVisitablePointable)rightRecord.getFieldTypeTags().get(j);
                                if (!PointableHelper.isEqual((IValueReference)leftName, (IValueReference)rightName, this.val$stringBinaryComparator) || this.deepEqualAssesor.isEqual(leftValue, rightValue)) continue;
                                if (PointableHelper.sameType(ATypeTag.OBJECT, rightType) && PointableHelper.sameType(ATypeTag.OBJECT, leftType)) {
                                    this.addFieldToSubRecord(combinedType, leftName, leftValue, rightValue, openFromParent, nestedLevel);
                                    foundMatch = true;
                                    continue;
                                }
                                throw new RuntimeDataException(13, new Serializable[]{RecordMergeDescriptor.this.getIdentifier()});
                            }
                            if (foundMatch) continue;
                            this.addFieldToSubRecord(combinedType, leftName, leftValue, null, openFromParent, nestedLevel);
                        }
                        for (int j = 0; j < rightRecord.getFieldNames().size(); ++j) {
                            IVisitablePointable rightName = (IVisitablePointable)rightRecord.getFieldNames().get(j);
                            IVisitablePointable rightValue = (IVisitablePointable)rightRecord.getFieldValues().get(j);
                            boolean foundMatch = false;
                            for (int i = 0; i < leftRecord.getFieldNames().size(); ++i) {
                                IVisitablePointable leftName = (IVisitablePointable)leftRecord.getFieldNames().get(i);
                                if (!rightName.equals(leftName)) continue;
                                foundMatch = true;
                            }
                            if (foundMatch) continue;
                            this.addFieldToSubRecord(combinedType, rightName, rightValue, null, openFromParent, nestedLevel);
                        }
                    }

                    private void addFieldToSubRecord(ARecordType combinedType, IVisitablePointable fieldNamePointable, IVisitablePointable leftValue, IVisitablePointable rightValue, boolean openFromParent, int nestedLevel) throws IOException {
                        this.runtimeRecordTypeInfo.reset(combinedType);
                        int pos = this.runtimeRecordTypeInfo.getFieldIndex(fieldNamePointable.getByteArray(), fieldNamePointable.getStartOffset() + 1, fieldNamePointable.getLength() - 1);
                        if (combinedType != null && pos >= 0) {
                            if (rightValue == null) {
                                ((RecordBuilder)this.val$rbStack.get(nestedLevel)).addField(pos, (IValueReference)leftValue);
                            } else {
                                this.mergeFields((ARecordType)combinedType.getFieldTypes()[pos], (ARecordVisitablePointable)leftValue, (ARecordVisitablePointable)rightValue, false, nestedLevel + 1);
                                this.val$tabvs.reset();
                                ((RecordBuilder)this.val$rbStack.get(nestedLevel + 1)).write(this.val$tabvs.getDataOutput(), true);
                                ((RecordBuilder)this.val$rbStack.get(nestedLevel)).addField(pos, (IValueReference)this.val$tabvs);
                            }
                        } else if (rightValue == null) {
                            ((RecordBuilder)this.val$rbStack.get(nestedLevel)).addField((IValueReference)fieldNamePointable, (IValueReference)leftValue);
                        } else {
                            this.mergeFields(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE, (ARecordVisitablePointable)leftValue, (ARecordVisitablePointable)rightValue, false, nestedLevel + 1);
                            this.val$tabvs.reset();
                            ((RecordBuilder)this.val$rbStack.get(nestedLevel + 1)).write(this.val$tabvs.getDataOutput(), true);
                            ((RecordBuilder)this.val$rbStack.get(nestedLevel)).addField((IValueReference)fieldNamePointable, (IValueReference)this.val$tabvs);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.RECORD_MERGE;
    }
}

