/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.binary;

import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.functions.binary.AbstractBinaryScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractFindBinaryEvaluator
extends AbstractBinaryScalarEvaluator {
    private static final ATypeTag[] EXPECTED_INPUT_TAG = new ATypeTag[]{ATypeTag.BINARY, ATypeTag.BINARY};
    protected final int baseOffset;
    protected final String functionName;
    protected final AMutableInt64 result = new AMutableInt64(-1L);
    protected final ByteArrayPointable textPtr = new ByteArrayPointable();
    protected final ByteArrayPointable wordPtr = new ByteArrayPointable();
    protected ISerializerDeserializer<AInt64> intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);

    public AbstractFindBinaryEvaluator(IHyracksTaskContext context, IScalarEvaluatorFactory[] copyEvaluatorFactories, int baseOffset, String functionName) throws HyracksDataException {
        super(context, copyEvaluatorFactories);
        this.baseOffset = baseOffset;
        this.functionName = functionName;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
        this.resultStorage.reset();
        for (int i = 0; i < this.pointables.length; ++i) {
            this.evaluators[i].evaluate(tuple, this.pointables[i]);
        }
        int fromOffset = this.getFromOffset(tuple);
        ATypeTag textTag = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[0].getByteArray()[this.pointables[0].getStartOffset()]];
        ATypeTag wordTag = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[1].getByteArray()[this.pointables[1].getStartOffset()]];
        this.checkTypeMachingThrowsIfNot(this.functionName, EXPECTED_INPUT_TAG, textTag, wordTag);
        this.textPtr.set(this.pointables[0].getByteArray(), this.pointables[0].getStartOffset() + 1, this.pointables[0].getLength() - 1);
        this.wordPtr.set(this.pointables[1].getByteArray(), this.pointables[0].getStartOffset() + 1, this.pointables[1].getLength() - 1);
        int pos = this.indexOf(this.textPtr.getByteArray(), this.textPtr.getContentStartOffset(), this.textPtr.getContentLength(), this.wordPtr.getByteArray(), this.wordPtr.getContentStartOffset(), this.wordPtr.getContentLength(), fromOffset);
        this.result.setValue(pos < 0 ? (long)pos : (long)(pos + this.baseOffset));
        this.intSerde.serialize((Object)this.result, this.dataOutput);
        resultPointable.set((IValueReference)this.resultStorage);
    }

    protected abstract int getFromOffset(IFrameTupleReference var1) throws HyracksDataException;

    private int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        int from = fromIndex;
        if (from < 0) {
            from = 0;
        }
        if (targetCount == 0) {
            return from;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }
}

