/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class StringRepeatDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new StringRepeatDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private IScalarEvaluator evalString;
                    private IScalarEvaluator evalStart;
                    private IPointable argString;
                    private IPointable argNumber;
                    private ArrayBackedValueStorage resultStorage;
                    private DataOutput out;
                    private byte[] tempLengthArray;
                    {
                        this.evalString = args[0].createScalarEvaluator(ctx);
                        this.evalStart = args[1].createScalarEvaluator(ctx);
                        this.argString = new VoidPointable();
                        this.argNumber = new VoidPointable();
                        this.resultStorage = new ArrayBackedValueStorage();
                        this.out = this.resultStorage.getDataOutput();
                        this.tempLengthArray = new byte[5];
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.evalString.evaluate(tuple, this.argString);
                        this.evalStart.evaluate(tuple, this.argNumber);
                        byte[] bytes = this.argNumber.getByteArray();
                        int offset = this.argNumber.getStartOffset();
                        int repeatingTimes = ATypeHierarchy.getIntegerValue((String)StringRepeatDescriptor.this.getIdentifier().getName(), (int)1, (byte[])bytes, (int)offset);
                        if (repeatingTimes < 0) {
                            throw new RuntimeDataException(10, new Serializable[]{StringRepeatDescriptor.this.getIdentifier(), Integer.valueOf(1), Integer.valueOf(repeatingTimes)});
                        }
                        bytes = this.argString.getByteArray();
                        if (bytes[offset = this.argString.getStartOffset()] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                            throw new TypeMismatchException(StringRepeatDescriptor.this.getIdentifier(), (Integer)0, bytes[offset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                        }
                        int inputLen = UTF8StringUtil.getUTFLength((byte[])bytes, (int)(offset + 1));
                        int resultLen = Math.multiplyExact(inputLen, repeatingTimes);
                        int cbytes = UTF8StringUtil.encodeUTF8Length((int)resultLen, (byte[])this.tempLengthArray, (int)0);
                        int inputStringStart = offset + 1 + UTF8StringUtil.getNumBytesToStoreLength((int)inputLen);
                        try {
                            this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            this.out.write(this.tempLengthArray, 0, cbytes);
                            for (int numRepeats = 0; numRepeats < repeatingTimes; ++numRepeats) {
                                this.out.write(bytes, inputStringStart, inputLen);
                            }
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_REPEAT;
    }
}

