/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.AMutableRectangle;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.functions.SpatialCellDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class SpatialCellDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable inputArg0 = new VoidPointable();
    private final IPointable inputArg1 = new VoidPointable();
    private final IPointable inputArg2 = new VoidPointable();
    private final IPointable inputArg3 = new VoidPointable();
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IScalarEvaluator eval2;
    private final IScalarEvaluator eval3;
    private final AMutableRectangle aRectangle;
    private final AMutablePoint[] aPoint;
    private final ISerializerDeserializer<ARectangle> rectangleSerde;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ SpatialCellDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    SpatialCellDescriptor$_EvaluatorGen(SpatialCellDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval0 = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.eval1 = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.eval2 = this.this$1.val$args[2].createScalarEvaluator(this.val$ctx);
        this.eval3 = this.this$1.val$args[3].createScalarEvaluator(this.val$ctx);
        this.aRectangle = new AMutableRectangle(null, null);
        this.aPoint = new AMutablePoint[]{new AMutablePoint(0.0, 0.0), new AMutablePoint(0.0, 0.0)};
        this.rectangleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ARECTANGLE);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.inputArg0);
        if (this.typeChecker.isMissing(this.inputArg0, result)) {
            return;
        }
        this.eval1.evaluate(tuple, this.inputArg1);
        if (this.typeChecker.isMissing(this.inputArg1, result)) {
            return;
        }
        this.eval2.evaluate(tuple, this.inputArg2);
        if (this.typeChecker.isMissing(this.inputArg2, result)) {
            return;
        }
        this.eval3.evaluate(tuple, this.inputArg3);
        if (this.typeChecker.isMissing(this.inputArg3, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] bytes0 = this.inputArg0.getByteArray();
        byte[] bytes1 = this.inputArg1.getByteArray();
        byte[] bytes2 = this.inputArg2.getByteArray();
        byte[] bytes3 = this.inputArg3.getByteArray();
        int offset0 = this.inputArg0.getStartOffset();
        int offset1 = this.inputArg1.getStartOffset();
        int offset2 = this.inputArg2.getStartOffset();
        int offset3 = this.inputArg3.getStartOffset();
        try {
            byte tag0 = bytes0[offset0];
            byte tag1 = bytes1[offset1];
            byte tag2 = bytes2[offset2];
            byte tag3 = bytes3[offset3];
            if (tag0 == ATypeTag.SERIALIZED_POINT_TYPE_TAG && tag1 == ATypeTag.SERIALIZED_POINT_TYPE_TAG && tag2 == ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG && tag3 == ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
                double xLoc = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X)));
                double yLoc = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y)));
                double xOrigin = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X)));
                double yOrigin = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y)));
                double xInc = ADoubleSerializerDeserializer.getDouble((byte[])bytes2, (int)(offset2 + 1));
                double yInc = ADoubleSerializerDeserializer.getDouble((byte[])bytes3, (int)(offset3 + 1));
                double x = xOrigin + Math.floor((xLoc - xOrigin) / xInc) * xInc;
                double y = yOrigin + Math.floor((yLoc - yOrigin) / yInc) * yInc;
                this.aPoint[0].setValue(x, y);
                this.aPoint[1].setValue(x + xInc, y + yInc);
                this.aRectangle.setValue((APoint)this.aPoint[0], (APoint)this.aPoint[1]);
                this.rectangleSerde.serialize((Object)this.aRectangle, this.out);
            } else {
                if (tag0 != ATypeTag.SERIALIZED_POINT_TYPE_TAG) {
                    throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)0, tag0, ATypeTag.SERIALIZED_POINT_TYPE_TAG);
                }
                if (tag1 != ATypeTag.SERIALIZED_POINT_TYPE_TAG) {
                    throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)1, tag1, ATypeTag.SERIALIZED_POINT_TYPE_TAG);
                }
                if (tag2 != ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
                    throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)2, tag2, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                }
                if (tag3 != ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
                    throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)3, tag3, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                }
            }
            result.set((IValueReference)this.resultStorage);
        }
        catch (IOException e1) {
            throw HyracksDataException.create((Throwable)e1);
        }
    }
}

