/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class PointableHelper {
    private static final byte[] NULL_BYTES = new byte[]{ATypeTag.SERIALIZED_NULL_TYPE_TAG};
    private final UTF8StringWriter utf8Writer = new UTF8StringWriter();

    public static IBinaryComparator createStringBinaryComparator() {
        return PointableBinaryComparatorFactory.of((IPointableFactory)UTF8StringPointable.FACTORY).createBinaryComparator();
    }

    public static int compareStringBinValues(IValueReference a, IValueReference b, IBinaryComparator comparator) throws HyracksDataException {
        return comparator.compare(a.getByteArray(), a.getStartOffset() + 1, a.getLength() - 1, b.getByteArray(), b.getStartOffset() + 1, b.getLength() - 1);
    }

    public static boolean isEqual(IValueReference a, IValueReference b, IBinaryComparator comparator) throws HyracksDataException {
        return PointableHelper.compareStringBinValues(a, b, comparator) == 0;
    }

    public static boolean byteArrayEqual(IValueReference valueRef1, IValueReference valueRef2) {
        return PointableHelper.byteArrayEqual(valueRef1, valueRef2, 3);
    }

    public static boolean byteArrayEqual(IValueReference valueRef1, IValueReference valueRef2, int dataOffset) {
        int length2;
        if (valueRef1 == null || valueRef2 == null) {
            return false;
        }
        if (valueRef1 == valueRef2) {
            return true;
        }
        int length1 = valueRef1.getLength();
        if (length1 != (length2 = valueRef2.getLength())) {
            return false;
        }
        byte[] bytes1 = valueRef1.getByteArray();
        byte[] bytes2 = valueRef2.getByteArray();
        int start1 = valueRef1.getStartOffset() + dataOffset;
        int start2 = valueRef2.getStartOffset() + dataOffset;
        int end = start1 + length1 - dataOffset;
        int i = start1;
        int j = start2;
        while (i < end) {
            if (bytes1[i] != bytes2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean sameType(ATypeTag typeTag, IVisitablePointable visitablePointable) {
        return PointableHelper.getTypeTag((IValueReference)visitablePointable) == typeTag;
    }

    public static ATypeTag getTypeTag(IValueReference visitablePointable) {
        byte[] bytes = visitablePointable.getByteArray();
        int s = visitablePointable.getStartOffset();
        return (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[s]);
    }

    public void serializeString(String str, IMutableValueStorage vs, boolean writeTag) throws HyracksDataException {
        vs.reset();
        try {
            DataOutput output = vs.getDataOutput();
            if (writeTag) {
                output.write(ATypeTag.STRING.serialize());
            }
            this.utf8Writer.writeUTF8((CharSequence)str, output);
        }
        catch (IOException e) {
            throw new HyracksDataException("Could not serialize " + str);
        }
    }

    public static void setNull(IPointable pointable) {
        pointable.set(NULL_BYTES, 0, NULL_BYTES.length);
    }
}

