/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.AbstractNumericArithmeticEval$_Gen;
import org.apache.asterix.runtime.evaluators.functions.NumericDivideDescriptor$_InnerGen;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class NumericDivideDescriptor$_Gen
extends AbstractNumericArithmeticEval$_Gen {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new NumericDivideDescriptor$_InnerGen();

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_DIVIDE;
    }

    @Override
    protected long evaluateInteger(long lhs, long rhs) throws HyracksDataException {
        if (rhs == 0L) {
            throw new RuntimeDataException(34, new Serializable[0]);
        }
        if (lhs == Long.MIN_VALUE && rhs == -1L) {
            throw new OverflowException(this.getIdentifier());
        }
        return lhs / rhs;
    }

    @Override
    protected double evaluateDouble(double lhs, double rhs) {
        return lhs / rhs;
    }

    @Override
    protected long evaluateTimeDurationArithmetic(long chronon, int yearMonth, long dayTime, boolean isTimeOnly) throws HyracksDataException {
        throw new NotImplementedException("Divide operation is not defined for temporal types");
    }

    @Override
    protected long evaluateTimeInstanceArithmetic(long chronon0, long chronon1) throws HyracksDataException {
        throw new UnsupportedTypeException(this.getIdentifier(), ATypeTag.SERIALIZED_TIME_TYPE_TAG);
    }
}

