/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import com.google.common.math.LongMath;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.AbstractNumericArithmeticEval;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class NumericCaretDescriptor
extends AbstractNumericArithmeticEval {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new NumericCaretDescriptor();
        }
    };

    @Override
    protected long evaluateInteger(long lhs, long rhs) throws HyracksDataException {
        if (rhs > Integer.MAX_VALUE) {
            throw new OverflowException(this.getIdentifier());
        }
        return LongMath.checkedPow((long)lhs, (int)((int)rhs));
    }

    @Override
    protected double evaluateDouble(double lhs, double rhs) throws HyracksDataException {
        return Math.pow(lhs, rhs);
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.CARET;
    }

    @Override
    protected long evaluateTimeDurationArithmetic(long chronon, int yearMonth, long dayTime, boolean isTimeOnly) throws HyracksDataException {
        throw new UnsupportedTypeException(this.getIdentifier().getName(), ATypeTag.SERIALIZED_DURATION_TYPE_TAG);
    }

    @Override
    protected long evaluateTimeInstanceArithmetic(long chronon0, long chronon1) throws HyracksDataException {
        throw new UnsupportedTypeException(this.getIdentifier().getName(), ATypeTag.SERIALIZED_TIME_TYPE_TAG);
    }
}

