/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.comparisons.DeepEqualAssessor;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class DeepEqualityDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new DeepEqualityDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return new FunctionTypeInferers.DeepEqualityTypeInferer();
        }
    };
    private static final long serialVersionUID = 1L;
    private IAType inputTypeLeft;
    private IAType inputTypeRight;

    public void setImmutableStates(Object ... states) {
        this.inputTypeLeft = (IAType)states[0];
        this.inputTypeRight = (IAType)states[1];
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        final IScalarEvaluatorFactory evalFactoryLeft = args[0];
        final IScalarEvaluatorFactory evalFactoryRight = args[1];
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;
            private final ISerializerDeserializer<ABoolean> boolSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                final DataOutput out = resultStorage.getDataOutput();
                final IScalarEvaluator evalLeft = evalFactoryLeft.createScalarEvaluator(ctx);
                final IScalarEvaluator evalRight = evalFactoryRight.createScalarEvaluator(ctx);
                return new IScalarEvaluator(){
                    private final DeepEqualAssessor deepEqualAssessor = new DeepEqualAssessor();
                    private final PointableAllocator allocator = new PointableAllocator();
                    private final IVisitablePointable pointableLeft;
                    private final IVisitablePointable pointableRight;
                    {
                        this.pointableLeft = this.allocator.allocateFieldValue(DeepEqualityDescriptor.this.inputTypeLeft);
                        this.pointableRight = this.allocator.allocateFieldValue(DeepEqualityDescriptor.this.inputTypeRight);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        try {
                            evalLeft.evaluate(tuple, (IPointable)this.pointableLeft);
                            evalRight.evaluate(tuple, (IPointable)this.pointableRight);
                            boolean isEqual = this.deepEqualAssessor.isEqual(this.pointableLeft, this.pointableRight);
                            ABoolean resultBit = isEqual ? ABoolean.TRUE : ABoolean.FALSE;
                            resultStorage.reset();
                            boolSerde.serialize((Object)resultBit, out);
                            result.set((IValueReference)resultStorage);
                        }
                        catch (Exception ioe) {
                            throw HyracksDataException.create((Throwable)ioe);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.DEEP_EQUAL;
    }
}

