/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

abstract class AbstractUnaryStringStringEval$_EvaluatorGen
implements IScalarEvaluator {
    private final IScalarEvaluator argEval;
    private final VoidPointable argPtr = new VoidPointable();
    private final UTF8StringPointable stringPtr = new UTF8StringPointable();
    final GrowableArray resultArray = new GrowableArray();
    final UTF8StringBuilder resultBuilder = new UTF8StringBuilder();
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput dataOutput = this.resultStorage.getDataOutput();
    private final FunctionIdentifier funcID;
    private final TypeChecker typeChecker;

    AbstractUnaryStringStringEval$_EvaluatorGen(IHyracksTaskContext context, IScalarEvaluatorFactory argEvalFactory, FunctionIdentifier funcID) throws HyracksDataException {
        this.argEval = argEvalFactory.createScalarEvaluator(context);
        this.funcID = funcID;
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
        int offset;
        this.resultStorage.reset();
        this.argEval.evaluate(tuple, (IPointable)this.argPtr);
        if (this.typeChecker.isMissing((IPointable)this.argPtr, resultPointable)) {
            return;
        }
        if (this.typeChecker.isNull(resultPointable)) {
            return;
        }
        byte[] argBytes = this.argPtr.getByteArray();
        byte inputTypeTag = argBytes[offset = this.argPtr.getStartOffset()];
        if (inputTypeTag != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            throw new TypeMismatchException(this.funcID, (Integer)0, argBytes[offset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
        this.stringPtr.set(argBytes, offset + 1, this.argPtr.getLength() - 1);
        this.resultArray.reset();
        try {
            this.process(this.stringPtr, resultPointable);
            this.writeResult(resultPointable);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    abstract void process(UTF8StringPointable var1, IPointable var2) throws IOException;

    void writeResult(IPointable resultPointable) throws IOException {
        this.dataOutput.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        this.dataOutput.write(this.resultArray.getByteArray(), 0, this.resultArray.getLength());
        resultPointable.set((IValueReference)this.resultStorage);
    }
}

