/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractQuadStringStringEval
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput dout = this.resultStorage.getDataOutput();
    private IPointable array0 = new VoidPointable();
    private IPointable array1 = new VoidPointable();
    private IPointable array2 = new VoidPointable();
    private IPointable array3 = new VoidPointable();
    private IScalarEvaluator eval0;
    private IScalarEvaluator eval1;
    private IScalarEvaluator eval2;
    private IScalarEvaluator eval3;
    private final FunctionIdentifier funcID;
    private AMutableString resultBuffer = new AMutableString("");
    private ISerializerDeserializer strSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
    private final UTF8StringPointable strPtr1st = new UTF8StringPointable();
    private final UTF8StringPointable strPtr2nd = new UTF8StringPointable();
    private final UTF8StringPointable strPtr3rd = new UTF8StringPointable();
    private final UTF8StringPointable strPtr4th = new UTF8StringPointable();

    public AbstractQuadStringStringEval(IHyracksTaskContext context, IScalarEvaluatorFactory eval0, IScalarEvaluatorFactory eval1, IScalarEvaluatorFactory eval2, IScalarEvaluatorFactory eval3, FunctionIdentifier funcID) throws HyracksDataException {
        this.eval0 = eval0.createScalarEvaluator(context);
        this.eval1 = eval1.createScalarEvaluator(context);
        this.eval2 = eval2.createScalarEvaluator(context);
        this.eval3 = eval3.createScalarEvaluator(context);
        this.funcID = funcID;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.eval0.evaluate(tuple, this.array0);
        this.eval1.evaluate(tuple, this.array1);
        this.eval2.evaluate(tuple, this.array2);
        this.eval3.evaluate(tuple, this.array3);
        byte[] bytes0 = this.array0.getByteArray();
        byte[] bytes1 = this.array1.getByteArray();
        byte[] bytes2 = this.array2.getByteArray();
        byte[] bytes3 = this.array3.getByteArray();
        int start0 = this.array0.getStartOffset();
        int start1 = this.array1.getStartOffset();
        int start2 = this.array2.getStartOffset();
        int start3 = this.array3.getStartOffset();
        int len0 = this.array0.getLength();
        int len1 = this.array1.getLength();
        int len2 = this.array2.getLength();
        int len3 = this.array3.getLength();
        this.resultStorage.reset();
        if (bytes0[start0] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            throw new TypeMismatchException(this.funcID, (Integer)0, bytes0[start0], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
        if (bytes1[start1] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            throw new TypeMismatchException(this.funcID, (Integer)1, bytes1[start1], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
        if (bytes2[start2] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            throw new TypeMismatchException(this.funcID, (Integer)2, bytes2[start2], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
        if (bytes3[start3] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            throw new TypeMismatchException(this.funcID, (Integer)3, bytes1[start3], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
        this.strPtr1st.set(bytes0, start0 + 1, len0);
        this.strPtr2nd.set(bytes1, start1 + 1, len1);
        this.strPtr3rd.set(bytes2, start2 + 1, len2);
        this.strPtr4th.set(bytes3, start3 + 1, len3);
        try {
            String res = this.compute(this.strPtr1st, this.strPtr2nd, this.strPtr3rd, this.strPtr4th);
            this.resultBuffer.setValue(res);
            this.strSerde.serialize((Object)this.resultBuffer, this.dout);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    protected abstract String compute(UTF8StringPointable var1, UTF8StringPointable var2, UTF8StringPointable var3, UTF8StringPointable var4) throws IOException;
}

