/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDate;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableDuration;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.base.AMutableTime;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnderflowException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractNumericArithmeticEval
extends AbstractScalarFunctionDynamicDescriptor {
    protected abstract long evaluateInteger(long var1, long var3) throws HyracksDataException;

    protected abstract double evaluateDouble(double var1, double var3) throws HyracksDataException;

    protected abstract long evaluateTimeDurationArithmetic(long var1, int var3, long var4, boolean var6) throws HyracksDataException;

    protected abstract long evaluateTimeInstanceArithmetic(long var1, long var3) throws HyracksDataException;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable argPtr0 = new VoidPointable();
                    private IPointable argPtr1 = new VoidPointable();
                    private IScalarEvaluator evalLeft;
                    private IScalarEvaluator evalRight;
                    private double[] operandsFloating;
                    private long[] operandsInteger;
                    private int resultType;
                    protected static final int typeInt8 = 1;
                    protected static final int typeInt16 = 2;
                    protected static final int typeInt32 = 3;
                    protected static final int typeInt64 = 4;
                    protected static final int typeFloat = 5;
                    protected static final int typeDouble = 6;
                    protected AMutableFloat aFloat;
                    protected AMutableDouble aDouble;
                    protected AMutableInt64 aInt64;
                    protected AMutableInt32 aInt32;
                    protected AMutableInt16 aInt16;
                    protected AMutableInt8 aInt8;
                    protected AMutableDuration aDuration;
                    protected AMutableDate aDate;
                    protected AMutableTime aTime;
                    protected AMutableDateTime aDatetime;
                    private ATypeTag typeTag;
                    private ISerializerDeserializer serde;
                    {
                        this.evalLeft = args[0].createScalarEvaluator(ctx);
                        this.evalRight = args[1].createScalarEvaluator(ctx);
                        this.operandsFloating = new double[args.length];
                        this.operandsInteger = new long[args.length];
                        this.aFloat = new AMutableFloat(0.0f);
                        this.aDouble = new AMutableDouble(0.0);
                        this.aInt64 = new AMutableInt64(0L);
                        this.aInt32 = new AMutableInt32(0);
                        this.aInt16 = new AMutableInt16(0);
                        this.aInt8 = new AMutableInt8(0);
                        this.aDuration = new AMutableDuration(0, 0L);
                        this.aDate = new AMutableDate(0);
                        this.aTime = new AMutableTime(0);
                        this.aDatetime = new AMutableDateTime(0L);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.resultType = 0;
                        this.evalLeft.evaluate(tuple, this.argPtr0);
                        this.evalRight.evaluate(tuple, this.argPtr1);
                        for (int i = 0; i < args.length; ++i) {
                            int currentType;
                            IPointable argPtr = i == 0 ? this.argPtr0 : this.argPtr1;
                            byte[] bytes = argPtr.getByteArray();
                            int offset = argPtr.getStartOffset();
                            this.typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
                            switch (this.typeTag) {
                                case TINYINT: {
                                    currentType = 1;
                                    this.operandsInteger[i] = AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(offset + 1));
                                    this.operandsFloating[i] = this.operandsInteger[i];
                                    break;
                                }
                                case SMALLINT: {
                                    currentType = 2;
                                    this.operandsInteger[i] = AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(offset + 1));
                                    this.operandsFloating[i] = this.operandsInteger[i];
                                    break;
                                }
                                case INTEGER: {
                                    currentType = 3;
                                    this.operandsInteger[i] = AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(offset + 1));
                                    this.operandsFloating[i] = this.operandsInteger[i];
                                    break;
                                }
                                case BIGINT: {
                                    currentType = 4;
                                    this.operandsInteger[i] = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(offset + 1));
                                    this.operandsFloating[i] = this.operandsInteger[i];
                                    break;
                                }
                                case FLOAT: {
                                    currentType = 5;
                                    this.operandsFloating[i] = AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)(offset + 1));
                                    break;
                                }
                                case DOUBLE: {
                                    currentType = 6;
                                    this.operandsFloating[i] = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1));
                                    break;
                                }
                                case DATE: 
                                case TIME: 
                                case DATETIME: 
                                case DURATION: 
                                case YEARMONTHDURATION: 
                                case DAYTIMEDURATION: {
                                    this.evaluateTemporalArthmeticOperation(this.typeTag);
                                    result.set((IValueReference)this.resultStorage);
                                    return;
                                }
                                default: {
                                    throw new TypeMismatchException(AbstractNumericArithmeticEval.this.getIdentifier(), (Integer)i, bytes[offset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG, ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG, ATypeTag.SERIALIZED_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG);
                                }
                            }
                            if (this.resultType >= currentType) continue;
                            this.resultType = currentType;
                        }
                        switch (this.resultType) {
                            case 1: {
                                this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
                                long lres = AbstractNumericArithmeticEval.this.evaluateInteger(this.operandsInteger[0], this.operandsInteger[1]);
                                if (lres > 127L) {
                                    throw new OverflowException(AbstractNumericArithmeticEval.this.getIdentifier());
                                }
                                if (lres < -128L) {
                                    throw new UnderflowException(AbstractNumericArithmeticEval.this.getIdentifier());
                                }
                                this.aInt8.setValue((byte)lres);
                                this.serde.serialize((Object)this.aInt8, this.out);
                                break;
                            }
                            case 2: {
                                this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT16);
                                long lres = AbstractNumericArithmeticEval.this.evaluateInteger(this.operandsInteger[0], this.operandsInteger[1]);
                                if (lres > 32767L) {
                                    throw new OverflowException(AbstractNumericArithmeticEval.this.getIdentifier());
                                }
                                if (lres < -32768L) {
                                    throw new UnderflowException(AbstractNumericArithmeticEval.this.getIdentifier());
                                }
                                this.aInt16.setValue((short)lres);
                                this.serde.serialize((Object)this.aInt16, this.out);
                                break;
                            }
                            case 3: {
                                this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                                long lres = AbstractNumericArithmeticEval.this.evaluateInteger(this.operandsInteger[0], this.operandsInteger[1]);
                                if (lres > Integer.MAX_VALUE) {
                                    throw new OverflowException(AbstractNumericArithmeticEval.this.getIdentifier());
                                }
                                if (lres < Integer.MIN_VALUE) {
                                    throw new UnderflowException(AbstractNumericArithmeticEval.this.getIdentifier());
                                }
                                this.aInt32.setValue((int)lres);
                                this.serde.serialize((Object)this.aInt32, this.out);
                                break;
                            }
                            case 4: {
                                this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                                long lres = AbstractNumericArithmeticEval.this.evaluateInteger(this.operandsInteger[0], this.operandsInteger[1]);
                                this.aInt64.setValue(lres);
                                this.serde.serialize((Object)this.aInt64, this.out);
                                break;
                            }
                            case 5: {
                                this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
                                double dres = AbstractNumericArithmeticEval.this.evaluateDouble(this.operandsFloating[0], this.operandsFloating[1]);
                                if (dres > 3.4028234663852886E38) {
                                    throw new OverflowException(AbstractNumericArithmeticEval.this.getIdentifier());
                                }
                                if (dres < -3.4028234663852886E38) {
                                    throw new UnderflowException(AbstractNumericArithmeticEval.this.getIdentifier());
                                }
                                this.aFloat.setValue((float)dres);
                                this.serde.serialize((Object)this.aFloat, this.out);
                                break;
                            }
                            case 6: {
                                this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                                this.aDouble.setValue(AbstractNumericArithmeticEval.this.evaluateDouble(this.operandsFloating[0], this.operandsFloating[1]));
                                this.serde.serialize((Object)this.aDouble, this.out);
                            }
                        }
                        result.set((IValueReference)this.resultStorage);
                    }

                    private void evaluateTemporalArthmeticOperation(ATypeTag leftType) throws HyracksDataException {
                        byte[] bytes1 = this.argPtr1.getByteArray();
                        int offset1 = this.argPtr1.getStartOffset();
                        ATypeTag rightType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
                        byte[] bytes0 = this.argPtr0.getByteArray();
                        int offset0 = this.argPtr0.getStartOffset();
                        if (rightType == leftType) {
                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADURATION);
                            long leftChronon = 0L;
                            long rightChronon = 0L;
                            long dayTime = 0L;
                            int yearMonth = 0;
                            switch (leftType) {
                                case DATE: {
                                    leftChronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1)) * 86400000L;
                                    rightChronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1)) * 86400000L;
                                    break;
                                }
                                case TIME: {
                                    leftChronon = ATimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                                    rightChronon = ATimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                    break;
                                }
                                case DATETIME: {
                                    leftChronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                                    rightChronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                    break;
                                }
                                case YEARMONTHDURATION: {
                                    yearMonth = (int)AbstractNumericArithmeticEval.this.evaluateTimeInstanceArithmetic(AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes0, (int)(offset0 + 1)), AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1)));
                                    break;
                                }
                                case DAYTIMEDURATION: {
                                    leftChronon = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes0, (int)(offset0 + 1));
                                    rightChronon = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                                    break;
                                }
                                default: {
                                    throw new UnsupportedTypeException(AbstractNumericArithmeticEval.this.getIdentifier(), bytes1[offset1]);
                                }
                            }
                            dayTime = AbstractNumericArithmeticEval.this.evaluateTimeInstanceArithmetic(leftChronon, rightChronon);
                            this.aDuration.setValue(yearMonth, dayTime);
                            this.serde.serialize((Object)this.aDuration, this.out);
                        } else {
                            long chronon = 0L;
                            long dayTime = 0L;
                            int yearMonth = 0;
                            ATypeTag resultType = null;
                            boolean isTimeOnly = false;
                            block7 : switch (leftType) {
                                case TIME: {
                                    this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ATIME);
                                    chronon = ATimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                                    isTimeOnly = true;
                                    resultType = ATypeTag.TIME;
                                    switch (rightType) {
                                        case DAYTIMEDURATION: {
                                            dayTime = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                                            break block7;
                                        }
                                        case DURATION: {
                                            dayTime = ADurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                                            yearMonth = ADurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1));
                                            break block7;
                                        }
                                    }
                                    throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                }
                                case DATE: {
                                    this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
                                    resultType = ATypeTag.DATE;
                                    chronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1)) * 86400000L;
                                }
                                case DATETIME: {
                                    if (leftType == ATypeTag.DATETIME) {
                                        this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
                                        resultType = ATypeTag.DATETIME;
                                        chronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                                    }
                                    switch (rightType) {
                                        case DURATION: {
                                            yearMonth = ADurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1));
                                            dayTime = ADurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                                            break block7;
                                        }
                                        case YEARMONTHDURATION: {
                                            yearMonth = AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1));
                                            break block7;
                                        }
                                        case DAYTIMEDURATION: {
                                            dayTime = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1));
                                            break block7;
                                        }
                                    }
                                    throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                }
                                case YEARMONTHDURATION: {
                                    yearMonth = AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes0, (int)(offset0 + 1));
                                    switch (rightType) {
                                        case DATETIME: {
                                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
                                            resultType = ATypeTag.DATETIME;
                                            chronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                            break block7;
                                        }
                                        case DATE: {
                                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
                                            resultType = ATypeTag.DATE;
                                            chronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1)) * 86400000L;
                                            break block7;
                                        }
                                    }
                                    throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                }
                                case DURATION: {
                                    yearMonth = ADurationSerializerDeserializer.getYearMonth((byte[])bytes0, (int)(offset0 + 1));
                                    dayTime = ADurationSerializerDeserializer.getDayTime((byte[])bytes0, (int)(offset0 + 1));
                                }
                                case DAYTIMEDURATION: {
                                    if (leftType == ATypeTag.DAYTIMEDURATION) {
                                        dayTime = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes0, (int)(offset0 + 1));
                                    }
                                    switch (rightType) {
                                        case DATETIME: {
                                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
                                            resultType = ATypeTag.DATETIME;
                                            chronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                            break block7;
                                        }
                                        case DATE: {
                                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
                                            resultType = ATypeTag.DATE;
                                            chronon = (long)ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1)) * 86400000L;
                                            break block7;
                                        }
                                        case TIME: {
                                            if (yearMonth != 0) break;
                                            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ATIME);
                                            resultType = ATypeTag.TIME;
                                            chronon = ATimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                            isTimeOnly = true;
                                            break block7;
                                        }
                                    }
                                    throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                }
                                default: {
                                    throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                }
                            }
                            chronon = AbstractNumericArithmeticEval.this.evaluateTimeDurationArithmetic(chronon, yearMonth, dayTime, isTimeOnly);
                            switch (resultType) {
                                case DATE: {
                                    chronon = chronon < 0L && chronon % 86400000L != 0L ? chronon / 86400000L - 1L : (chronon /= 86400000L);
                                    this.aDate.setValue((int)chronon);
                                    this.serde.serialize((Object)this.aDate, this.out);
                                    break;
                                }
                                case TIME: {
                                    this.aTime.setValue((int)chronon);
                                    this.serde.serialize((Object)this.aTime, this.out);
                                    break;
                                }
                                case DATETIME: {
                                    this.aDatetime.setValue(chronon);
                                    this.serde.serialize((Object)this.aDatetime, this.out);
                                    break;
                                }
                                default: {
                                    throw new IncompatibleTypeException(AbstractNumericArithmeticEval.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                                }
                            }
                        }
                    }
                };
            }
        };
    }
}

