/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractBinaryStringEval$_EvaluatorGen
implements IScalarEvaluator {
    private IScalarEvaluator evalLeft;
    private IScalarEvaluator evalRight;
    private IPointable argPtrLeft = new VoidPointable();
    private IPointable argPtrSecond = new VoidPointable();
    private final UTF8StringPointable leftPtr = new UTF8StringPointable();
    private final UTF8StringPointable rightPtr = new UTF8StringPointable();
    protected ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected DataOutput dataOutput = this.resultStorage.getDataOutput();
    private final FunctionIdentifier funcID;
    private final TypeChecker typeChecker;

    public AbstractBinaryStringEval$_EvaluatorGen(IHyracksTaskContext context, IScalarEvaluatorFactory evalLeftFactory, IScalarEvaluatorFactory evalRightFactory, FunctionIdentifier funcID) throws HyracksDataException {
        this.evalLeft = evalLeftFactory.createScalarEvaluator(context);
        this.evalRight = evalRightFactory.createScalarEvaluator(context);
        this.funcID = funcID;
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
        this.resultStorage.reset();
        this.evalLeft.evaluate(tuple, this.argPtrLeft);
        if (this.typeChecker.isMissing(this.argPtrLeft, resultPointable)) {
            return;
        }
        byte[] bytes0 = this.argPtrLeft.getByteArray();
        int offset0 = this.argPtrLeft.getStartOffset();
        int len0 = this.argPtrLeft.getLength();
        this.evalRight.evaluate(tuple, this.argPtrSecond);
        if (this.typeChecker.isMissing(this.argPtrSecond, resultPointable)) {
            return;
        }
        if (this.typeChecker.isNull(resultPointable)) {
            return;
        }
        byte[] bytes1 = this.argPtrSecond.getByteArray();
        int offset1 = this.argPtrSecond.getStartOffset();
        int len1 = this.argPtrSecond.getLength();
        if (bytes0[offset0] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            throw new TypeMismatchException(this.funcID, (Integer)0, bytes0[offset0], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
        if (bytes1[offset1] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            throw new TypeMismatchException(this.funcID, (Integer)1, bytes1[offset1], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
        this.leftPtr.set(bytes0, offset0 + 1, len0 - 1);
        this.rightPtr.set(bytes1, offset1 + 1, len1 - 1);
        try {
            this.process(this.leftPtr, this.rightPtr, resultPointable);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected abstract void process(UTF8StringPointable var1, UTF8StringPointable var2, IPointable var3) throws IOException;
}

