/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.constructors.AInt16ConstructorDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class AInt16ConstructorDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable inputArg = new VoidPointable();
    private IScalarEvaluator eval;
    private short value;
    private int offset;
    private boolean positive;
    private AMutableInt16 aInt16;
    private ISerializerDeserializer<AInt16> int16Serde;
    private final UTF8StringPointable utf8Ptr;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ AInt16ConstructorDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    AInt16ConstructorDescriptor$_EvaluatorGen(AInt16ConstructorDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.aInt16 = new AMutableInt16(0);
        this.int16Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT16);
        this.utf8Ptr = new UTF8StringPointable();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        block14: {
            try {
                this.eval.evaluate(tuple, this.inputArg);
                if (this.typeChecker.isMissing(this.inputArg, result)) {
                    return;
                }
                if (this.typeChecker.isNull(result)) {
                    return;
                }
                byte[] serString = this.inputArg.getByteArray();
                int startOffset = this.inputArg.getStartOffset();
                int len = this.inputArg.getLength();
                byte tt = serString[startOffset];
                if (tt == ATypeTag.SERIALIZED_INT16_TYPE_TAG) {
                    result.set((IValueReference)this.inputArg);
                    break block14;
                }
                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                    this.resultStorage.reset();
                    this.utf8Ptr.set(serString, startOffset + 1, len - 1);
                    this.offset = this.utf8Ptr.getCharStartOffset();
                    this.value = 0;
                    this.positive = true;
                    int limit = -32767;
                    if (serString[this.offset] == 43) {
                        ++this.offset;
                    } else if (serString[this.offset] == 45) {
                        ++this.offset;
                        this.positive = false;
                        limit = Short.MIN_VALUE;
                    }
                    int end = startOffset + len;
                    while (this.offset < end) {
                        if (serString[this.offset] < 48 || serString[this.offset] > 57) {
                            if (serString[this.offset] == 105 && serString[this.offset + 1] == 49 && serString[this.offset + 2] == 54 && this.offset + 3 == end) break;
                            throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INT16_TYPE_TAG);
                        }
                        this.value = (short)(this.value * 10);
                        int digit = serString[this.offset] - 48;
                        if (this.value < limit + digit) {
                            throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INT16_TYPE_TAG);
                        }
                        this.value = (short)(this.value - digit);
                        ++this.offset;
                    }
                    if (this.value > 0) {
                        throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_INT16_TYPE_TAG);
                    }
                    if (this.value < 0 && this.positive) {
                        this.value = (short)(this.value * -1);
                    }
                    this.aInt16.setValue(this.value);
                    this.int16Serde.serialize((Object)this.aInt16, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break block14;
                }
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            }
            catch (IOException e) {
                throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), e, ATypeTag.SERIALIZED_INT16_TYPE_TAG);
            }
        }
    }
}

