/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.comparisons;

import java.io.DataOutput;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.comparisons.ComparisonHelper;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractComparisonEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    protected ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected DataOutput out = this.resultStorage.getDataOutput();
    protected TaggedValuePointable argLeft = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    protected TaggedValuePointable argRight = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    protected IPointable outLeft = VoidPointable.FACTORY.createPointable();
    protected IPointable outRight = VoidPointable.FACTORY.createPointable();
    protected IScalarEvaluator evalLeft;
    protected IScalarEvaluator evalRight;
    private ComparisonHelper ch = new ComparisonHelper();
    protected ISerializerDeserializer<ABoolean> serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    protected ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
    private final TypeChecker typeChecker;

    public AbstractComparisonEvaluator$_EvaluatorGen(IScalarEvaluatorFactory evalLeftFactory, IScalarEvaluatorFactory evalRightFactory, IHyracksTaskContext context) throws HyracksDataException {
        this.evalLeft = evalLeftFactory.createScalarEvaluator(context);
        this.evalRight = evalRightFactory.createScalarEvaluator(context);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.evalLeft.evaluate(tuple, (IPointable)this.argLeft);
        if (this.typeChecker.isMissing((IPointable)this.argLeft, result)) {
            return;
        }
        this.evalRight.evaluate(tuple, (IPointable)this.argRight);
        if (this.typeChecker.isMissing((IPointable)this.argRight, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        this.argLeft.getValue(this.outLeft);
        this.argRight.getValue(this.outRight);
        if (this.isTotallyOrderable()) {
            this.checkTotallyOrderable();
        }
        if (this.comparabilityCheck()) {
            int r = this.compareResults();
            ABoolean b = this.getComparisonResult(r) ? ABoolean.TRUE : ABoolean.FALSE;
            this.serde.serialize((Object)b, this.out);
        } else {
            this.nullSerde.serialize((Object)ANull.NULL, this.out);
        }
        result.set((IValueReference)this.resultStorage);
    }

    protected abstract boolean isTotallyOrderable();

    protected abstract boolean getComparisonResult(int var1);

    protected void checkTotallyOrderable() throws HyracksDataException {
        if (this.argLeft.getLength() != 0) {
            ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argLeft.getTag());
            switch (typeTag) {
                case DURATION: 
                case INTERVAL: 
                case LINE: 
                case POINT: 
                case POINT3D: 
                case POLYGON: 
                case CIRCLE: 
                case RECTANGLE: {
                    throw new UnsupportedTypeException("comparison operations (>, >=, <, and <=)", this.argLeft.getTag());
                }
            }
            return;
        }
    }

    protected boolean comparabilityCheck() {
        ATypeTag typeTag1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argLeft.getTag());
        ATypeTag typeTag2 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argRight.getTag());
        return ATypeHierarchy.isCompatible((ATypeTag)typeTag1, (ATypeTag)typeTag2);
    }

    protected int compareResults() throws HyracksDataException {
        int result = this.ch.compare((ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argLeft.getTag()), (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argRight.getTag()), this.outLeft, this.outRight);
        return result;
    }
}

