/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APolygonSerializerDeserializer;
import org.apache.asterix.runtime.evaluators.common.DoubleArray;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class SpatialUtils {
    private double xAxis;
    private double yAxis;
    private double minProjection;
    private double maxProjection;
    private static final double doubleEpsilon = SpatialUtils.computeDoubleEpsilon();
    private static final double pi = 3.14159265;

    private static double computeDoubleEpsilon() {
        double doubleEpsilon = 1.0;
        while (1.0 + (doubleEpsilon /= 2.0) / 2.0 != 1.0) {
        }
        return doubleEpsilon;
    }

    public static double doubleEpsilon() {
        return doubleEpsilon;
    }

    public double getMinProjection() {
        return this.minProjection;
    }

    public void setMinProjection(double minProjection) {
        this.minProjection = minProjection;
    }

    public double getMaxProjection() {
        return this.maxProjection;
    }

    public void setMaxProjection(double maxProjection) {
        this.maxProjection = maxProjection;
    }

    public double getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(double xAxis) {
        this.xAxis = xAxis;
    }

    public double getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(double yAxis) {
        this.yAxis = yAxis;
    }

    public static final double pi() {
        return 3.14159265;
    }

    public static final double dotProduct(double x1, double y1, double x2, double y2) {
        return x1 * x2 + y1 * y2;
    }

    public static final double crossProduct(double x1, double y1, double x2, double y2) {
        return x1 * y2 - y1 * x2;
    }

    public static final double polygonArea(byte[] bytes, int offset, int numOfPoints) throws HyracksDataException {
        double area = 0.0;
        for (int i = 0; i < numOfPoints; ++i) {
            double y2;
            double x2;
            double x1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + APolygonSerializerDeserializer.getCoordinateOffset((int)i, (Coordinate)Coordinate.X)));
            double y1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + APolygonSerializerDeserializer.getCoordinateOffset((int)i, (Coordinate)Coordinate.Y)));
            if (i + 1 == numOfPoints) {
                x2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + APolygonSerializerDeserializer.getCoordinateOffset((int)0, (Coordinate)Coordinate.X)));
                y2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + APolygonSerializerDeserializer.getCoordinateOffset((int)0, (Coordinate)Coordinate.Y)));
            } else {
                x2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + APolygonSerializerDeserializer.getCoordinateOffset((int)(i + 1), (Coordinate)Coordinate.X)));
                y2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + APolygonSerializerDeserializer.getCoordinateOffset((int)(i + 1), (Coordinate)Coordinate.Y)));
            }
            area += x1 * y2 - x2 * y1;
        }
        return area * 0.5;
    }

    public void projectPolygon(DoubleArray trianglesX, DoubleArray trianglesY, int triangleId, double xAxis, double yAxis) throws HyracksDataException {
        double max;
        double min = max = SpatialUtils.getTriangleXCoordinate(trianglesX, triangleId, 0) * xAxis + SpatialUtils.getTriangleYCoordinate(trianglesY, triangleId, 0) * yAxis;
        for (int i = 1; i < 3; ++i) {
            double temp = SpatialUtils.getTriangleXCoordinate(trianglesX, triangleId, i) * xAxis + SpatialUtils.getTriangleYCoordinate(trianglesY, triangleId, i) * yAxis;
            if (temp > max) {
                max = temp;
                continue;
            }
            if (!(temp < min)) continue;
            min = temp;
        }
        this.setMinProjection(min);
        this.setMaxProjection(max);
    }

    public void findNormals(DoubleArray trianglesX, DoubleArray trianglesY, int triangleId, int side) throws HyracksDataException {
        double y;
        double x;
        if (side == 0) {
            x = SpatialUtils.getTriangleYCoordinate(trianglesY, triangleId, 2) - SpatialUtils.getTriangleYCoordinate(trianglesY, triangleId, side);
            y = SpatialUtils.getTriangleXCoordinate(trianglesX, triangleId, side) - SpatialUtils.getTriangleXCoordinate(trianglesX, triangleId, 2);
        } else {
            x = SpatialUtils.getTriangleYCoordinate(trianglesY, triangleId, side - 1) - SpatialUtils.getTriangleYCoordinate(trianglesY, triangleId, side);
            y = SpatialUtils.getTriangleXCoordinate(trianglesX, triangleId, side) - SpatialUtils.getTriangleXCoordinate(trianglesX, triangleId, side - 1);
        }
        double temp = Math.sqrt(SpatialUtils.dotProduct(x, y, x, y));
        this.setXAxis(x /= temp);
        this.setYAxis(y /= temp);
    }

    public static double getTriangleXCoordinate(DoubleArray trianglesX, int triangleId, int point) {
        return trianglesX.get(triangleId * 3 + point);
    }

    public static double getTriangleYCoordinate(DoubleArray trianglesY, int triangleId, int point) {
        return trianglesY.get(triangleId * 3 + point);
    }

    public static void setTriangleXCoordinate(DoubleArray trianglesX, int triangleId, int point, double value) {
        trianglesX.get()[triangleId * 3 + point] = value;
    }

    public static void setTriangleYCoordinate(DoubleArray trianglesY, int triangleId, int point, double value) {
        trianglesY.get()[triangleId * 3 + point] = value;
    }
}

