/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ListAccessor {
    protected byte[] listBytes;
    protected int start;
    protected ATypeTag listType;
    protected ATypeTag itemType;
    protected int size;

    public ATypeTag getListType() {
        return this.listType;
    }

    public ATypeTag getItemType() {
        return this.itemType;
    }

    public boolean itemsAreSelfDescribing() {
        return this.itemType == ATypeTag.ANY;
    }

    public void reset(byte[] listBytes, int start) throws HyracksDataException {
        this.listBytes = listBytes;
        this.start = start;
        byte typeTag = listBytes[start];
        if (typeTag != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG && typeTag != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
            throw new TypeMismatchException("list-accessor", (Integer)0, listBytes[start], ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
        }
        this.listType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listBytes[start]);
        this.itemType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listBytes[start + 1]);
        this.size = listBytes[start] == ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG ? AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])listBytes, (int)start) : AOrderedListSerializerDeserializer.getNumberOfItems((byte[])listBytes, (int)start);
    }

    public int size() {
        return this.size;
    }

    public int getItemOffset(int itemIndex) throws HyracksDataException {
        if (this.listType == ATypeTag.MULTISET) {
            return AUnorderedListSerializerDeserializer.getItemOffset((byte[])this.listBytes, (int)this.start, (int)itemIndex);
        }
        return AOrderedListSerializerDeserializer.getItemOffset((byte[])this.listBytes, (int)this.start, (int)itemIndex);
    }

    public int getItemLength(int itemOffset) throws HyracksDataException {
        ATypeTag itemType = this.getItemType(itemOffset);
        return NonTaggedFormatUtil.getFieldValueLength((byte[])this.listBytes, (int)itemOffset, (ATypeTag)itemType, (boolean)this.itemsAreSelfDescribing());
    }

    public ATypeTag getItemType(int itemOffset) {
        if (this.itemType == ATypeTag.ANY) {
            return (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.listBytes[itemOffset]);
        }
        return this.itemType;
    }

    public void writeItem(int itemIndex, DataOutput dos) throws IOException {
        int itemOffset = this.getItemOffset(itemIndex);
        int itemLength = this.getItemLength(itemOffset);
        if (this.itemsAreSelfDescribing()) {
            ++itemLength;
        } else {
            dos.writeByte(this.itemType.serialize());
        }
        dos.write(this.listBytes, itemOffset, itemLength);
    }

    public byte[] getByteArray() {
        return this.listBytes;
    }

    public int getStart() {
        return this.start;
    }
}

