/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.accessors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.accessors.TemporalMonthAccessor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class TemporalMonthAccessor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable argPtr = new VoidPointable();
    private final IScalarEvaluator eval;
    private final GregorianCalendarSystem calSystem;
    private final ISerializerDeserializer<AInt64> intSerde;
    private final AMutableInt64 aMutableInt64;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ TemporalMonthAccessor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    TemporalMonthAccessor$_EvaluatorGen(TemporalMonthAccessor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.calSystem = GregorianCalendarSystem.getInstance();
        this.intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
        this.aMutableInt64 = new AMutableInt64(0L);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.eval.evaluate(tuple, this.argPtr);
        if (this.typeChecker.isMissing(this.argPtr, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] bytes = this.argPtr.getByteArray();
        int startOffset = this.argPtr.getStartOffset();
        this.resultStorage.reset();
        try {
            if (bytes[startOffset] == ATypeTag.SERIALIZED_DURATION_TYPE_TAG) {
                this.aMutableInt64.setValue((long)this.calSystem.getDurationMonth(ADurationSerializerDeserializer.getYearMonth((byte[])bytes, (int)(startOffset + 1))));
                this.intSerde.serialize((Object)this.aMutableInt64, this.out);
                result.set((IValueReference)this.resultStorage);
                return;
            }
            if (bytes[startOffset] == ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG) {
                this.aMutableInt64.setValue((long)this.calSystem.getDurationMonth(AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes, (int)(startOffset + 1))));
                this.intSerde.serialize((Object)this.aMutableInt64, this.out);
                result.set((IValueReference)this.resultStorage);
                return;
            }
            long chrononTimeInMs = 0L;
            if (bytes[startOffset] == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                chrononTimeInMs = (long)AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(startOffset + 1)) * 86400000L;
            } else if (bytes[startOffset] == ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
                chrononTimeInMs = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(startOffset + 1));
            } else {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)0, bytes[startOffset], ATypeTag.SERIALIZED_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
            }
            int year = this.calSystem.getYear(chrononTimeInMs);
            int month = this.calSystem.getMonthOfYear(chrononTimeInMs, year);
            this.aMutableInt64.setValue((long)month);
            this.intSerde.serialize((Object)this.aMutableInt64, this.out);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

