/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.serializable.std;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.aggregates.serializable.std.BufferSerDeUtil;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.ISerializedAggregateEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractSerializableSumAggregateFunction
implements ISerializedAggregateEvaluator {
    protected static final int AGG_TYPE_OFFSET = 0;
    private static final int SUM_OFFSET = 1;
    private IPointable inputVal = new VoidPointable();
    private IScalarEvaluator eval;
    private AMutableDouble aDouble = new AMutableDouble(0.0);
    private AMutableFloat aFloat = new AMutableFloat(0.0f);
    private AMutableInt64 aInt64 = new AMutableInt64(0L);
    private AMutableInt32 aInt32 = new AMutableInt32(0);
    private AMutableInt16 aInt16 = new AMutableInt16(0);
    private AMutableInt8 aInt8 = new AMutableInt8(0);
    public ISerializerDeserializer serde;

    public AbstractSerializableSumAggregateFunction(IScalarEvaluatorFactory[] args, IHyracksTaskContext context) throws HyracksDataException {
        this.eval = args[0].createScalarEvaluator(context);
    }

    public void init(DataOutput state) throws HyracksDataException {
        try {
            state.writeByte(ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
            state.writeDouble(0.0);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void step(IFrameTupleReference tuple, byte[] state, int start, int len) throws HyracksDataException {
        if (this.skipStep(state, start)) {
            return;
        }
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 0]);
        double sum = BufferSerDeUtil.getDouble(state, start + 1);
        this.eval.evaluate(tuple, this.inputVal);
        byte[] bytes = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
        if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
            this.processNull(state, start);
            return;
        }
        if (aggType == ATypeTag.SYSTEM_NULL) {
            aggType = typeTag;
        } else if (typeTag != ATypeTag.SYSTEM_NULL && !ATypeHierarchy.isCompatible((ATypeTag)typeTag, (ATypeTag)aggType)) {
            throw new IncompatibleTypeException(BuiltinFunctions.SUM, bytes[offset], aggType.serialize());
        }
        if (ATypeHierarchy.canPromote((ATypeTag)aggType, (ATypeTag)typeTag)) {
            aggType = typeTag;
        }
        switch (typeTag) {
            case TINYINT: {
                byte val = AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(offset + 1));
                sum += (double)val;
                break;
            }
            case SMALLINT: {
                short val = AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(offset + 1));
                sum += (double)val;
                break;
            }
            case INTEGER: {
                int val = AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(offset + 1));
                sum += (double)val;
                break;
            }
            case BIGINT: {
                long val = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(offset + 1));
                sum += (double)val;
                break;
            }
            case FLOAT: {
                float val = AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)(offset + 1));
                sum += (double)val;
                break;
            }
            case DOUBLE: {
                double val = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1));
                sum += val;
                break;
            }
            case NULL: {
                aggType = typeTag;
                break;
            }
            case SYSTEM_NULL: {
                this.processSystemNull();
                break;
            }
            default: {
                throw new UnsupportedItemTypeException(BuiltinFunctions.SUM, bytes[offset]);
            }
        }
        state[start + 0] = aggType.serialize();
        BufferSerDeUtil.writeDouble(sum, state, start + 1);
    }

    public void finish(byte[] state, int start, int len, DataOutput out) throws HyracksDataException {
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 0]);
        double sum = BufferSerDeUtil.getDouble(state, start + 1);
        try {
            switch (aggType) {
                case TINYINT: {
                    this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
                    this.aInt8.setValue((byte)sum);
                    this.serde.serialize((Object)this.aInt8, out);
                    break;
                }
                case SMALLINT: {
                    this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT16);
                    this.aInt16.setValue((short)sum);
                    this.serde.serialize((Object)this.aInt16, out);
                    break;
                }
                case INTEGER: {
                    this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                    this.aInt32.setValue((int)sum);
                    this.serde.serialize((Object)this.aInt32, out);
                    break;
                }
                case BIGINT: {
                    this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                    this.aInt64.setValue((long)sum);
                    this.serde.serialize((Object)this.aInt64, out);
                    break;
                }
                case FLOAT: {
                    this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
                    this.aFloat.setValue((float)sum);
                    this.serde.serialize((Object)this.aFloat, out);
                    break;
                }
                case DOUBLE: {
                    this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                    this.aDouble.setValue(sum);
                    this.serde.serialize((Object)this.aDouble, out);
                    break;
                }
                case NULL: {
                    this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
                    this.serde.serialize((Object)ANull.NULL, out);
                    break;
                }
                case SYSTEM_NULL: {
                    this.finishSystemNull(out);
                    break;
                }
                default: {
                    throw new UnsupportedItemTypeException(BuiltinFunctions.SUM, aggType.serialize());
                }
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void finishPartial(byte[] state, int start, int len, DataOutput out) throws HyracksDataException {
        this.finish(state, start, len, out);
    }

    protected boolean skipStep(byte[] state, int start) {
        return false;
    }

    protected abstract void processNull(byte[] var1, int var2);

    protected abstract void processSystemNull() throws HyracksDataException;

    protected abstract void finishSystemNull(DataOutput var1) throws IOException;
}

